/*
 * Decompiled with CFR 0.152.
 */
package jade.cli;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.WrapperBehaviour;
import jade.util.Logger;

public class CLIAdminExecutorAgent
extends Agent {
    private static final long serialVersionUID = -5324872230110030797L;
    private Logger myLogger = Logger.getMyLogger((String)((Object)((Object)this)).getClass().getName());

    public CLIAdminExecutorAgent() {
        this.setEnabledO2ACommunication(true, 0);
    }

    protected void setup() {
        CyclicBehaviour b = new CyclicBehaviour(this){
            private static final long serialVersionUID = -8186998548310024382L;

            public void action() {
                Object obj = this.myAgent.getO2AObject();
                if (obj != null) {
                    if (obj instanceof Behaviour) {
                        CLIAdminExecutorAgent.this.process((Behaviour)obj);
                    } else {
                        CLIAdminExecutorAgent.this.myLogger.log(Logger.WARNING, "Unexpected Object received: " + obj);
                        CLIAdminExecutorAgent.this.doDelete();
                    }
                } else {
                    this.block();
                }
            }
        };
        this.setO2AManager((Behaviour)b);
        this.addBehaviour((Behaviour)b);
    }

    private void process(Behaviour b) {
        this.addBehaviour((Behaviour)new WrapperBehaviour(b){
            private static final long serialVersionUID = 8791614876400432467L;

            public void onStart() {
                CLIAdminExecutorAgent.this.myLogger.log(Logger.INFO, "Starting execution of behaviour " + this.getWrappedBehaviour().getBehaviourName());
                super.onStart();
            }

            public int onEnd() {
                int result = super.onEnd();
                CLIAdminExecutorAgent.this.myLogger.log(Logger.INFO, "Execution of behaviour " + this.getWrappedBehaviour().getBehaviourName() + " terminated");
                this.myAgent.doDelete();
                return result;
            }
        });
    }
}

