/*
 * Decompiled with CFR 0.152.
 */
package jade.cli;

import jade.cli.Option;
import jade.core.behaviours.Behaviour;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Properties;

public abstract class CLICommand {
    public static final String HELP_OPTION = "help";
    public static final String LOGS_OPTION = "logs";
    protected PrintStream out;

    void setPrintStream(PrintStream out) {
        this.out = out;
    }

    public void printUsage() {
        this.out.println("USAGE: java -cp ... " + this.getClass().getName() + " [options]");
        this.out.println();
        this.out.println("Valid options:");
        this.printCommandSpecificOptions();
        this.out.println("-help: Print this help and terminate");
        this.out.println("-logs: Enable normal JADE logs");
        this.out.println("All JADE Split-Container options (see JADE documentation)");
    }

    void printCommandSpecificOptions() {
        Field[] fields;
        for (Field f : fields = this.getClass().getFields()) {
            Option opt = f.getAnnotation(Option.class);
            if (opt == null || String.class != f.getType()) continue;
            try {
                String optionName = (String)f.get(this);
                this.out.println("-" + optionName + " " + opt.value() + ": " + opt.description());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public abstract Behaviour getBehaviour(Properties var1) throws IllegalArgumentException;
}

