/*
 * Decompiled with CFR 0.152.
 */
package jade.cli;

import jade.cli.CLIAdminExecutorAgent;
import jade.cli.CLICommand;
import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.ContentElementList;
import jade.content.ContentException;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.core.Agent;
import jade.core.MicroRuntime;
import jade.core.behaviours.Behaviour;
import jade.domain.FIPAException;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.lang.acl.ACLMessage;
import jade.util.ExtendedProperties;
import jade.wrapper.AgentController;
import jade.wrapper.ControllerException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class CLIManager {
    public static final String CLI_ADMIN_EXECUTOR_NAME = "cliAdminExecutor";
    private static String cliAdminExecutorName = "cliAdminExecutor";

    public static Properties parseCommandLine(String[] args) throws IllegalArgumentException {
        ExtendedProperties props = new ExtendedProperties();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    String name = args[i].substring(1);
                    if (name.equals("help") || name.equals("logs")) {
                        props.setProperty(name, "true");
                        continue;
                    }
                    if (++i < args.length) {
                        props.setProperty(name, args[i]);
                        continue;
                    }
                    throw new IllegalArgumentException("No value specified for property \"" + name + "\"");
                }
                throw new IllegalArgumentException("Invalid argument " + args[i] + ": options must have the form \"-key value\"");
            }
        }
        return props;
    }

    public static String getMandatoryOption(String optionName, Properties pp) throws IllegalArgumentException {
        String value = pp.getProperty(optionName);
        if (value == null) {
            throw new IllegalArgumentException("Missing mandatory option -" + optionName);
        }
        return value;
    }

    public static void disableLogs() {
        LogManager logManager = LogManager.getLogManager();
        Logger rootLogger = logManager.getLogger("");
        rootLogger.setLevel(Level.WARNING);
    }

    public static void execute(CLICommand command, String[] args) {
        command.setPrintStream(System.out);
        try {
            Properties pp = CLIManager.parseCommandLine(args);
            if ("true".equalsIgnoreCase(pp.getProperty("help", null))) {
                command.printUsage();
            } else {
                Behaviour b = command.getBehaviour(pp);
                CLIManager.execute(pp, b, true);
            }
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
            command.printUsage();
        }
        catch (ControllerException ce) {
            System.out.println("Error connecting to the remote JADE system. Use the -logs option to see JADE specific logs");
        }
    }

    public static void execute(String agentName, Properties pp, Behaviour b, boolean exitOnTermination) throws ControllerException {
        cliAdminExecutorName = agentName;
        CLIManager.execute(pp, b, exitOnTermination);
    }

    public static void execute(Properties pp, Behaviour b, final boolean exitOnTermination) throws ControllerException {
        if (!"true".equalsIgnoreCase(pp.getProperty("logs", null))) {
            CLIManager.disableLogs();
        }
        pp.setProperty("exitwhenempty", "true");
        pp.setProperty("agents", cliAdminExecutorName + ":" + CLIAdminExecutorAgent.class.getName());
        MicroRuntime.startJADE((jade.util.leap.Properties)((jade.util.leap.Properties)pp), (Runnable)new Runnable(){

            public void run() {
                if (exitOnTermination) {
                    try {
                        Thread.sleep(1000L);
                        System.exit(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        AgentController executor = MicroRuntime.getAgent((String)cliAdminExecutorName);
        executor.putO2AObject((Object)b, false);
    }

    public static ACLMessage createAMSRequest(Agent a, AgentAction act) throws ContentException {
        Action actExpr = new Action();
        actExpr.setActor(a.getAMS());
        actExpr.setAction((Concept)act);
        SLCodec codec = new SLCodec();
        a.getContentManager().registerOntology(JADEManagementOntology.getInstance());
        a.getContentManager().registerLanguage((Codec)codec, "fipa-sl0");
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(a.getAMS());
        request.setProtocol("fipa-request");
        request.setLanguage("fipa-sl0");
        request.setOntology("JADE-Agent-Management");
        a.getContentManager().fillContent(request, (ContentElement)actExpr);
        return request;
    }

    public static void printFipaException(Agent a, FIPAException fe) {
        ACLMessage msg = fe.getACLMessage();
        try {
            ContentElementList l;
            ContentElement ce = a.getContentManager().extractContent(msg);
            if (ce instanceof Exception) {
                System.out.println(((Exception)ce).getMessage());
                return;
            }
            if (ce instanceof ContentElementList && (l = (ContentElementList)ce).size() == 2 && (ce = l.get(1)) instanceof Exception) {
                System.out.println(((Exception)ce).getMessage());
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(fe.getMessage());
    }
}

