/*
 * Decompiled with CFR 0.152.
 */
package jade.cli;

import jade.cli.CLICommand;
import jade.cli.CLIManager;
import jade.cli.Option;
import jade.content.AgentAction;
import jade.core.Agent;
import jade.core.ContainerID;
import jade.core.Specifier;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import java.util.Properties;
import java.util.Vector;

public class CreateAgent
extends CLICommand {
    @Option(value="<name>", description="The name of the agent to be created")
    public static final String AGENT_NAME_OPTION = "agent-name";
    @Option(value="<class name>", description="The fully qualified class name of the agent to be created")
    public static final String CLASS_NAME_OPTION = "class-name";
    @Option(value="<argument list>", description="A list of comma-separated arguments. No spaces are allowed (optional)")
    public static final String ARGUMENTS_OPTION = "arguments";
    @Option(value="<container-name>", description="The container where to create the new agent")
    public static final String CONTAINER_OPTION = "container";

    public static void main(String[] args) {
        CLIManager.execute(new CreateAgent(), args);
    }

    public Behaviour getBehaviour(Properties pp) throws IllegalArgumentException {
        final String agentName = CLIManager.getMandatoryOption(AGENT_NAME_OPTION, pp);
        final String className = CLIManager.getMandatoryOption(CLASS_NAME_OPTION, pp);
        final String argumentsList = pp.getProperty(ARGUMENTS_OPTION);
        final String containerName = CLIManager.getMandatoryOption(CONTAINER_OPTION, pp);
        return new OneShotBehaviour(null){

            public void action() {
                jade.domain.JADEAgentManagement.CreateAgent ca = new jade.domain.JADEAgentManagement.CreateAgent();
                ca.setAgentName(agentName);
                ca.setClassName(className);
                ca.setContainer(new ContainerID(containerName, null));
                if (argumentsList != null) {
                    Vector v = Specifier.parseList((String)argumentsList, (char)',');
                    for (Object a : v) {
                        ca.addArguments(a);
                    }
                }
                try {
                    ACLMessage request = CLIManager.createAMSRequest(this.myAgent, (AgentAction)ca);
                    ACLMessage response = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)request, (long)10000L);
                    if (response == null) {
                        CreateAgent.this.out.println("Timeout expired");
                    }
                }
                catch (FIPAException fe) {
                    CLIManager.printFipaException(this.myAgent, fe);
                }
                catch (Exception e) {
                    CreateAgent.this.out.println(e.getMessage());
                }
            }
        };
    }
}

