/*
 * Decompiled with CFR 0.152.
 */
package jade.cli;

import jade.cli.CLICommand;
import jade.cli.CLIManager;
import jade.cli.Option;
import jade.content.AgentAction;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ContainerID;
import jade.core.behaviours.Behaviour;
import jade.domain.FIPAService;
import jade.domain.JADEAgentManagement.WhereIsAgentAction;
import jade.lang.acl.ACLMessage;
import jade.proto.SimpleAchieveREInitiator;
import java.util.Properties;

public class DumpAgent
extends CLICommand {
    @Option(value="<container name>", description="The container where the target agent lives (optional)")
    public static final String CONTAINER_OPTION = "container";
    @Option(value="<agent local name>", description="The agent that must be dumped")
    public static final String AGENT_OPTION = "agent";
    private String agentName = null;
    private String containerName = null;

    public static void main(String[] args) {
        CLIManager.execute(new DumpAgent(), args);
    }

    public Behaviour getBehaviour(Properties pp) throws IllegalArgumentException {
        this.agentName = CLIManager.getMandatoryOption(AGENT_OPTION, pp);
        this.containerName = pp.getProperty(CONTAINER_OPTION);
        return new SimpleAchieveREInitiator(null, null){

            protected ACLMessage prepareRequest(ACLMessage unused) {
                ACLMessage req = null;
                try {
                    if (DumpAgent.this.containerName == null) {
                        DumpAgent.this.containerName = DumpAgent.this.retrieveContainerName(DumpAgent.this.agentName, this.myAgent);
                    }
                    req = new ACLMessage(16);
                    req.setSender(this.myAgent.getAID());
                    req.addReceiver(new AID("monitor-" + DumpAgent.this.containerName, false));
                    req.setOntology("container-monitor");
                    req.setContent("DUMP-AGENT " + DumpAgent.this.agentName);
                }
                catch (Exception e) {
                    DumpAgent.this.out.println(e.getMessage());
                }
                return req;
            }

            protected void handleInform(ACLMessage inform) {
                DumpAgent.this.out.println(inform.getContent());
            }

            protected void handleFailure(ACLMessage failure) {
                DumpAgent.this.out.println("ERROR: " + failure.getContent());
            }
        };
    }

    private String retrieveContainerName(String agentName, Agent a) throws Exception {
        WhereIsAgentAction wia = new WhereIsAgentAction();
        wia.setAgentIdentifier(new AID(agentName, false));
        ACLMessage request = CLIManager.createAMSRequest(a, (AgentAction)wia);
        ACLMessage response = FIPAService.doFipaRequestClient((Agent)a, (ACLMessage)request, (long)10000L);
        if (response != null) {
            Result result = (Result)a.getContentManager().extractContent(response);
            ContainerID cid = (ContainerID)result.getValue();
            return cid.getName();
        }
        throw new Exception("Timeout expired while retrieving container for agent " + agentName + " from the AMS");
    }
}

