/*
 * Decompiled with CFR 0.152.
 */
package jade.cli;

import jade.cli.CLICommand;
import jade.cli.CLIManager;
import jade.cli.Option;
import jade.content.AgentAction;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import java.util.Properties;

public class KillAgent
extends CLICommand {
    @Option(value="<name>", description="The name of the agent to be killed")
    public static final String AGENT_OPTION = "agent";

    public static void main(String[] args) {
        CLIManager.execute(new KillAgent(), args);
    }

    public Behaviour getBehaviour(Properties pp) throws IllegalArgumentException {
        final String agentName = CLIManager.getMandatoryOption(AGENT_OPTION, pp);
        return new OneShotBehaviour(null){

            public void action() {
                jade.domain.JADEAgentManagement.KillAgent ka = new jade.domain.JADEAgentManagement.KillAgent();
                ka.setAgent(new AID(agentName, false));
                try {
                    ACLMessage request = CLIManager.createAMSRequest(this.myAgent, (AgentAction)ka);
                    ACLMessage response = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)request, (long)10000L);
                    if (response == null) {
                        KillAgent.this.out.println("Timeout expired");
                    }
                }
                catch (FIPAException fe) {
                    CLIManager.printFipaException(this.myAgent, fe);
                }
                catch (Exception e) {
                    KillAgent.this.out.println(e.getMessage());
                }
            }
        };
    }
}

