/*
 * Decompiled with CFR 0.152.
 */
package jade.cli;

import jade.cli.CLICommand;
import jade.cli.CLIManager;
import jade.cli.Option;
import jade.content.AgentAction;
import jade.core.Agent;
import jade.core.ContainerID;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import java.util.Properties;

public class KillContainer
extends CLICommand {
    @Option(value="<name>", description="The name of the container to be killed")
    public static final String CONTAINER_OPTION = "container";

    public static void main(String[] args) {
        CLIManager.execute(new KillContainer(), args);
    }

    public Behaviour getBehaviour(Properties pp) throws IllegalArgumentException {
        final String containerName = CLIManager.getMandatoryOption(CONTAINER_OPTION, pp);
        return new OneShotBehaviour(null){

            public void action() {
                jade.domain.JADEAgentManagement.KillContainer kc = new jade.domain.JADEAgentManagement.KillContainer();
                kc.setContainer(new ContainerID(containerName, null));
                try {
                    ACLMessage request = CLIManager.createAMSRequest(this.myAgent, (AgentAction)kc);
                    ACLMessage response = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)request, (long)10000L);
                    if (response == null) {
                        KillContainer.this.out.println("Timeout expired");
                    }
                }
                catch (FIPAException fe) {
                    CLIManager.printFipaException(this.myAgent, fe);
                }
                catch (Exception e) {
                    KillContainer.this.out.println(e.getMessage());
                }
            }
        };
    }
}

