/*
 * Decompiled with CFR 0.152.
 */
package jade.cli;

import jade.cli.CLICommand;
import jade.cli.CLIManager;
import jade.cli.Option;
import jade.cli.behaviours.CreateRemoteLoggerControllerBehaviour;
import jade.cli.behaviours.InitializeLogManagerBehaviour;
import jade.cli.behaviours.SetLogLevelBehaviour;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.SequentialBehaviour;
import java.util.Properties;
import java.util.logging.Level;

public class SetLogLevel
extends CLICommand {
    @Option(value="<logger-name>", description="The name of the logger whose level must be set")
    public static final String LOGGER_OPTION = "logger";
    @Option(value="<container-name>", description="The container containing the target logger")
    public static final String CONTAINER_OPTION = "container";
    @Option(value="<SEVERE|WARNING|INFO|CONFIG|FINE|FINER|FINEST|ALL>", description="The new level (see java.util.loggiong.Level)")
    public static final String LEVEL_OPTION = "level";

    public static void main(String[] args) {
        CLIManager.execute(new SetLogLevel(), args);
    }

    public Behaviour getBehaviour(Properties pp) throws IllegalArgumentException {
        String loggerName = CLIManager.getMandatoryOption(LOGGER_OPTION, pp);
        String containerName = CLIManager.getMandatoryOption(CONTAINER_OPTION, pp);
        String levelStr = CLIManager.getMandatoryOption(LEVEL_OPTION, pp);
        Level level = Level.parse(levelStr);
        SequentialBehaviour sb = new SequentialBehaviour();
        sb.addSubBehaviour((Behaviour)new CreateRemoteLoggerControllerBehaviour(containerName));
        sb.addSubBehaviour((Behaviour)new InitializeLogManagerBehaviour());
        sb.addSubBehaviour((Behaviour)new SetLogLevelBehaviour(loggerName, level.intValue()));
        return sb;
    }
}

