/*
 * Decompiled with CFR 0.152.
 */
package jade.cli;

import jade.cli.CLICommand;
import jade.cli.CLIManager;
import jade.core.ServiceException;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.mobility.AgentMobilityHelper;
import jade.wrapper.gateway.DynamicJadeGateway;
import jade.wrapper.gateway.GatewayListener;
import jade.wrapper.gateway.JadeGateway;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class Shell
implements Runnable {
    private InputStream inp;
    private PrintStream out;
    private DynamicJadeGateway myGateway;
    private ClassLoader loader;

    public static void main(String[] args) {
        Properties pp = CLIManager.parseCommandLine(args);
        if (!"true".equalsIgnoreCase(pp.getProperty("logs", null))) {
            CLIManager.disableLogs();
        }
        if (pp.getProperty("container-name", null) == null) {
            pp.setProperty("container-name", "GW-JCLI-Shell");
        }
        jade.util.leap.Properties leapPP = new jade.util.leap.Properties();
        leapPP.putAll((Map)pp);
        JadeGateway.init(null, (jade.util.leap.Properties)leapPP);
        try {
            JadeGateway.checkJADE();
            Shell s = new Shell(System.in, System.out);
            s.run();
            JadeGateway.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Cannot connect to the platform at " + leapPP.getProperty("host") + ":" + leapPP.getProperty("port"));
        }
    }

    public Shell(InputStream inp, PrintStream out) {
        this(inp, out, JadeGateway.getDefaultGateway());
    }

    public Shell(InputStream inp, PrintStream out, DynamicJadeGateway gw) {
        this.inp = inp;
        this.out = out;
        this.myGateway = gw != null ? gw : JadeGateway.getDefaultGateway();
        this.myGateway.addListener(new GatewayListener(){

            public void handleGatewayConnected() {
            }

            public void handleGatewayDisconnected() {
                Shell.this.loader = null;
            }
        });
    }

    public void run() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.inp));
            String command = "";
            this.out.println();
            while (true) {
                this.out.print("JCLI>");
                command = br.readLine();
                if (command != null && !command.equals("exit")) {
                    if ((command = command.trim()).length() <= 0) continue;
                    this.processCommand(command);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void processCommand(String command) {
        StringTokenizer st = new StringTokenizer(command, " ");
        String commandClass = st.nextToken();
        ArrayList<String> argsList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            argsList.add(st.nextToken());
        }
        String[] args = argsList.toArray(new String[0]);
        CLICommand cmd = null;
        try {
            cmd = this.loadCLICommand(commandClass);
            cmd.setPrintStream(this.out);
            Properties commandProperties = CLIManager.parseCommandLine(args);
            if ("true".equalsIgnoreCase(commandProperties.getProperty("help", null))) {
                this.printUsage(cmd);
            } else {
                Behaviour b = cmd.getBehaviour(commandProperties);
                try {
                    this.myGateway.execute((Object)b);
                }
                catch (Exception e) {
                    this.out.println("Error executing command " + commandClass);
                    e.printStackTrace(this.out);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            this.out.println(iae.getMessage());
            this.printUsage(cmd);
        }
        catch (ClassNotFoundException cnfe) {
            this.out.println("Unrecognized command " + commandClass);
        }
        catch (Exception e) {
            this.out.println("Error loading command " + commandClass);
            e.printStackTrace(this.out);
        }
    }

    private CLICommand loadCLICommand(String commandClass) throws Exception {
        if (this.loader == null) {
            this.loader = this.getLoader();
        }
        return (CLICommand)Class.forName(commandClass, true, this.loader).newInstance();
    }

    private ClassLoader getLoader() throws Exception {
        ClassLoaderRetriever clr = new ClassLoaderRetriever();
        this.myGateway.execute((Object)clr);
        ServiceException exception = clr.getException();
        if (exception != null) {
            throw exception;
        }
        return clr.getLoader();
    }

    private void printUsage(CLICommand cmd) {
        this.out.println("USAGE: " + cmd.getClass().getName() + " [options]");
        this.out.println();
        this.out.println("Valid options:");
        cmd.printCommandSpecificOptions();
        this.out.println("-help: Print this help and terminate");
    }

    private class ClassLoaderRetriever
    extends OneShotBehaviour {
        private ServiceException exception;
        private ClassLoader cl;

        private ClassLoaderRetriever() {
        }

        public void action() {
            try {
                AgentMobilityHelper mh = (AgentMobilityHelper)this.myAgent.getHelper("jade.core.mobility.AgentMobility");
                this.cl = mh.getContainerClassLoader("Main-Container", Shell.class.getClassLoader());
            }
            catch (ServiceException e) {
                this.exception = e;
            }
        }

        public ServiceException getException() {
            return this.exception;
        }

        public ClassLoader getLoader() {
            return this.cl;
        }
    }
}

