/*
 * Decompiled with CFR 0.152.
 */
package jade.cli.behaviours;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ContainerID;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.domain.JADEAgentManagement.CreateAgent;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.lang.acl.ACLMessage;
import jade.tools.logging.ontology.LogManagementOntology;

public class CreateRemoteLoggerControllerBehaviour
extends OneShotBehaviour {
    private static final long serialVersionUID = -4820827332888712692L;
    private String containerName;

    public CreateRemoteLoggerControllerBehaviour(String containerName) {
        this.containerName = containerName == null || containerName.equals("") ? "Main-Container" : containerName;
    }

    public void action() {
        try {
            this.createController(this.containerName);
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    private AID createController(String containerName) throws FIPAException {
        ACLMessage request = this.createAMSRequest();
        CreateAgent ca = new CreateAgent();
        String localName = "loggerController";
        ca.setAgentName(localName);
        ca.setClassName("jade.tools.logging.LogHelperAgent");
        ca.addArguments((Object)this.myAgent.getAID());
        ca.setContainer(new ContainerID(containerName, null));
        Action act = new Action();
        act.setActor(this.myAgent.getAMS());
        act.setAction((Concept)ca);
        try {
            this.myAgent.getContentManager().registerOntology(JADEManagementOntology.getInstance());
            this.myAgent.getContentManager().registerOntology(LogManagementOntology.getInstance());
            this.myAgent.getContentManager().registerLanguage((Codec)new SLCodec(), "fipa-sl");
            this.myAgent.getContentManager().fillContent(request, (ContentElement)act);
            ACLMessage inform = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)request, (long)10000L);
            if (inform != null) {
                return new AID(localName, false);
            }
            throw new FIPAException("Response timeout expired");
        }
        catch (FIPAException fe) {
            throw fe;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ACLMessage createAMSRequest() {
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(this.myAgent.getAMS());
        request.setProtocol("fipa-request");
        request.setLanguage("fipa-sl");
        request.setOntology(JADEManagementOntology.getInstance().getName());
        return request;
    }
}

