/*
 * Decompiled with CFR 0.152.
 */
package jade.cli.behaviours;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.AMSService;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.tools.logging.JavaLoggingLogManagerImpl;
import jade.tools.logging.LogManager;
import jade.tools.logging.ontology.GetAllLoggers;
import jade.tools.logging.ontology.LogManagementOntology;
import jade.tools.logging.ontology.LoggerInfo;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.io.PrintStream;
import java.util.logging.Level;

public class GetLoggerInfoBehaviour
extends OneShotBehaviour {
    private static final long serialVersionUID = 8667957551752836265L;
    private LogManager myLogManager = new JavaLoggingLogManagerImpl();
    AID helperController = null;
    PrintStream out;

    public GetLoggerInfoBehaviour(PrintStream ps) {
        this.out = ps;
    }

    public void action() {
        try {
            AMSAgentDescription template = new AMSAgentDescription();
            template.setName(new AID("loggerController", false));
            SearchConstraints sc = new SearchConstraints();
            sc.setMaxResults(new Long(1L));
            AMSAgentDescription[] result = AMSService.search((Agent)this.myAgent, (AMSAgentDescription)template, (SearchConstraints)sc);
            if (result.length == 0) {
                throw new Exception("Remote logger controller not found");
            }
            this.helperController = result[0].getName();
            List logList = this.retrieveLogInfo();
            StringBuffer sb = new StringBuffer();
            sb.append("LEVEL    LOGGER-NAME\n");
            sb.append("--------------------\n");
            for (LoggerInfo logInfo : logList) {
                Level level = Level.parse(String.valueOf(logInfo.getLevel()));
                sb.append(String.format("%-8s %s\n", level.getName(), logInfo.getName()));
            }
            this.out.println(sb.toString());
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List retrieveLogInfo() throws FIPAException {
        List tmp = null;
        tmp = this.helperController != null ? this.remoteRetrieveLogInfo(this.helperController) : this.myLogManager.getAllLogInfo();
        ArrayList infos = new ArrayList(tmp.size());
        for (LoggerInfo li : tmp) {
            int i;
            String name = li.toString();
            for (i = 0; i < infos.size() && name.compareTo(infos.get(i).toString()) >= 0; ++i) {
            }
            infos.add(i, (Object)li);
        }
        return infos;
    }

    private List remoteRetrieveLogInfo(AID helper) throws FIPAException {
        ACLMessage request = this.createHelperRequest(helper);
        GetAllLoggers gal = new GetAllLoggers(this.myLogManager.getClass().getName(), null);
        Action act = new Action();
        act.setActor(helper);
        act.setAction((Concept)gal);
        try {
            this.myAgent.getContentManager().registerLanguage((Codec)new SLCodec());
            this.myAgent.getContentManager().registerOntology(LogManagementOntology.getInstance());
            this.myAgent.getContentManager().fillContent(request, (ContentElement)act);
            ACLMessage inform = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)request, (long)10000L);
            if (inform != null) {
                Result res = (Result)this.myAgent.getContentManager().extractContent(inform);
                return res.getItems();
            }
            throw new FIPAException("Response timeout expired");
        }
        catch (FIPAException fe) {
            throw fe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FIPAException(e.getMessage());
        }
    }

    private ACLMessage createHelperRequest(AID helper) {
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(helper);
        request.setProtocol("fipa-request");
        request.setLanguage("fipa-sl");
        request.setOntology(LogManagementOntology.getInstance().getName());
        return request;
    }
}

