/*
 * Decompiled with CFR 0.152.
 */
package jade.cli.behaviours;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.AMSService;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.tools.logging.ontology.LogManagementOntology;
import jade.tools.logging.ontology.SetLevel;

public class SetLogLevelBehaviour
extends OneShotBehaviour {
    private static final long serialVersionUID = -4922271299290884248L;
    private AID helperController = null;
    private String loggerName;
    private int logLevel;

    public SetLogLevelBehaviour(String loggerName, int logLevel) {
        this.loggerName = loggerName;
        this.logLevel = logLevel;
    }

    public void action() {
        try {
            AMSAgentDescription template = new AMSAgentDescription();
            template.setName(new AID("loggerController", false));
            SearchConstraints sc = new SearchConstraints();
            sc.setMaxResults(new Long(1L));
            AMSAgentDescription[] result = AMSService.search((Agent)this.myAgent, (AMSAgentDescription)template, (SearchConstraints)sc);
            if (result.length == 0) {
                throw new Exception("Remote logger controller not found");
            }
            this.helperController = result[0].getName();
            this.remoteSetLogLevel(this.helperController, this.loggerName, this.logLevel);
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void remoteSetLogLevel(AID helper, String name, int level) throws FIPAException {
        ACLMessage request = this.createHelperRequest(helper);
        SetLevel sl = new SetLevel(name, level);
        Action act = new Action();
        act.setActor(helper);
        act.setAction((Concept)sl);
        try {
            this.myAgent.getContentManager().registerLanguage((Codec)new SLCodec());
            this.myAgent.getContentManager().registerOntology(LogManagementOntology.getInstance());
            this.myAgent.getContentManager().fillContent(request, (ContentElement)act);
            ACLMessage inform = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)request, (long)10000L);
            if (inform == null) {
                throw new FIPAException("Response timeout expired");
            }
        }
        catch (FIPAException fe) {
            throw fe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FIPAException(e.getMessage());
        }
    }

    private ACLMessage createHelperRequest(AID helper) {
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(helper);
        request.setProtocol("fipa-request");
        request.setLanguage("fipa-sl");
        request.setOntology(LogManagementOntology.getInstance().getName());
        return request;
    }
}

