/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.core.AgentContainerImpl;
import jade.core.BaseService;
import jade.core.InternalMessageQueue;
import jade.core.LADT;
import jade.core.MainContainerImpl;
import jade.core.MessageQueue;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.PlatformManagerImpl;
import jade.core.ServiceDescriptor;
import jade.core.ServiceFinder;
import jade.core.ServiceManager;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CompositeBehaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.ParallelBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.core.behaviours.ThreadedBehaviourFactory;
import jade.core.behaviours.TickerBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.core.behaviours.WrapperBehaviour;
import jade.core.messaging.MessagingService;
import jade.domain.introspection.IntrospectionServer;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.Iterator;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class ContainerMonitorAgent
extends Agent {
    public static final String MANAGE_OUT_OF_MEMORY = "manage-oom";
    public static final String MANAGE_OUT_OF_MEMORY_PERIOD = "manage-oom-period";
    public static final String MANAGE_OUT_OF_MEMORY_BLOCKSIZE = "manage-oom-blocksize";
    public static final String MANAGE_OUT_OF_MEMORY_ACTION = "manage-oom-action";
    public static final String LOG = "LOG";
    public static final String KILL = "KILL";
    public static final String CONTAINER_MONITOR_ONTOLOGY = "container-monitor";
    public static final String HELP_ACTION = "HELP";
    public static final String DUMP_AGENTS_ACTION = "DUMP-AGENTS";
    public static final String DUMP_AGENT_ACTION = "DUMP-AGENT";
    public static final String DUMP_MESSAGEQUEUE_ACTION = "DUMP-MESSAGEQUEUE";
    public static final String DUMP_MESSAGEMANAGER_ACTION = "DUMP-MESSAGEMANAGER";
    public static final String DUMP_LADT_ACTION = "DUMP-LADT";
    public static final String DUMP_SERVICES_MAP_ACTION = "DUMP-SERVICES-MAP";
    public static final String DUMP_PLATFORM_MANAGER_ACTION = "DUMP-PLATFORM-MANAGER";
    public static final String DUMP_SERVICE_ACTION = "DUMP-SERVICE";
    public static final String DUMP_THREADS_ACTION = "DUMP-THREADS";
    public static final String DUMP_SERVICES_ACTION = "DUMP-SERVICES";
    private AgentContainerImpl myContainer;
    private LADT myLADT;
    private String oomAction = "LOG";
    private MessageTemplate template = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchPerformative((int)16), (MessageTemplate)MessageTemplate.MatchOntology((String)"container-monitor"));
    private MessageTemplate helpTemplate = MessageTemplate.not((MessageTemplate)this.template);

    protected void setup() {
        Object[] args = this.getArguments();
        this.myContainer = (AgentContainerImpl)args[0];
        this.myLADT = (LADT)args[1];
        this.addBehaviour((Behaviour)new IntrospectionServer((Agent)this));
        if ("true".equals(this.getProperty(MANAGE_OUT_OF_MEMORY, "false"))) {
            long period = 60000L;
            try {
                period = Long.parseLong(this.getProperty(MANAGE_OUT_OF_MEMORY_PERIOD, "60000"));
            }
            catch (Exception e) {
                // empty catch block
            }
            int blocksize = 10000;
            try {
                blocksize = Integer.parseInt(this.getProperty(MANAGE_OUT_OF_MEMORY_BLOCKSIZE, "10000"));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.oomAction = this.getProperty(MANAGE_OUT_OF_MEMORY_ACTION, KILL);
            this.addBehaviour((Behaviour)new OutOfMemoryManager(period, blocksize));
        }
        this.addBehaviour((Behaviour)new CyclicBehaviour(this){

            public void action() {
                block35: {
                    try {
                        ACLMessage msg = this.myAgent.receive(ContainerMonitorAgent.this.template);
                        if (msg != null) {
                            ACLMessage reply = msg.createReply();
                            reply.setPerformative(7);
                            String content = msg.getContent();
                            try {
                                String contentUC = content.toUpperCase();
                                if (contentUC.startsWith(ContainerMonitorAgent.DUMP_AGENTS_ACTION)) {
                                    reply.setContent(ContainerMonitorAgent.this.getAgentsDump());
                                } else if (contentUC.startsWith(ContainerMonitorAgent.DUMP_AGENT_ACTION)) {
                                    String agentName = ContainerMonitorAgent.this.getParameter(content, 0, false);
                                    Agent a = ContainerMonitorAgent.this.getAgentFromLADT(agentName);
                                    String replyContent = null;
                                    if (a != null) {
                                        replyContent = ContainerMonitorAgent.getAgentDump(a, true);
                                    } else {
                                        reply.setPerformative(6);
                                        replyContent = "Agent " + agentName + " doesn't exist";
                                    }
                                    reply.setContent(replyContent);
                                } else if (contentUC.startsWith(ContainerMonitorAgent.DUMP_MESSAGEQUEUE_ACTION)) {
                                    String agentName = ContainerMonitorAgent.this.getParameter(content, 0, false);
                                    Agent a = ContainerMonitorAgent.this.getAgentFromLADT(agentName);
                                    String replyContent = null;
                                    if (a != null) {
                                        replyContent = ContainerMonitorAgent.this.getMessageQueueDump(a);
                                    } else {
                                        reply.setPerformative(6);
                                        replyContent = "Agent " + agentName + " doesn't exist";
                                    }
                                    reply.setContent(replyContent);
                                } else if (contentUC.startsWith(ContainerMonitorAgent.DUMP_MESSAGEMANAGER_ACTION)) {
                                    reply.setContent(ContainerMonitorAgent.this.getMessageManagerDump());
                                } else if (contentUC.startsWith(ContainerMonitorAgent.DUMP_LADT_ACTION)) {
                                    reply.setContent(ContainerMonitorAgent.this.getLADTDump());
                                } else if (contentUC.startsWith(ContainerMonitorAgent.DUMP_SERVICES_MAP_ACTION)) {
                                    reply.setContent(ContainerMonitorAgent.this.getServicesMapDump());
                                } else if (contentUC.startsWith(ContainerMonitorAgent.DUMP_PLATFORM_MANAGER_ACTION)) {
                                    reply.setContent(ContainerMonitorAgent.this.getPlatformManagerDump());
                                } else if (contentUC.startsWith(ContainerMonitorAgent.DUMP_SERVICES_ACTION)) {
                                    reply.setContent(ContainerMonitorAgent.this.getServicesDump());
                                } else if (contentUC.startsWith(ContainerMonitorAgent.DUMP_SERVICE_ACTION)) {
                                    String serviceName = ContainerMonitorAgent.this.getParameter(content, 0, false);
                                    String key = ContainerMonitorAgent.this.getParameter(content, 1, true);
                                    BaseService srv = ContainerMonitorAgent.this.getService(serviceName);
                                    if (srv != null) {
                                        reply.setContent(ContainerMonitorAgent.this.getServiceDump(srv, key));
                                    } else {
                                        reply.setPerformative(6);
                                        reply.setContent("Service " + serviceName + " not installed");
                                    }
                                } else if (contentUC.startsWith(ContainerMonitorAgent.DUMP_THREADS_ACTION)) {
                                    reply.setContent(ContainerMonitorAgent.this.getThreadsDump());
                                } else if (contentUC.startsWith(ContainerMonitorAgent.HELP_ACTION)) {
                                    reply.setContent(ContainerMonitorAgent.this.getHelp());
                                } else {
                                    reply.setPerformative(10);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                reply.setPerformative(6);
                                reply.setContent(e.toString());
                            }
                            if (reply.getPerformative() == 7) {
                                System.out.println(reply.getContent());
                            }
                            this.myAgent.send(reply);
                            break block35;
                        }
                        this.block();
                    }
                    catch (OutOfMemoryError oome) {
                        ContainerMonitorAgent.this.manageOOM();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        });
        this.addBehaviour((Behaviour)new CyclicBehaviour(this){

            public void action() {
                try {
                    ACLMessage msg = this.myAgent.receive(ContainerMonitorAgent.this.helpTemplate);
                    if (msg != null) {
                        ACLMessage reply = msg.createReply();
                        reply.setPerformative(10);
                        reply.setContent(ContainerMonitorAgent.this.getHelp());
                        this.myAgent.send(reply);
                    } else {
                        this.block();
                    }
                }
                catch (OutOfMemoryError oome) {
                    ContainerMonitorAgent.this.manageOOM();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    public String getHelp() {
        StringBuffer sb = new StringBuffer("This agent accepts REQUEST messages refering to the container-monitor ontology.\nSupported actions:\n");
        sb.append(DUMP_AGENTS_ACTION).append('\n');
        sb.append(DUMP_AGENT_ACTION).append(" <agent-local-name>").append('\n');
        sb.append(DUMP_MESSAGEQUEUE_ACTION).append(" <agent-local-name>").append('\n');
        sb.append(DUMP_LADT_ACTION).append('\n');
        sb.append(DUMP_MESSAGEMANAGER_ACTION).append('\n');
        sb.append(DUMP_SERVICES_MAP_ACTION).append("(only available on Main-Containers)").append('\n');
        sb.append(DUMP_SERVICES_ACTION).append('\n');
        sb.append(DUMP_SERVICE_ACTION).append(" <service-name>").append('\n');
        sb.append(DUMP_THREADS_ACTION).append('\n');
        sb.append(DUMP_PLATFORM_MANAGER_ACTION).append("(only available on Main-Containers)").append('\n');
        return sb.toString();
    }

    private String getParameter(String content, int index, boolean optional) throws Exception {
        String action = null;
        StringTokenizer st = new StringTokenizer(content, " ");
        try {
            action = st.nextToken();
            for (int i = 0; i < index; ++i) {
                st.nextToken();
            }
            return st.nextToken();
        }
        catch (NoSuchElementException nsee) {
            if (optional) {
                return null;
            }
            throw new Exception("Missing parameter for action " + action);
        }
    }

    public String[] getLADTStatus() {
        return this.myLADT.getStatus();
    }

    public String getAgentsDump() {
        StringBuffer sb = new StringBuffer();
        sb.append("-------------------------------------------------------------\n");
        sb.append("Container ");
        sb.append(this.myContainer.getID().getName());
        sb.append(" agents DUMP\n");
        sb.append("-------------------------------------------------------------\n");
        Agent[] agents = this.myLADT.values();
        for (int i = 0; i < agents.length; ++i) {
            Agent a = agents[i];
            String agentDump = ContainerMonitorAgent.getAgentDump(a, false);
            sb.append(agentDump);
        }
        sb.append("-------------------------------------------------------------\n");
        return sb.toString();
    }

    public static String getAgentDump(Agent a, boolean stackTraceMode) {
        StringBuffer sb = new StringBuffer();
        if (a != null) {
            try {
                sb.append("Agent " + a.getName() + "\n");
                sb.append("  - Class = " + a.getClass().getName() + "\n");
                sb.append("  - State = " + a.getState() + "\n");
                sb.append("  - MessageQueue size = " + a.getMessageQueue().size() + "\n");
                sb.append("  - Behaviours\n");
                Behaviour[] bb = a.getScheduler().getBehaviours();
                for (int j = 0; j < bb.length; ++j) {
                    Behaviour b = bb[j];
                    sb.append("    - Behaviour " + b.getBehaviourName() + "\n");
                    ContainerMonitorAgent.appendBehaviourInfo(b, sb, "      ", stackTraceMode);
                }
                if (stackTraceMode) {
                    String dumpAgentThread = ContainerMonitorAgent.dumpThread("    ", a.getThread());
                    sb.append("  - Agent thread dump\n");
                    sb.append(dumpAgentThread);
                }
                try {
                    Method dumpMethod = a.getClass().getMethod("dump", new Class[0]);
                    String agentSpecificDump = (String)dumpMethod.invoke((Object)a, new Object[0]);
                    sb.append("Agent specific dump\n");
                    sb.append(agentSpecificDump);
                }
                catch (Throwable t) {}
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    private Agent getAgentFromLADT(String agentName) {
        Agent result = null;
        Agent[] agents = this.myLADT.values();
        for (int i = 0; i < agents.length; ++i) {
            Agent a = agents[i];
            if (!a.getAID().getLocalName().equals(agentName)) continue;
            result = a;
            break;
        }
        return result;
    }

    private BaseService getService(String serviceName) throws Exception {
        BaseService srv = null;
        try {
            srv = (BaseService)this.myContainer.getServiceFinder().findService(serviceName);
        }
        catch (ClassCastException cce) {
            throw new Exception("Service " + serviceName + " is not a BaseService. It cannot be dumped");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return srv;
    }

    public String getServiceDump(BaseService srv, String key) {
        StringBuffer sb = new StringBuffer();
        if (srv != null) {
            sb.append("SERVICE ").append(srv.getName()).append('\n');
            sb.append("--------------------------------------------\n");
            sb.append(srv.dump(key));
            sb.append("--------------------------------------------\n");
        }
        return sb.toString();
    }

    private static String dumpThread(String prefix, Thread t) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo threadInfo = threadMXBean.getThreadInfo(t.getId());
        return ContainerMonitorAgent.dumpThread(prefix, t, threadInfo);
    }

    private static String dumpThread(String prefix, Thread t, ThreadInfo threadInfo) {
        String lockedOn;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix + "\"" + t.getName() + "\"");
        if (t.isDaemon()) {
            sb.append(" daemon");
        }
        String threadId = threadInfo != null ? String.valueOf(threadInfo.getThreadId()) : String.valueOf(t.getId());
        sb.append(" tid=" + threadId);
        sb.append(" " + t.getState().toString().toLowerCase());
        if (threadInfo != null && (lockedOn = threadInfo.getLockName()) != null) {
            String lockedBy = threadInfo.getLockOwnerName();
            sb.append(" on " + lockedOn);
            if (lockedBy != null) {
                sb.append(" held by " + lockedBy);
            }
        }
        sb.append("\n");
        StackTraceElement[] ste = t.getStackTrace();
        for (int i = 0; i < ste.length; ++i) {
            sb.append(prefix + "\t at " + ste[i] + "\n");
        }
        return sb.toString();
    }

    private String dumpAllThreads() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        StringBuffer sb = new StringBuffer();
        Thread.currentThread();
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        Set<Thread> threads = allStackTraces.keySet();
        for (Thread thread : threads) {
            ThreadInfo threadInfo = threadMXBean.getThreadInfo(thread.getId());
            sb.append(ContainerMonitorAgent.dumpThread("", thread, threadInfo));
        }
        long[] threadIds = threadMXBean.findMonitorDeadlockedThreads();
        if (threadIds != null) {
            ThreadInfo[] threadInfoInDeadlock = threadMXBean.getThreadInfo(threadIds);
            sb.append("\n\n\n**************** WARNING ****************: Threads ");
            for (int i = 0; i < threadInfoInDeadlock.length; ++i) {
                sb.append(" \"" + threadInfoInDeadlock[i].getThreadName() + "\"");
            }
            sb.append(" are in deadlock!");
        }
        return sb.toString();
    }

    private static void appendBehaviourInfo(Behaviour b, StringBuffer sb, String prefix, boolean stackTraceMode) {
        sb.append(prefix + "- Class = " + b.getClass().getName() + "\n");
        sb.append(prefix + "- State = " + b.getExecutionState() + "\n");
        sb.append(prefix + "- Runnable = " + b.isRunnable() + "\n");
        if (b instanceof CompositeBehaviour) {
            sb.append(prefix + "- Type = " + ContainerMonitorAgent.getCompositeType((CompositeBehaviour)b) + "\n");
            Behaviour child = ContainerMonitorAgent.getCurrent((CompositeBehaviour)b, b.getClass());
            if (child != null) {
                sb.append(prefix + "- Current child information\n");
                sb.append(prefix + "  - Name = " + child.getBehaviourName() + "\n");
                ContainerMonitorAgent.appendBehaviourInfo(child, sb, prefix + "  ", stackTraceMode);
            }
        } else if (b instanceof WrapperBehaviour) {
            sb.append(prefix + "- Type = Wrapper\n");
            sb.append(prefix + "- Wrapped-Behaviour Information\n");
            Behaviour wb = ((WrapperBehaviour)b).getWrappedBehaviour();
            sb.append(prefix + "  - Name = " + wb.getBehaviourName() + "\n");
            ContainerMonitorAgent.appendBehaviourInfo(wb, sb, prefix + "  ", stackTraceMode);
        } else if (b instanceof ThreadedBehaviourFactory.ThreadedBehaviourWrapper) {
            ThreadedBehaviourFactory.ThreadedBehaviourWrapper w = (ThreadedBehaviourFactory.ThreadedBehaviourWrapper)b;
            sb.append(prefix + "- Type = Threaded\n");
            sb.append(prefix + "- Thread-state = " + w.getThreadState() + "\n");
            sb.append(prefix + "- Thread Information\n");
            Thread t = w.getThread();
            if (t != null) {
                sb.append(prefix + "  - Alive = " + t.isAlive() + "\n");
                sb.append(prefix + "  - Interrupted = " + t.isInterrupted() + "\n");
                if (stackTraceMode) {
                    String dumpBehaviourThread = ContainerMonitorAgent.dumpThread(prefix + "    ", t);
                    sb.append(prefix + "  - Behaviour thread dump\n");
                    sb.append(dumpBehaviourThread);
                }
            }
            sb.append(prefix + "- Threaded Behaviour Information\n");
            Behaviour tb = w.getBehaviour();
            sb.append(prefix + "  - Name = " + tb.getBehaviourName() + "\n");
            ContainerMonitorAgent.appendBehaviourInfo(tb, sb, prefix + "  ", stackTraceMode);
        } else {
            sb.append(prefix + "- Type = " + ContainerMonitorAgent.getSimpleType(b) + "\n");
        }
        try {
            Method dumpMethod = b.getClass().getMethod("dump", new Class[0]);
            String behaviourSpecificDump = (String)dumpMethod.invoke((Object)b, new Object[0]);
            if (behaviourSpecificDump != null) {
                if ((behaviourSpecificDump = behaviourSpecificDump.replace("\n", "\n" + prefix)).endsWith("\n" + prefix)) {
                    behaviourSpecificDump = behaviourSpecificDump.substring(0, behaviourSpecificDump.length() - prefix.length());
                }
                sb.append(prefix + "Behaviour specific dump\n");
                sb.append(prefix + behaviourSpecificDump);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    private static String getSimpleType(Behaviour b) {
        if (b instanceof CyclicBehaviour) {
            return "Cyclic";
        }
        if (b instanceof OneShotBehaviour) {
            return "OneShot";
        }
        if (b instanceof WakerBehaviour) {
            return "Waker";
        }
        if (b instanceof TickerBehaviour) {
            return "Ticker";
        }
        return "Simple";
    }

    private static String getCompositeType(CompositeBehaviour cb) {
        if (cb instanceof FSMBehaviour) {
            return "FSM";
        }
        if (cb instanceof SequentialBehaviour) {
            return "Sequential";
        }
        if (cb instanceof ParallelBehaviour) {
            return "Parallel";
        }
        return "Composite";
    }

    private static Behaviour getCurrent(CompositeBehaviour cb, Class c) {
        Method getCurrentMethod = null;
        try {
            Behaviour b = null;
            getCurrentMethod = c.getDeclaredMethod("getCurrent", null);
            boolean accessibilityChanged = false;
            if (!getCurrentMethod.isAccessible()) {
                try {
                    getCurrentMethod.setAccessible(true);
                    accessibilityChanged = true;
                }
                catch (SecurityException se) {
                    return null;
                }
            }
            try {
                b = (Behaviour)getCurrentMethod.invoke((Object)cb, (Object[])null);
                if (accessibilityChanged) {
                    getCurrentMethod.setAccessible(false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return b;
        }
        catch (NoSuchMethodException e) {
            Class superClass = c.getSuperclass();
            if (superClass != null) {
                return ContainerMonitorAgent.getCurrent(cb, superClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getMessageQueueDump(Agent a) {
        StringBuffer sb = new StringBuffer();
        sb.append("-------------------------------------------------------------\n");
        sb.append("Agent ");
        sb.append(a.getLocalName());
        sb.append(" MessageQueue DUMP\n");
        sb.append("-------------------------------------------------------------\n");
        MessageQueue queue = a.getMessageQueue();
        if (queue instanceof InternalMessageQueue) {
            Object[] messages = ((InternalMessageQueue)queue).getAllMessages();
            if (messages.length > 0) {
                for (int j = 0; j < messages.length; ++j) {
                    sb.append("Message # ");
                    sb.append(j);
                    sb.append('\n');
                    sb.append(messages[j]);
                    sb.append('\n');
                }
            } else {
                sb.append("Queue is empty\n");
            }
        } else {
            sb.append("MessageQueue is not an InternalMessageQueue. Cannot dump it\n");
        }
        return sb.toString();
    }

    public String getLADTDump() {
        StringBuffer sb = new StringBuffer();
        sb.append("-------------------------------------------------------------\n");
        sb.append("Container ");
        sb.append(this.myContainer.getID().getName());
        sb.append(" LADT DUMP\n");
        sb.append("-------------------------------------------------------------\n");
        try {
            String[] ladtStatus = this.myLADT.getStatus();
            for (int i = 0; i < ladtStatus.length; ++i) {
                sb.append("- " + ladtStatus[i] + "\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        sb.append("-------------------------------------------------------------\n");
        return sb.toString();
    }

    public String getMessageManagerDump() {
        StringBuffer sb = new StringBuffer();
        sb.append("-------------------------------------------------------------\n");
        sb.append("Container ");
        sb.append(this.myContainer.getID().getName());
        sb.append(" Message-Manager DUMP\n");
        sb.append("-------------------------------------------------------------\n");
        try {
            ServiceFinder sf = this.myContainer.getServiceFinder();
            MessagingService service = (MessagingService)sf.findService("jade.core.messaging.Messaging");
            sb.append("- Global information: " + service.getMessageManagerGlobalInfo() + "\n");
            String[] queueStatus = service.getMessageManagerQueueStatus();
            sb.append("- Queue status:\n");
            if (queueStatus.length == 0) {
                sb.append("    EMPTY\n");
            } else {
                for (int i = 0; i < queueStatus.length; ++i) {
                    sb.append("  - " + queueStatus[i] + "\n");
                }
            }
            sb.append("- Thread pool status:\n");
            String[] threadPoolStatus = service.getMessageManagerThreadPoolStatus();
            for (int i = 0; i < threadPoolStatus.length; ++i) {
                sb.append("  - " + threadPoolStatus[i] + "\n");
            }
            sb.append("- Thread pool dump:\n");
            Thread[] threadPool = service.getMessageManagerThreadPool();
            for (int i = 0; i < threadPool.length; ++i) {
                String dumpDelivererThread = ContainerMonitorAgent.dumpThread("  ", threadPool[i]);
                sb.append(dumpDelivererThread);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        sb.append("-------------------------------------------------------------\n");
        return sb.toString();
    }

    public String getServicesMapDump() {
        StringBuffer sb = new StringBuffer();
        try {
            MainContainerImpl mc = (MainContainerImpl)this.myContainer.getMain();
            if (mc != null) {
                PlatformManagerImpl pm = (PlatformManagerImpl)mc.getPlatformManager();
                sb.append("-------------------------------------------------------------\n");
                sb.append("Platform services DUMP\n");
                sb.append("-------------------------------------------------------------\n");
                jade.util.leap.Map services = pm.getServicesMap();
                for (String serviceName : services.keySet()) {
                    PlatformManagerImpl.ServiceEntry se = (PlatformManagerImpl.ServiceEntry)services.get((Object)serviceName);
                    sb.append("Service entry " + serviceName + "\n");
                    this.dumpServiceEntry(se, sb);
                }
                sb.append("-------------------------------------------------------------\n");
            } else {
                sb.append("Container " + this.myContainer.getID().getName() + " is not a Main!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            sb.append(e.toString());
        }
        return sb.toString();
    }

    public String getPlatformManagerDump() {
        StringBuffer sb = new StringBuffer();
        try {
            MainContainerImpl mc = (MainContainerImpl)this.myContainer.getMain();
            if (mc != null) {
                PlatformManagerImpl pm = (PlatformManagerImpl)mc.getPlatformManager();
                sb.append("-------------------------------------------------------------\n");
                sb.append("PlatformManager DUMP\n");
                sb.append("-------------------------------------------------------------\n");
                sb.append("NODES\n");
                jade.util.leap.Map nodes = pm.getNodesMap();
                jade.util.leap.Map monitors = pm.getMonitorsMap();
                Iterator it = nodes.keySet().iterator();
                while (it.hasNext()) {
                    NodeDescriptor dsc = (NodeDescriptor)nodes.get(it.next());
                    sb.append("- " + dsc.getName() + ": ");
                    Node n = dsc.getNode();
                    if (n.hasPlatformManager()) {
                        sb.append("PlatformManager-node, ");
                    } else {
                        Node parent = dsc.getParentNode();
                        if (parent != null) {
                            sb.append("child-node [" + parent.getName() + "], ");
                        } else {
                            sb.append("normal-node, ");
                        }
                    }
                    if (monitors.get((Object)dsc.getName()) != null) {
                        sb.append("monitored\n");
                        continue;
                    }
                    sb.append("not-monitored\n");
                }
                sb.append("\n");
                sb.append("REPLICAS\n");
                jade.util.leap.Map replicas = pm.getReplicasMap();
                it = replicas.keySet().iterator();
                while (it.hasNext()) {
                    sb.append("- " + it.next() + "\n");
                }
                sb.append("-------------------------------------------------------------\n");
            } else {
                sb.append("Container " + this.myContainer.getID().getName() + " is not a Main!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            sb.append(e.toString());
        }
        return sb.toString();
    }

    public String getServicesDump() {
        ServiceManager serviceManager = this.myContainer.getServiceManager();
        Vector localServices = serviceManager.getLocalServices();
        StringBuffer sb = new StringBuffer();
        for (ServiceDescriptor ls : localServices) {
            sb.append(ls.getName() + "\n");
        }
        return sb.toString();
    }

    public String getThreadsDump() {
        StringBuffer sb = new StringBuffer();
        sb.append("-------------------------------------------------------------\n");
        sb.append("JVM Threads DUMP\n");
        sb.append("-------------------------------------------------------------\n");
        sb.append(this.dumpAllThreads());
        sb.append("-------------------------------------------------------------\n");
        return sb.toString();
    }

    public void dumpServiceEntry(PlatformManagerImpl.ServiceEntry se, StringBuffer sb) {
        sb.append("  - Name = " + se.getService().getName() + "\n");
        sb.append("  - Class = " + se.getService().getClass().getName() + "\n");
        sb.append("  - Slices:\n");
        jade.util.leap.Map slices = se.getSlicesMap();
        for (String sliceName : slices.keySet()) {
            PlatformManagerImpl.SliceEntry sle = (PlatformManagerImpl.SliceEntry)slices.get((Object)sliceName);
            sb.append("    - Slice " + sliceName + "\n");
            sb.append("      - Class = " + sle.getSlice().getClass().getName() + "\n");
            try {
                Node associatedNode = sle.getNode();
                sb.append("      - Associated node = " + associatedNode);
                sb.append("\n");
                Node innerNode = sle.getSlice().getNode();
                sb.append("      - Inner node      = " + innerNode);
                sb.append("\n");
                if (this.checkConsistency(sliceName, associatedNode, innerNode)) continue;
                sb.append("      WARNING!!!!!!!!!!! Slice is inconsistent\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean checkConsistency(String name, Node n1, Node n2) {
        if (n1 != null && n2 != null) {
            return name.equals(n1.getName()) && name.equals(n2.getName());
        }
        return false;
    }

    private void manageOOM() {
        try {
            if (this.oomAction.equals(KILL)) {
                System.out.println("OUT OF MEMORY DETECTED!!!!!!!! Kill JVM");
                System.exit(100);
            } else if (this.oomAction.equals(LOG)) {
                System.out.println("OUT OF MEMORY DETECTED!!!!!!!!");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class OutOfMemoryManager
    extends TickerBehaviour {
        private int blocksize;

        public OutOfMemoryManager(long period, int blocksize) {
            super(null, period);
            this.blocksize = blocksize;
        }

        protected void onTick() {
            try {
                byte[] dummy = new byte[this.blocksize];
            }
            catch (Throwable oome) {
                ContainerMonitorAgent.this.manageOOM();
            }
        }
    }
}

