/*
 * Decompiled with CFR 0.152.
 */
package jade.misc;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.ContentElementList;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ContainerID;
import jade.domain.AMSService;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.domain.JADEAgentManagement.CreateAgent;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.lang.acl.ACLMessage;
import jade.misc.FileManagerAgent;
import jade.proto.AchieveREInitiator;
import jade.util.Logger;
import java.util.Date;
import java.util.Vector;

public class CreateFileManagerAgentBehaviour
extends AchieveREInitiator {
    private static Logger logger = Logger.getJADELogger((String)CreateFileManagerAgentBehaviour.class.getName());
    private static final String DEFAULT_ROOT = ".";
    private static final long TIMEOUT = 10000L;
    public static final String TIMEOUT_ERROR = "TIMEOUT";
    private String agentName;
    private String root;
    private Integer downloadBlockSize;
    private String errorMessage;
    private Status status;

    public CreateFileManagerAgentBehaviour(String agentName, String root) {
        this(agentName, root, null);
    }

    public CreateFileManagerAgentBehaviour(String agentName, String root, Integer downloadBlockSize) {
        super(null, null);
        this.agentName = agentName;
        this.root = root;
        this.downloadBlockSize = downloadBlockSize;
        this.status = Status.UNKNOWN;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void onStart() {
        super.onStart();
        this.myAgent.getContentManager().registerOntology(JADEManagementOntology.getInstance());
        if (this.myAgent.getContentManager().lookupLanguage("fipa-sl") == null) {
            this.myAgent.getContentManager().registerLanguage((Codec)new SLCodec());
        }
    }

    protected Vector prepareRequests(ACLMessage request) {
        Vector<ACLMessage> v = new Vector<ACLMessage>(1);
        ACLMessage msg = this.prepareRequest();
        if (msg != null) {
            v.addElement(msg);
        }
        return v;
    }

    private ACLMessage prepareRequest() {
        try {
            CreateAgent ca = new CreateAgent();
            ca.setAgentName(this.agentName);
            ca.setClassName(FileManagerAgent.class.getName());
            ca.setContainer(new ContainerID(this.myAgent.getContainerController().getContainerName(), null));
            if (this.root == null) {
                this.root = DEFAULT_ROOT;
            }
            ca.addArguments((Object)this.root);
            if (this.downloadBlockSize != null) {
                ca.addArguments((Object)this.downloadBlockSize);
            }
            Action a = new Action();
            a.setActor(this.myAgent.getAMS());
            a.setAction((Concept)ca);
            ACLMessage msg = new ACLMessage(16);
            msg.setSender(this.myAgent.getAID());
            msg.addReceiver(this.myAgent.getAMS());
            msg.setProtocol("fipa-request");
            msg.setLanguage("fipa-sl");
            msg.setReplyByDate(new Date(System.currentTimeMillis() + 10000L));
            msg.setOntology("JADE-Agent-Management");
            this.myAgent.getContentManager().fillContent(msg, (ContentElement)a);
            return msg;
        }
        catch (Exception e) {
            logger.log(Logger.SEVERE, "Error creating FileManagerAgent ", (Throwable)e);
            this.status = Status.FAILURE;
            this.errorMessage = e.getMessage();
            return null;
        }
    }

    protected void handleInform(ACLMessage inform) {
        this.status = Status.SUCCESS;
    }

    protected void handleFailure(ACLMessage failure) {
        this.handleError(failure);
    }

    protected void handleRefuse(ACLMessage refuse) {
        this.handleError(refuse);
    }

    protected void handleNotUnderstood(ACLMessage notUnderstood) {
        this.handleError(notUnderstood);
    }

    protected void handleAllResultNotifications(Vector notifications) {
        if (notifications.size() == 0) {
            this.errorMessage = TIMEOUT_ERROR;
        }
    }

    protected void handleError(ACLMessage msg) {
        this.status = Status.FAILURE;
        if (msg != null) {
            try {
                ContentElement content = this.myAgent.getContentManager().extractContent(msg);
                if (content instanceof ContentElementList) {
                    InternalError ie;
                    String errorMsg;
                    int i;
                    ContentElement element = ((ContentElementList)content).get(1);
                    this.errorMessage = element instanceof InternalError ? ((i = (errorMsg = (ie = (InternalError)element).getErrorMessage()).indexOf(ClassNotFoundException.class.getSimpleName())) != -1 ? errorMsg.substring(i) : errorMsg) : (element instanceof FailureException ? ((FailureException)element).getMessage() : element.toString());
                }
            }
            catch (Exception e) {
                if (msg.getPerformative() == 6) {
                    try {
                        AID target = AMSService.getFailedReceiver((Agent)this.myAgent, (ACLMessage)msg);
                        String failureReason = AMSService.getFailureReason((Agent)this.myAgent, (ACLMessage)msg);
                        this.errorMessage = "Cannot deliver message to agent " + target.getName() + "[" + failureReason + "]";
                        return;
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                logger.log(Logger.WARNING, "Error retrieving the error message", (Throwable)e);
                this.errorMessage = msg.getContent();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNKNOWN,
        SUCCESS,
        FAILURE;

    }
}

