/*
 * Decompiled with CFR 0.152.
 */
package jade.misc;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.domain.DFGUIManagement.DFAppletOntology;
import jade.domain.DFGUIManagement.DeregisterFrom;
import jade.domain.DFGUIManagement.Federate;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.domain.JADEAgentManagement.ShowGui;
import jade.lang.acl.ACLMessage;
import jade.misc.DFFederatorAgentGUI;
import jade.proto.AchieveREInitiator;
import jade.util.Logger;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;

public class DFFederatorAgent
extends Agent {
    private DFFederatorAgentGUI myGui;
    private static Logger logger = Logger.getMyLogger((String)DFFederatorAgent.class.getName());
    private static String SubDFKeyPrefix = "SubDF";
    private static String RootDFKeyPrefix = "RootDF";

    protected void setup() {
        this.getContentManager().registerOntology(DFAppletOntology.getInstance());
        this.getContentManager().registerOntology(JADEManagementOntology.getInstance());
        this.getContentManager().registerLanguage((Codec)new SLCodec(0), "fipa-sl0");
        this.myGui = new DFFederatorAgentGUI(this);
        this.myGui.showCorrect();
        Object[] args = this.getArguments();
        if (args != null && args.length > 0) {
            String fileName = (String)args[0];
            Properties p = new Properties();
            try {
                p.load(new FileInputStream(fileName));
            }
            catch (Exception e) {
                System.err.println("Some problems in reading the list of properties for " + this.getLocalName());
                e.printStackTrace();
            }
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith(SubDFKeyPrefix)) continue;
                String value = p.getProperty(key);
                AID childDF = this.createAID(value);
                this.myGui.addDF(childDF);
                String rootKey = this.createRootDFKey(key);
                value = p.getProperty(rootKey);
                AID parentDF = this.createAID(value);
                this.myGui.addDF(parentDF);
                this.requestFederation(childDF, parentDF);
            }
        }
    }

    protected void takeDown() {
        if (this.myGui != null) {
            this.myGui.dispose();
        }
    }

    void requestShowGui(final AID df) {
        Action action = new Action(df, (Concept)new ShowGui());
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(df);
        request.setLanguage("fipa-sl0");
        request.setOntology("JADE-Agent-Management");
        try {
            this.getContentManager().fillContent(request, (ContentElement)action);
            this.addBehaviour((Behaviour)new AchieveREInitiator(this, request){

                protected void handleFailure(ACLMessage failure) {
                    String msg = df.getName() + " GUI activation failed [" + failure.getContent() + "]";
                    DFFederatorAgent.this.myGui.notifyFailure(msg);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = df.getName() + " GUI activation failed [" + e.getMessage() + "]";
            this.myGui.notifyFailure(msg);
        }
    }

    void requestFederation(final AID childDF, final AID parentDF) {
        logger.log(Logger.INFO, "Federating " + childDF.getName() + " with " + parentDF.getName());
        Federate f = new Federate();
        f.setDf(parentDF);
        Action action = new Action(childDF, (Concept)f);
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(childDF);
        request.setLanguage("fipa-sl0");
        request.setOntology("DFApplet-Management");
        try {
            this.getContentManager().fillContent(request, (ContentElement)action);
            this.addBehaviour((Behaviour)new AchieveREInitiator(this, request){

                protected void handleInform(ACLMessage inform) {
                    DFFederatorAgent.this.myGui.notifyFederationOK(childDF, parentDF);
                }

                protected void handleFailure(ACLMessage failure) {
                    String msg = "Federation between " + childDF.getName() + " and " + parentDF.getName() + " failed [" + failure.getContent() + "]";
                    DFFederatorAgent.this.myGui.notifyFailure(msg);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = "Federation between " + childDF.getName() + " and " + parentDF.getName() + " failed [" + e.getMessage() + "]";
            this.myGui.notifyFailure(msg);
        }
    }

    void requestFederationRemoval(final AID childDF, final AID parentDF) {
        logger.log(Logger.INFO, "Removing federation between " + childDF.getName() + " and " + parentDF.getName());
        DeregisterFrom d = new DeregisterFrom();
        d.setDf(parentDF);
        DFAgentDescription dfd = new DFAgentDescription();
        dfd.setName(childDF);
        d.setDescription(dfd);
        Action action = new Action(childDF, (Concept)d);
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(childDF);
        request.setLanguage("fipa-sl0");
        request.setOntology("DFApplet-Management");
        try {
            this.getContentManager().fillContent(request, (ContentElement)action);
            this.addBehaviour((Behaviour)new AchieveREInitiator(this, request){

                protected void handleInform(ACLMessage inform) {
                    DFFederatorAgent.this.myGui.notifyFederationRemoved(childDF, parentDF);
                }

                protected void handleFailure(ACLMessage failure) {
                    String msg = "Federation removal between " + childDF.getName() + " and " + parentDF.getName() + " failed [" + failure.getContent() + "]";
                    DFFederatorAgent.this.myGui.notifyFailure(msg);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = "Federation removal between " + childDF.getName() + " and " + parentDF.getName() + " failed [" + e.getMessage() + "]";
            this.myGui.notifyFailure(msg);
        }
    }

    private AID createAID(String value) {
        AID aid;
        int ind = value.indexOf(44);
        if (ind < 0) {
            aid = new AID(value, value.indexOf(64) >= 0);
        } else {
            String aidName = value.substring(0, ind).trim();
            String aidAddress = value.substring(ind + 1).trim();
            aid = new AID(aidName, true);
            aid.addAddresses(aidAddress);
        }
        return aid;
    }

    private String createRootDFKey(String subDFKey) {
        return RootDFKeyPrefix + subDFKey.substring(SubDFKeyPrefix.length());
    }
}

