/*
 * Decompiled with CFR 0.152.
 */
package jade.misc;

import jade.core.AID;
import jade.gui.AIDGui;
import jade.misc.AddDFAction;
import jade.misc.DFFederatorAgent;
import jade.misc.ExitAction;
import jade.misc.FederateAction;
import jade.misc.FederationGraphPanel;
import jade.util.Logger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

class DFFederatorAgentGUI
extends JFrame {
    private DFFederatorAgent myAgent;
    private FederationGraphPanel graphPanel;
    private JTextField childDFTxt;
    private JTextField parentDFTxt;
    private AID childDF;
    private AID parentDF;
    private static Logger logger = Logger.getMyLogger((String)DFFederatorAgentGUI.class.getName());

    public DFFederatorAgentGUI(DFFederatorAgent a) {
        this.setTitle("DF Federator");
        this.myAgent = a;
        JToolBar bar = new JToolBar();
        JButton exitB = bar.add(new ExitAction(this));
        exitB.setText("Exit");
        exitB.setToolTipText("Exit");
        bar.add(exitB);
        JButton addDFB = bar.add(new AddDFAction(this));
        addDFB.setText("Add DF");
        addDFB.setToolTipText("Add a DF agent to the list of known DFs");
        bar.add(addDFB);
        JButton federateB = bar.add(new FederateAction(this));
        federateB.setText("Federate");
        federateB.setToolTipText("Federate the selected child DF with the selected parent DF");
        bar.add(federateB);
        addDFB.setPreferredSize(federateB.getPreferredSize());
        exitB.setPreferredSize(federateB.getPreferredSize());
        bar.addSeparator();
        bar.add(new JLabel("Child-DF: "));
        this.childDFTxt = new JTextField();
        this.childDFTxt.setEditable(false);
        bar.add(this.childDFTxt);
        bar.addSeparator();
        bar.add(new JLabel("Parent-DF: "));
        this.parentDFTxt = new JTextField();
        this.parentDFTxt.setEditable(false);
        bar.add(this.parentDFTxt);
        this.getContentPane().add((Component)bar, "North");
        this.graphPanel = new FederationGraphPanel(this);
        JScrollPane sp = new JScrollPane(this.graphPanel);
        this.getContentPane().add((Component)sp, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ExitAction ac = new ExitAction(DFFederatorAgentGUI.this);
                ac.actionPerformed(new ActionEvent(this, 0, "Exit"));
            }
        });
    }

    void exit() {
        this.myAgent.doDelete();
    }

    void addDF() {
        AIDGui dlg = new AIDGui((Component)this);
        AID df = dlg.ShowAIDGui(null, true, true);
        this.graphPanel.addDF(df);
    }

    void federate() {
        if (this.childDF != null && this.parentDF != null) {
            this.myAgent.requestFederation(this.childDF, this.parentDF);
        }
    }

    void removeFederation(AID child, AID parent) {
        this.myAgent.requestFederationRemoval(child, parent);
    }

    void removeDF(AID df) {
        if (df.equals((Object)this.childDF)) {
            this.childDF = null;
            this.childDFTxt.setText(null);
        }
        if (df.equals((Object)this.parentDF)) {
            this.parentDF = null;
            this.parentDFTxt.setText(null);
        }
        this.graphPanel.removeDF(df);
    }

    void setChildDF(AID df) {
        this.childDF = df;
        this.childDFTxt.setText(df.getName());
    }

    void setParentDF(AID df) {
        this.parentDF = df;
        this.parentDFTxt.setText(df.getName());
    }

    void showGUI(AID df) {
        this.myAgent.requestShowGui(df);
    }

    void addDF(AID id) {
        this.graphPanel.addDF(id);
    }

    void notifyFederationOK(AID childDF, AID parentDF) {
        logger.log(Logger.INFO, "Federation between " + childDF.getName() + " and " + parentDF.getName() + " OK");
        this.graphPanel.addFederation(childDF, parentDF);
    }

    void notifyFederationRemoved(AID childDF, AID parentDF) {
        logger.log(Logger.INFO, "Federation between " + childDF.getName() + " and " + parentDF.getName() + " removed");
        this.graphPanel.removeFederation(childDF, parentDF);
    }

    void notifyFailure(String msg) {
        logger.log(Logger.WARNING, msg);
    }

    void showCorrect() {
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int centerX = (int)screenSize.getWidth() / 2;
        int centerY = (int)screenSize.getHeight() / 2;
        this.setLocation(centerX - this.getWidth() / 2, centerY - this.getHeight() / 2);
        this.setVisible(true);
    }
}

