/*
 * Decompiled with CFR 0.152.
 */
package jade.misc;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.util.Logger;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DynamicFSMBehaviour
extends FSMBehaviour {
    private static Logger logger = Logger.getMyLogger((String)DynamicFSMBehaviour.class.getName());
    private boolean loaded = false;

    public DynamicFSMBehaviour() {
    }

    public DynamicFSMBehaviour(Agent arg0) {
        super(arg0);
        this.loaded = this.loadStates();
    }

    public DynamicFSMBehaviour(Agent myAgent, InputStream xmlDocument) {
        super(myAgent);
        this.loaded = this.loadStates(this.createDomDocument(xmlDocument));
    }

    public void setAgent(Agent agent) {
        super.setAgent(agent);
        if (!this.loaded) {
            this.loaded = this.loadStates();
        }
    }

    public boolean getLoaded() {
        return this.loaded;
    }

    protected boolean loadStates() {
        Document doc = null;
        doc = this.createDomDocument((Object)this);
        if (doc == null) {
            return false;
        }
        return this.loadStates(doc);
    }

    private boolean loadStates(Document doc) {
        Element root = null;
        root = doc.getDocumentElement();
        if (!root.getTagName().equals("fsm")) {
            return false;
        }
        return this.scanStates(root);
    }

    private Document createDomDocument(Object obj) {
        String name = null;
        Document doc = null;
        if (obj == null) {
            return null;
        }
        name = obj.getClass().getName();
        try {
            InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(name + ".desc");
            doc = this.createDomDocument(is);
        }
        catch (Exception e) {
            return null;
        }
        return doc;
    }

    private Document createDomDocument(InputStream is) {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean scanStates(Element root) {
        NodeList children = null;
        if (!root.hasChildNodes()) {
            return false;
        }
        children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.createState(children.item(i), i);
        }
        return true;
    }

    private void createState(Node stateNode, int counter) {
        String name = null;
        Attr attribute = null;
        boolean first = false;
        boolean last = false;
        boolean loaded = false;
        Behaviour behaviour = null;
        Element state = null;
        try {
            state = (Element)stateNode;
        }
        catch (Exception e) {
            return;
        }
        if (!state.getTagName().equals("state")) {
            return;
        }
        attribute = state.getAttributeNode("name");
        name = attribute == null ? "State" + counter : attribute.getValue();
        attribute = state.getAttributeNode("first");
        if (attribute != null) {
            first = true;
        } else {
            attribute = state.getAttributeNode("last");
            if (attribute != null) {
                last = true;
            }
        }
        behaviour = this.loadBehaviour(state, name);
        if (first) {
            this.registerFirstState(behaviour, name);
        } else if (last) {
            this.registerLastState(behaviour, name);
        } else {
            this.registerState(behaviour, name);
        }
        this.scanTransitions(state, name);
    }

    private void scanTransitions(Element state, String name) {
        NodeList children = null;
        if (!state.hasChildNodes()) {
            return;
        }
        children = state.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.createTransition(children.item(i), name);
        }
    }

    private void createTransition(Node transitionNode, String currState) {
        String trName = null;
        String nextState = null;
        Attr attribute = null;
        Element transition = null;
        int code = Integer.MIN_VALUE;
        try {
            transition = (Element)transitionNode;
        }
        catch (Exception e) {
            return;
        }
        trName = transition.getTagName();
        if (!trName.equals("transition")) {
            return;
        }
        attribute = transition.getAttributeNode("nextState");
        if (attribute == null) {
            return;
        }
        nextState = attribute.getValue();
        attribute = transition.getAttributeNode("code");
        if (attribute != null) {
            try {
                code = Integer.parseInt(attribute.getValue());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (code != Integer.MIN_VALUE) {
            this.registerTransition(currState, nextState, code);
        } else {
            this.registerDefaultTransition(currState, nextState);
        }
    }

    private Behaviour loadBehaviour(Element state, String name) {
        Attr attribute = null;
        boolean found = false;
        Object beh = null;
        attribute = state.getAttributeNode("behaviour");
        if (attribute != null) {
            try {
                beh = (Behaviour)Class.forName(attribute.getValue()).newInstance();
                found = true;
            }
            catch (Exception e) {
                found = false;
            }
        }
        if (!found) {
            beh = new AuxiliaryBehaviour();
            ((AuxiliaryBehaviour)((Object)beh)).setStateName(name);
        }
        return beh;
    }

    public class AuxiliaryBehaviour
    extends OneShotBehaviour {
        private String stateName = null;

        public void setStateName(String name) {
            this.stateName = name;
        }

        public void action() {
            logger.log(Logger.INFO, "Agent: " + this.myAgent + " is in state: " + this.stateName);
        }
    }
}

