/*
 * Decompiled with CFR 0.152.
 */
package jade.misc;

import jade.core.AID;
import jade.misc.DFFederatorAgentGUI;
import jade.misc.RemoveDFAction;
import jade.misc.RemoveFederationAction;
import jade.misc.SetAsChildDFAction;
import jade.misc.SetAsParentDFAction;
import jade.misc.ShowGUIAction;
import jade.util.Logger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

class FederationGraphPanel
extends JPanel {
    private DFFederatorAgentGUI gui;
    private int panelW;
    private int panelH;
    private int r;
    private int cx;
    private int cy;
    private LinkedList dfs = new LinkedList();
    private LinkedList federations = new LinkedList();
    private static Logger logger = Logger.getMyLogger((String)FederationGraphPanel.class.getName());

    public FederationGraphPanel(final DFFederatorAgentGUI gui) {
        this.gui = gui;
        this.panelW = 700;
        this.panelH = 600;
        this.r = 260;
        this.cx = this.panelW / 2;
        this.cy = this.panelH / 2;
        this.setPreferredSize(new Dimension(this.panelW, this.panelH));
        this.setBackground(Color.white);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent me) {
                if (SwingUtilities.isRightMouseButton(me)) {
                    JPopupMenu popup = null;
                    AID df = FederationGraphPanel.this.getDFId(me.getPoint());
                    if (df != null) {
                        popup = new DFMenu(df, gui);
                    } else {
                        Federation f = FederationGraphPanel.this.getFederation(me.getPoint());
                        if (f != null) {
                            popup = new FederationMenu(f, gui);
                        }
                    }
                    if (popup != null) {
                        popup.show(me.getComponent(), me.getX(), me.getY());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        LinkedList linkedList = this.federations;
        synchronized (linkedList) {
            for (Federation f : this.federations) {
                f.draw(g);
            }
        }
        linkedList = this.dfs;
        synchronized (linkedList) {
            for (DF df : this.dfs) {
                df.draw(g);
            }
        }
    }

    private AID getDFId(Point p) {
        AID selectedDF = null;
        for (DF df : this.dfs) {
            if (!df.contains(p)) continue;
            selectedDF = df.getID();
            break;
        }
        return selectedDF;
    }

    private DF getDF(AID id) {
        for (DF df : this.dfs) {
            if (!df.compareID(id)) continue;
            return df;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDF(AID id) {
        LinkedList linkedList = this.dfs;
        synchronized (linkedList) {
            DF newDf = new DF(id);
            if (!this.dfs.contains(newDf)) {
                this.dfs.add(newDf);
                this.updateDFPositions();
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDF(AID id) {
        if (!this.isFederated(id)) {
            LinkedList linkedList = this.dfs;
            synchronized (linkedList) {
                this.dfs.remove(new DF(id));
                this.updateDFPositions();
            }
            this.repaint();
        } else {
            logger.log(Logger.INFO, "Remove the federations this DF is involved in first.");
        }
    }

    private void updateDFPositions() {
        int size = this.dfs.size();
        if (size > 0) {
            double teta = Math.PI * 2 / (double)size;
            for (int i = 0; i < size; ++i) {
                DF df = (DF)this.dfs.get(i);
                df.setX((int)((double)this.cx + (double)this.r * Math.cos((double)i * teta)));
                df.setY((int)((double)this.cy - (double)this.r * Math.sin((double)i * teta)));
            }
        }
    }

    private boolean isFederated(AID id) {
        for (Federation f : this.federations) {
            if (!f.getChild().equals((Object)id) && !f.getParent().equals((Object)id)) continue;
            return true;
        }
        return false;
    }

    private Federation getFederation(Point p) {
        Federation selectedF = null;
        for (Federation f : this.federations) {
            if (!f.contains(p)) continue;
            selectedF = f;
            break;
        }
        return selectedF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFederation(AID childDF, AID parentDF) {
        LinkedList linkedList = this.federations;
        synchronized (linkedList) {
            Federation f = new Federation(childDF, parentDF);
            if (!this.federations.contains(f)) {
                this.federations.add(f);
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFederation(AID child, AID parent) {
        LinkedList linkedList = this.federations;
        synchronized (linkedList) {
            this.federations.remove(new Federation(child, parent));
        }
        this.repaint();
    }

    private class FederationMenu
    extends JPopupMenu {
        FederationMenu(Federation f, DFFederatorAgentGUI g) {
            this.add(new RemoveFederationAction(f.getChild(), f.getParent(), g));
        }
    }

    private class DFMenu
    extends JPopupMenu {
        DFMenu(AID selectedDF, DFFederatorAgentGUI g) {
            this.add(new SetAsChildDFAction(selectedDF, g));
            this.add(new SetAsParentDFAction(selectedDF, g));
            this.add(new RemoveDFAction(selectedDF, g));
            this.add(new ShowGUIAction(selectedDF, g));
        }
    }

    private class Federation {
        private AID parent;
        private AID child;

        Federation(AID child, AID parent) {
            this.child = child;
            this.parent = parent;
        }

        AID getParent() {
            return this.parent;
        }

        AID getChild() {
            return this.child;
        }

        void draw(Graphics g) {
            DF ch = FederationGraphPanel.this.getDF(this.child);
            DF pt = FederationGraphPanel.this.getDF(this.parent);
            g.setColor(Color.blue);
            g.drawLine(ch.x, ch.y, pt.x, pt.y);
            Polygon pl = this.getArrow(ch.x, ch.y, pt.x, pt.y);
            g.drawPolygon(pl);
            g.fillPolygon(pl);
        }

        private Polygon getArrow(int childx, int childy, int parentx, int parenty) {
            int distX = childx - parentx;
            int distY = childy - parenty;
            int signX = distX / Math.abs(distX);
            int signY = distY / Math.abs(distY);
            double dist = Math.sqrt(distX * distX + distY * distY);
            double ratioX = (double)Math.abs(distX) / dist;
            double ratioY = (double)Math.abs(distY) / dist;
            int H = 16;
            int B = 8;
            double vX = (childx + 3 * parentx) / 4;
            double vY = (childy + 3 * parenty) / 4;
            double bX = vX + (double)(signX * H) * ratioX;
            double bY = vY + (double)(signY * H) * ratioY;
            int b1X = (int)(bX + (double)(signY * B) * ratioY);
            int b1Y = (int)(bY - (double)(signX * B) * ratioX);
            int b2X = (int)(bX - (double)(signY * B) * ratioY);
            int b2Y = (int)(bY + (double)(signX * B) * ratioX);
            return new Polygon(new int[]{(int)vX, b1X, b2X}, new int[]{(int)vY, b1Y, b2Y}, 3);
        }

        boolean contains(Point p) {
            DF ch = FederationGraphPanel.this.getDF(this.child);
            DF pt = FederationGraphPanel.this.getDF(this.parent);
            Polygon pl = this.getArrow(ch.x, ch.y, pt.x, pt.y);
            return pl.contains(p);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Federation) {
                Federation f = (Federation)obj;
                return this.child.equals((Object)f.child) && this.parent.equals((Object)f.parent);
            }
            return false;
        }
    }

    private static class DF {
        private static final int R = 30;
        private AID myID;
        private int x;
        private int y;

        DF(AID id) {
            this.myID = id;
        }

        AID getID() {
            return this.myID;
        }

        void setX(int x) {
            this.x = x;
        }

        void setY(int y) {
            this.y = y;
        }

        boolean contains(Point p) {
            return p.x >= this.x - 30 && p.x <= this.x + 30 && p.y >= this.y - 30 && p.y <= this.y + 30;
        }

        boolean compareID(AID id) {
            return this.myID.equals((Object)id);
        }

        void draw(Graphics g) {
            g.setColor(Color.red);
            g.fillOval(this.x - 30, this.y - 30, 60, 60);
            g.setColor(Color.black);
            g.drawOval(this.x - 30, this.y - 30, 60, 60);
            byte[] label = this.myID.getName().getBytes();
            FontMetrics fm = g.getFontMetrics();
            int h = fm.getAscent();
            int w = fm.bytesWidth(label, 0, label.length);
            g.drawBytes(label, 0, label.length, this.x - w / 2, this.y + 30 + h);
        }

        public boolean equals(Object obj) {
            if (obj instanceof DF) {
                return this.myID.equals((Object)((DF)obj).getID());
            }
            return false;
        }

        public int hashCode() {
            return this.myID.hashCode();
        }
    }
}

