/*
 * Decompiled with CFR 0.152.
 */
package jade.misc;

import jade.core.Agent;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.misc.FileManagerServer;
import jade.util.Logger;
import java.util.logging.Level;

public class FileManagerAgent
extends Agent {
    private static Logger logger = Logger.getJADELogger((String)FileManagerAgent.class.getName());
    public static final String SERVICE_TYPE = "file-manager-service";

    protected void setup() {
        Object[] args = this.getArguments();
        String root = null;
        if (args.length >= 1 && args[0] != null && args[0] instanceof String) {
            root = (String)args[0];
        }
        int downloadBlockSize = 0;
        if (args.length >= 2 && args[1] != null && args[1] instanceof Integer) {
            downloadBlockSize = (Integer)args[1];
        }
        FileManagerServer fileManagerServer = new FileManagerServer();
        fileManagerServer.init(this, root);
        if (downloadBlockSize > 0) {
            fileManagerServer.setDownloadBlockSize(downloadBlockSize);
        }
        DFAgentDescription dfd = new DFAgentDescription();
        dfd.setName(this.getAID());
        ServiceDescription sd = new ServiceDescription();
        sd.setType(SERVICE_TYPE);
        sd.setName(this.getLocalName());
        dfd.addServices(sd);
        try {
            DFService.register((Agent)this, (DFAgentDescription)dfd);
        }
        catch (FIPAException fe) {
            logger.log(Level.SEVERE, "Error registering agent " + this.getAID() + " into DF", (Throwable)fe);
        }
    }
}

