/*
 * Decompiled with CFR 0.152.
 */
package jade.misc;

import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.leap.LEAPCodec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.misc.DownloadFileAction;
import jade.misc.DownloadMultipleFilesAction;
import jade.misc.FileInfo;
import jade.misc.FileManagementOntology;
import jade.misc.GetFilesListAction;
import jade.proto.SimpleAchieveREInitiator;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.wrapper.gateway.DynamicJadeGateway;
import jade.wrapper.gateway.JadeGateway;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileManagerClient {
    private static final String ACL_USERDEF_TERMINATED_SESSION = "iterated-fipa-request-terminated-session";
    private static final String TIMEOUT = "timeout";
    private static final long DEFAULT_LISTFILES_TIMEOUT = 30000L;
    private static final long DEFAULT_DOWNLOADBLOCK_TIMEOUT = 30000L;
    private static Logger logger = Logger.getJADELogger((String)FileManagerClient.class.getName());
    private static long cnt = 0L;
    private AID server;
    private Connector myConnector;
    private long listFilesTimeout;
    private long dowloadBlockTimeout;

    public FileManagerClient(AID server) {
        this(server, JadeGateway.getDefaultGateway());
    }

    public FileManagerClient(AID server, DynamicJadeGateway djg) {
        this.init(server);
        this.myConnector = new GatewayBasedConnector(djg);
    }

    public FileManagerClient(AID server, Agent agent) {
        this.init(server);
        this.myConnector = new AgentBasedConnector(agent);
    }

    private void init(AID server) {
        this.server = server;
        this.listFilesTimeout = 0L;
        this.dowloadBlockTimeout = 0L;
        if (System.getProperty("SL-preserve-java-types") == null) {
            System.setProperty("SL-preserve-java-types", "true");
        }
    }

    public long getListFilesTimeout() {
        if (this.listFilesTimeout != 0L) {
            return this.listFilesTimeout;
        }
        return 30000L;
    }

    public void setListFilesTimeout(long listFilesTimeout) {
        this.listFilesTimeout = listFilesTimeout;
    }

    public long getDowloadBlockTimeout() {
        if (this.dowloadBlockTimeout != 0L) {
            return this.dowloadBlockTimeout;
        }
        return 30000L;
    }

    public void setDowloadBlockTimeout(long dowloadBlockTimeout) {
        this.dowloadBlockTimeout = dowloadBlockTimeout;
    }

    public List<FileInfo> listFiles(String dirPathName) throws Exception {
        return this.myConnector.listFiles(dirPathName);
    }

    public InputStream download(String filePathName) throws Exception {
        return new FileManagerInputStream(filePathName);
    }

    public InputStream downloadMultiple(List<String> filesPathName) throws Exception {
        return new FileManagerInputStream(filesPathName);
    }

    private ACLMessage prepareGetFilesListRequest(Agent agent, String dirPathName) throws Codec.CodecException, OntologyException {
        ACLMessage req = new ACLMessage(16);
        req.setSender(agent.getAID());
        req.addReceiver(this.server);
        req.setOntology(FileManagementOntology.getInstance().getName());
        req.setLanguage("fipa-sl");
        req.setReplyByDate(new Date(System.currentTimeMillis() + this.getListFilesTimeout()));
        req.setProtocol("fipa-request");
        Action action = new Action();
        action.setActor(this.server);
        action.setAction((Concept)new GetFilesListAction(dirPathName));
        agent.getContentManager().fillContent(req, (ContentElement)action);
        return req;
    }

    private static List extractFilesList(Agent agent, ACLMessage msg) throws UngroundedException, Codec.CodecException, OntologyException {
        Result result = (Result)agent.getContentManager().extractContent(msg);
        Object value = result.getValue();
        if (value != null) {
            return ((ArrayList)value).toList();
        }
        return null;
    }

    private static synchronized String createConversationId(String name) {
        return "C-" + name + '-' + System.currentTimeMillis() + '-' + cnt++;
    }

    private ACLMessage prepareDownloadRequest(Agent agent, String conversationId, AgentAction agentAction) throws Codec.CodecException, OntologyException {
        ACLMessage req = new ACLMessage(16);
        req.setSender(agent.getAID());
        req.addReceiver(this.server);
        req.setOntology(FileManagementOntology.getInstance().getName());
        req.setLanguage("LEAP");
        req.setReplyByDate(new Date(System.currentTimeMillis() + this.getDowloadBlockTimeout()));
        req.setProtocol("iterated-fipa-request");
        req.setConversationId(conversationId);
        Action action = new Action();
        action.setActor(this.server);
        action.setAction((Concept)agentAction);
        agent.getContentManager().fillContent(req, (ContentElement)action);
        return req;
    }

    private DownloadInfo extractDownloadInfo(ACLMessage msg) {
        byte[] content = msg.getByteSequenceContent();
        String completedString = msg.getUserDefinedParameter(ACL_USERDEF_TERMINATED_SESSION);
        boolean completed = completedString != null;
        return new DownloadInfo(content, completed);
    }

    private ACLMessage prepareCancelDownloadRequest(Agent agent, String conversationId) {
        ACLMessage cancel = new ACLMessage(2);
        cancel.setSender(agent.getAID());
        cancel.addReceiver(this.server);
        cancel.setOntology(FileManagementOntology.getInstance().getName());
        cancel.setLanguage("LEAP");
        cancel.setProtocol("iterated-fipa-request");
        cancel.setConversationId(conversationId);
        return cancel;
    }

    private class DownloadInfo {
        public byte[] content;
        public boolean completed;

        public DownloadInfo(byte[] content, boolean completed) {
            this.content = content;
            this.completed = completed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileManagerInputStream
    extends InputStream {
        private ByteBuffer buffer;
        private String conversationId;
        private List<String> filesPathName;
        private String filePathName;
        private boolean finished;
        private boolean closed;

        public FileManagerInputStream(String filePathName) {
            this.filePathName = filePathName;
            this.init(filePathName);
        }

        public FileManagerInputStream(List<String> filesPathName) {
            this.filesPathName = filesPathName;
            this.init(filesPathName.get(0));
        }

        private void init(String name) {
            this.conversationId = FileManagerClient.createConversationId(name);
            this.finished = false;
            this.closed = false;
        }

        @Override
        public int read() throws IOException {
            int i;
            if (this.closed) {
                throw new IOException("FileManagerInputStream closed");
            }
            try {
                if (this.buffer == null) {
                    this.fillBuffer();
                }
                i = this.buffer == null ? -1 : this.buffer.get() & 0xFF;
            }
            catch (BufferUnderflowException bue) {
                if (this.finished) {
                    i = -1;
                }
                this.fillBuffer();
                i = this.buffer.get() & 0xFF;
            }
            return i;
        }

        @Override
        public int available() throws IOException {
            if (this.closed) {
                throw new IOException("FileManagerInputStream closed");
            }
            if (this.buffer != null) {
                return this.buffer.remaining();
            }
            return super.available();
        }

        @Override
        public long skip(long n) throws IOException {
            throw new IOException("Operation not supported");
        }

        @Override
        public void close() throws IOException {
            if (this.finished) {
                super.close();
            } else {
                try {
                    FileManagerClient.this.myConnector.sendCancelDownload(this.conversationId);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error sending download user CANCEL to file " + this.filePathName, (Throwable)e);
                }
            }
            this.closed = true;
        }

        private void fillBuffer() throws IOException {
            try {
                DownloadInfo di = this.filesPathName != null ? FileManagerClient.this.myConnector.downloadMultiple(this.conversationId, this.filesPathName) : FileManagerClient.this.myConnector.download(this.conversationId, this.filePathName);
                if (di.content != null) {
                    this.buffer = ByteBuffer.wrap(di.content);
                }
                this.finished = di.completed;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error getting file data from " + this.filePathName, (Throwable)e);
                throw new IOException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DownloadBehaviour
    extends SimpleAchieveREInitiator {
        private static final long serialVersionUID = 298687839670962197L;
        private String conversationId;
        private String filePathName;
        private List<String> filesPathName;
        private DownloadInfo downloadInfo;
        private Exception exception;

        public DownloadBehaviour(String conversationId, String filePathName) {
            super(null, null);
            this.conversationId = conversationId;
            this.filePathName = filePathName;
        }

        public DownloadBehaviour(String conversationId, List<String> filesPathName) {
            super(null, null);
            this.conversationId = conversationId;
            this.filesPathName = filesPathName;
        }

        public void onStart() {
            super.onStart();
            this.myAgent.getContentManager().registerLanguage((Codec)new LEAPCodec());
            this.myAgent.getContentManager().registerOntology(FileManagementOntology.getInstance());
        }

        protected ACLMessage prepareRequest(ACLMessage unused) {
            try {
                Object action = this.filesPathName != null ? new DownloadMultipleFilesAction(this.filesPathName) : new DownloadFileAction(this.filePathName);
                return FileManagerClient.this.prepareDownloadRequest(this.myAgent, this.conversationId, action);
            }
            catch (Exception e) {
                this.exception = e;
                return null;
            }
        }

        protected void handleInform(ACLMessage msg) {
            super.handleInform(msg);
            this.downloadInfo = FileManagerClient.this.extractDownloadInfo(msg);
        }

        protected void handleFailure(ACLMessage msg) {
            super.handleFailure(msg);
            this.exception = new Exception(msg.getContent());
        }

        protected void handleAllResultNotifications(Vector msgs) {
            super.handleAllResultNotifications(msgs);
            if (msgs.size() == 0) {
                this.exception = new Exception(FileManagerClient.TIMEOUT);
            }
        }

        public byte[] getContent() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.downloadInfo.content;
        }

        public boolean isCompleted() {
            return this.downloadInfo.completed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListFilesBehaviour
    extends SimpleAchieveREInitiator {
        private static final long serialVersionUID = -22871497292972402L;
        private String dirPathName;
        private List<FileInfo> listFiles;
        private Exception exception;

        public ListFilesBehaviour(String dirPathName) {
            super(null, null);
            this.dirPathName = dirPathName;
        }

        public void onStart() {
            super.onStart();
            this.myAgent.getContentManager().registerLanguage((Codec)new SLCodec());
            this.myAgent.getContentManager().registerOntology(FileManagementOntology.getInstance());
        }

        protected ACLMessage prepareRequest(ACLMessage unused) {
            try {
                return FileManagerClient.this.prepareGetFilesListRequest(this.myAgent, this.dirPathName);
            }
            catch (Exception e) {
                this.exception = e;
                return null;
            }
        }

        protected void handleInform(ACLMessage msg) {
            super.handleInform(msg);
            try {
                this.listFiles = FileManagerClient.extractFilesList(this.myAgent, msg);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        protected void handleFailure(ACLMessage msg) {
            super.handleFailure(msg);
            this.exception = new Exception(msg.getContent());
        }

        protected void handleAllResultNotifications(Vector msgs) {
            super.handleAllResultNotifications(msgs);
            if (msgs.size() == 0) {
                this.exception = new Exception(FileManagerClient.TIMEOUT);
            }
        }

        public List<FileInfo> getListFiles() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.listFiles;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GatewayBasedConnector
    implements Connector {
        private DynamicJadeGateway myGateway;

        GatewayBasedConnector(DynamicJadeGateway gateway) {
            this.myGateway = gateway;
        }

        @Override
        public List<FileInfo> listFiles(String dirPathName) throws Exception {
            ListFilesBehaviour lfb = new ListFilesBehaviour(dirPathName);
            this.myGateway.execute((Object)lfb);
            return lfb.getListFiles();
        }

        @Override
        public void sendCancelDownload(final String conversationId) throws Exception {
            this.myGateway.execute((Object)new OneShotBehaviour(){

                public void action() {
                    ACLMessage cancel = FileManagerClient.this.prepareCancelDownloadRequest(this.myAgent, conversationId);
                    this.myAgent.send(cancel);
                }
            });
        }

        @Override
        public DownloadInfo download(String conversationId, String filePathName) throws Exception {
            DownloadBehaviour db = new DownloadBehaviour(conversationId, filePathName);
            this.myGateway.execute((Object)db);
            return new DownloadInfo(db.getContent(), db.isCompleted());
        }

        @Override
        public DownloadInfo downloadMultiple(String conversationId, List<String> filesPathName) throws Exception {
            DownloadBehaviour db = new DownloadBehaviour(conversationId, filesPathName);
            this.myGateway.execute((Object)db);
            return new DownloadInfo(db.getContent(), db.isCompleted());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AgentBasedConnector
    implements Connector {
        private Agent myAgent;

        AgentBasedConnector(Agent a) {
            this.myAgent = a;
            this.myAgent.getContentManager().registerLanguage((Codec)new SLCodec());
            this.myAgent.getContentManager().registerLanguage((Codec)new LEAPCodec());
            this.myAgent.getContentManager().registerOntology(FileManagementOntology.getInstance());
        }

        @Override
        public List<FileInfo> listFiles(String dirPathName) throws Exception {
            ACLMessage request = FileManagerClient.this.prepareGetFilesListRequest(this.myAgent, dirPathName);
            ACLMessage reply = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)request);
            if (reply != null) {
                return FileManagerClient.extractFilesList(this.myAgent, reply);
            }
            throw new Exception(FileManagerClient.TIMEOUT);
        }

        @Override
        public void sendCancelDownload(String conversationId) throws Exception {
            ACLMessage cancel = FileManagerClient.this.prepareCancelDownloadRequest(this.myAgent, conversationId);
            this.myAgent.send(cancel);
        }

        @Override
        public DownloadInfo download(String conversationId, String filePathName) throws Exception {
            return this.download(conversationId, new DownloadFileAction(filePathName));
        }

        @Override
        public DownloadInfo downloadMultiple(String conversationId, List<String> filesPathName) throws Exception {
            return this.download(conversationId, new DownloadMultipleFilesAction(filesPathName));
        }

        private DownloadInfo download(String conversationId, AgentAction agentAction) throws Exception {
            ACLMessage request = FileManagerClient.this.prepareDownloadRequest(this.myAgent, conversationId, agentAction);
            ACLMessage reply = FIPAService.doFipaRequestClient((Agent)this.myAgent, (ACLMessage)request);
            if (reply != null) {
                return FileManagerClient.this.extractDownloadInfo(reply);
            }
            throw new Exception(FileManagerClient.TIMEOUT);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Connector {
        public List<FileInfo> listFiles(String var1) throws Exception;

        public void sendCancelDownload(String var1) throws Exception;

        public DownloadInfo download(String var1, String var2) throws Exception;

        public DownloadInfo downloadMultiple(String var1, List<String> var2) throws Exception;
    }
}

