/*
 * Decompiled with CFR 0.152.
 */
package jade.misc;

import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.leap.LEAPCodec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.misc.DownloadFileAction;
import jade.misc.DownloadMultipleFilesAction;
import jade.misc.FileInfo;
import jade.misc.FileManagementOntology;
import jade.misc.GetFilesListAction;
import jade.proto.SSIteratedAchieveREResponder;
import jade.proto.SSResponderDispatcher;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Serializable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileManagerServer
implements Serializable {
    private static final long serialVersionUID = 784792949576972917L;
    private static final int DEFAULT_BLOCK_SIZE = 102400;
    private static Logger logger = Logger.getJADELogger((String)FileManagerServer.class.getName());
    private int downloadBlockSize = 0;
    private String zipTmpDir = System.getProperty("java.io.tmpdir");

    public void init(Agent myAgent, final String root) {
        myAgent.getContentManager().registerLanguage((Codec)new SLCodec());
        myAgent.getContentManager().registerLanguage((Codec)new LEAPCodec());
        myAgent.getContentManager().registerOntology(FileManagementOntology.getInstance());
        myAgent.addBehaviour((Behaviour)new CyclicBehaviour(myAgent){
            private MessageTemplate template;
            {
                super(x0);
                this.template = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchProtocol((String)"fipa-request"), (MessageTemplate)MessageTemplate.MatchOntology((String)FileManagementOntology.getInstance().getName()));
            }

            public void action() {
                ACLMessage msg = this.myAgent.receive(this.template);
                if (msg != null) {
                    try {
                        Action actExpr = (Action)this.myAgent.getContentManager().extractContent(msg);
                        GetFilesListAction gfla = (GetFilesListAction)actExpr.getAction();
                        String dirPathName = gfla.getDirPathName();
                        if (dirPathName == null) {
                            dirPathName = ".";
                        }
                        ACLMessage reply = msg.createReply();
                        reply.setPerformative(7);
                        java.util.ArrayList<FileInfo> fileInfos = new java.util.ArrayList<FileInfo>();
                        String path = root == null ? dirPathName : root + File.separator + dirPathName;
                        File pathFile = new File(path);
                        String[] fileNames = pathFile.list();
                        if (fileNames != null) {
                            for (String fileName : fileNames) {
                                File file = new File(path + File.separator + fileName);
                                fileInfos.add(new FileInfo(fileName, dirPathName, file.isDirectory(), new Date(file.lastModified()), file.length()));
                            }
                        } else {
                            throw new Exception(path + " not present");
                        }
                        logger.log(Level.FINE, "Served GetFilesList action " + fileInfos);
                        FileManagerServer.sendResponse(this.myAgent, msg, 7, gfla, fileInfos);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error serving GetFilesList action, message= " + msg, (Throwable)e);
                        FileManagerServer.sendResponse(this.myAgent, msg, 6, null, e.getMessage());
                    }
                } else {
                    this.block();
                }
            }
        });
        myAgent.addBehaviour((Behaviour)new SSResponderDispatcher(myAgent, MessageTemplate.and((MessageTemplate)MessageTemplate.MatchProtocol((String)"iterated-fipa-request"), (MessageTemplate)MessageTemplate.MatchOntology((String)FileManagementOntology.getInstance().getName()))){

            protected Behaviour createResponder(final ACLMessage initiationMsg) {
                return new SSIteratedAchieveREResponder(this.myAgent, initiationMsg){
                    private Exception exception;
                    private byte[] buffer;
                    private BufferedInputStream bufferedInput;
                    private long fileSize;
                    private long totalBytesRead;
                    private String filePathName;
                    private File file;
                    private boolean deleteOnExit;
                    {
                        super(x0, x1);
                        this.deleteOnExit = false;
                    }

                    public void onStart() {
                        super.onStart();
                        try {
                            Action actExpr = (Action)this.myAgent.getContentManager().extractContent(initiationMsg);
                            if (actExpr.getAction() instanceof DownloadFileAction) {
                                DownloadFileAction dfa = (DownloadFileAction)actExpr.getAction();
                                this.filePathName = dfa.getFilePathName();
                                if (root != null) {
                                    this.filePathName = root + File.separator + this.filePathName;
                                }
                            } else {
                                DownloadMultipleFilesAction dmfa = (DownloadMultipleFilesAction)actExpr.getAction();
                                List<String> filesPathName = dmfa.getFilesPathName();
                                if (root != null) {
                                    for (int i = 0; i < filesPathName.size(); ++i) {
                                        filesPathName.set(i, root + File.separator + filesPathName.get(i));
                                    }
                                }
                                this.filePathName = "Log-" + System.currentTimeMillis() + ".zip";
                                if (FileManagerServer.this.zipTmpDir != null) {
                                    this.filePathName = FileManagerServer.this.zipTmpDir + File.separator + this.filePathName;
                                }
                                FileManagerServer.this.zip(filesPathName, this.filePathName);
                                this.deleteOnExit = true;
                            }
                            this.file = new File(this.filePathName);
                            this.bufferedInput = new BufferedInputStream(new FileInputStream(this.file));
                            this.buffer = new byte[FileManagerServer.this.getDownloadBlockSize()];
                            this.fileSize = this.file.length();
                            this.totalBytesRead = 0L;
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Error downloading file " + this.filePathName, (Throwable)e);
                            this.exception = e;
                        }
                    }

                    protected ACLMessage handleRequest(ACLMessage request) throws RefuseException, FailureException, NotUnderstoodException {
                        if (this.exception != null) {
                            throw new FailureException(FileManagerServer.this.prepareFailureMessage(request, this.exception.getMessage()));
                        }
                        int bytesRead = 0;
                        try {
                            bytesRead = this.bufferedInput.read(this.buffer);
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "Error reading file " + this.filePathName, (Throwable)e);
                            throw new FailureException(FileManagerServer.this.prepareFailureMessage(request, this.exception.getMessage()));
                        }
                        this.totalBytesRead += (long)bytesRead;
                        ACLMessage reply = request.createReply();
                        reply.setPerformative(7);
                        if (bytesRead > 0) {
                            if (bytesRead < FileManagerServer.this.getDownloadBlockSize()) {
                                byte[] partialBuffer = new byte[bytesRead];
                                System.arraycopy(this.buffer, 0, partialBuffer, 0, bytesRead);
                                reply.setByteSequenceContent(partialBuffer);
                            } else {
                                reply.setByteSequenceContent(this.buffer);
                            }
                        }
                        if (bytesRead == -1 || this.totalBytesRead >= this.fileSize) {
                            this.closeSessionOnNextReply();
                        }
                        return reply;
                    }

                    protected void handleCancel(ACLMessage cancel) {
                        logger.log(Level.WARNING, "Download of file " + this.filePathName + " cancelled by client");
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public int onEnd() {
                        try {
                            if (this.bufferedInput != null) {
                                this.bufferedInput.close();
                            }
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "Error closing file " + this.filePathName, (Throwable)e);
                        }
                        finally {
                            if (this.deleteOnExit && this.file != null) {
                                this.file.delete();
                            }
                        }
                        return super.onEnd();
                    }
                };
            }
        });
        logger.log(Level.FINE, "FileManagerServer initialized in agent " + myAgent.getName() + " with root " + root);
    }

    public void setDownloadBlockSize(int downloadBlockSize) {
        this.downloadBlockSize = downloadBlockSize;
    }

    private int getDownloadBlockSize() {
        if (this.downloadBlockSize == 0) {
            return 102400;
        }
        return this.downloadBlockSize;
    }

    public void setZipTmpDir(String zipTmpDir) {
        this.zipTmpDir = zipTmpDir;
    }

    private static final void sendResponse(Agent myAgent, ACLMessage request, int performative, AgentAction agentAction, Object result) {
        ACLMessage reply = request.createReply();
        reply.setPerformative(performative);
        if (performative == 7) {
            if (result != null) {
                if (result instanceof byte[]) {
                    reply.setByteSequenceContent((byte[])result);
                } else if (agentAction != null) {
                    if (result instanceof java.util.ArrayList) {
                        result = new ArrayList((java.util.ArrayList)result);
                    }
                    Action action = new Action(myAgent.getAID(), (Concept)agentAction);
                    Result ce = new Result((Concept)action, result);
                    try {
                        myAgent.getContentManager().fillContent(reply, (ContentElement)ce);
                    }
                    catch (Exception e) {
                        performative = 6;
                        reply.setContent("Unexpected error: " + e.getMessage());
                        logger.log(Level.SEVERE, "Error coding ACLMessage", (Throwable)e);
                    }
                }
            }
        } else if (result != null && result instanceof String) {
            reply.setContent((String)result);
        }
        myAgent.send(reply);
    }

    private ACLMessage prepareFailureMessage(ACLMessage request, String message) {
        ACLMessage failureReply = request.createReply();
        failureReply.setPerformative(6);
        failureReply.setContent(message);
        return failureReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zip(List<String> sourceFileNames, String zipFileName) {
        ZipOutputStream zos = null;
        try {
            byte[] buffer = new byte[1024];
            FileOutputStream fos = new FileOutputStream(zipFileName);
            zos = new ZipOutputStream(fos);
            for (String fileName : sourceFileNames) {
                File f = new File(fileName);
                if (!f.exists()) continue;
                FileInputStream fis = null;
                try {
                    int length;
                    fis = new FileInputStream(f);
                    zos.putNextEntry(new ZipEntry(f.getName()));
                    while ((length = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, length);
                    }
                    zos.closeEntry();
                }
                finally {
                    if (fis == null) continue;
                    fis.close();
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error zipping files", (Throwable)e);
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

