/*
 * Decompiled with CFR 0.152.
 */
package jade.misc;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.ContentManager;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.FIPAException;
import jade.domain.introspection.GetKeys;
import jade.domain.introspection.GetValue;
import jade.domain.introspection.IntrospectionOntology;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.List;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InternalValuesVisualizer
extends JPanel {
    private Agent myAgent;
    private ContentManager myContentManager;
    private ACLMessage myRequest;
    private AID inspectedAgent;
    private String[] myKeys;
    private JTextField[] valuesTF;
    private JButton[] buttons;
    private static long cnt = 0L;

    private InternalValuesVisualizer(Agent a, ContentManager cm, ACLMessage request, AID id, String[] keys) {
        this.myAgent = a;
        this.myContentManager = cm;
        this.myRequest = request;
        this.inspectedAgent = id;
        this.myKeys = keys;
        this.valuesTF = new JTextField[this.myKeys.length];
        this.buttons = new JButton[this.myKeys.length];
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        for (int i = 0; i < this.myKeys.length; ++i) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            p.add((Component)new JLabel(this.myKeys[i]), gridBagConstraints);
            this.valuesTF[i] = new JTextField(64);
            Dimension dim = new Dimension(300, 24);
            this.valuesTF[i].setMinimumSize(dim);
            this.valuesTF[i].setPreferredSize(dim);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = i;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 17;
            p.add((Component)this.valuesTF[i], gridBagConstraints);
            this.buttons[i] = new JButton("Refresh");
            final int k = i;
            this.buttons[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        Object value = InternalValuesVisualizer.this.retrieveValue(InternalValuesVisualizer.this.myKeys[k]);
                        if (value != null) {
                            if (value.getClass().isArray()) {
                                InternalValuesVisualizer.this.valuesTF[k].setText(InternalValuesVisualizer.this.stringifyArray((Object[])value));
                            } else {
                                InternalValuesVisualizer.this.valuesTF[k].setText(value.toString());
                            }
                        } else {
                            InternalValuesVisualizer.this.valuesTF[k].setText("null");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 5;
            gridBagConstraints.gridy = i;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 17;
            p.add((Component)this.buttons[i], gridBagConstraints);
        }
        this.add((Component)p, "North");
    }

    public static InternalValuesVisualizer createInternalValuesVisualizer(Agent a, AID id) throws Exception {
        ContentManager cm = new ContentManager();
        Ontology onto = IntrospectionOntology.getInstance();
        SLCodec codec = new SLCodec();
        cm.registerOntology(onto);
        cm.registerLanguage((Codec)codec);
        ACLMessage msg = new ACLMessage(16);
        msg.setLanguage(codec.getName());
        msg.setOntology(onto.getName());
        Action actExpr = new Action(id, (Concept)new GetKeys());
        cm.fillContent(msg, (ContentElement)actExpr);
        msg.clearAllReceiver();
        msg.addReceiver(id);
        String replyWith = "RW-" + System.currentTimeMillis() + "-" + cnt;
        ++cnt;
        msg.setReplyWith(replyWith);
        a.send(msg);
        ACLMessage response = a.blockingReceive(MessageTemplate.MatchInReplyTo((String)replyWith), 10000L);
        if (response != null) {
            if (response.getPerformative() == 7) {
                Result r = (Result)cm.extractContent(response);
                List l = r.getItems();
                String[] keys = new String[l.size()];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = (String)l.get(i);
                }
                return new InternalValuesVisualizer(a, cm, msg, id, keys);
            }
            if (response.getPerformative() == 6 && response.getSender().equals((Object)a.getAMS())) {
                throw new FIPAException("Agent " + id.getName() + " not found");
            }
            throw new FIPAException("Error retrieving keys from agent " + id.getName() + ": " + ACLMessage.getPerformative((int)response.getPerformative()));
        }
        throw new FIPAException("Error retrieving keys from agent " + id.getName() + ": timeout expired.");
    }

    private Object retrieveValue(String key) throws Exception {
        Action actExpr = new Action(this.inspectedAgent, (Concept)new GetValue(key));
        this.myContentManager.fillContent(this.myRequest, (ContentElement)actExpr);
        this.myRequest.clearAllReceiver();
        this.myRequest.addReceiver(this.inspectedAgent);
        String replyWith = "RW-" + System.currentTimeMillis() + "-" + cnt;
        ++cnt;
        this.myRequest.setReplyWith(replyWith);
        this.myAgent.send(this.myRequest);
        ACLMessage response = this.myAgent.blockingReceive(MessageTemplate.MatchInReplyTo((String)replyWith), 10000L);
        if (response != null) {
            if (response.getPerformative() == 7) {
                Result r = (Result)this.myContentManager.extractContent(response);
                return r.getValue();
            }
            if (response.getPerformative() == 6 && response.getSender().equals((Object)this.myAgent.getAMS())) {
                throw new FIPAException("Agent " + this.inspectedAgent.getName() + " disappeared");
            }
            throw new FIPAException("Error retrieving value for key " + key + ": " + ACLMessage.getPerformative((int)response.getPerformative()));
        }
        throw new FIPAException("Error retrieving value for key " + key + ": timeout expired.");
    }

    private String stringifyArray(Object[] array) {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i].toString());
            if (i >= array.length - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }
}

