/*
 * Decompiled with CFR 0.152.
 */
package jade.misc;

import jade.imtp.rmi.ServiceManagerRMI;
import jade.util.Logger;
import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.MarshalException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;

public class JADEPlatformTest
implements Remote {
    private static Logger logger = Logger.getMyLogger((String)JADEPlatformTest.class.getName());
    private static String name = "JADEPlatformTest";
    private static String smName = "ServiceManager";

    public static String isRMIRunning(String host, String port) {
        int rmiPort = 1099;
        String rmiHost = "localhost";
        String url = null;
        try {
            rmiPort = Integer.parseInt(port);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (host != null) {
            rmiHost = host;
        }
        url = "rmi://" + rmiHost + ":" + rmiPort + "/" + name;
        try {
            Naming.bind(url, new JADEPlatformTest());
            Naming.unbind(url);
        }
        catch (AlreadyBoundException e) {
            return null;
        }
        catch (MalformedURLException ex) {
            return "Not a properly formatted RMI URL (" + url + "). Check for invalid characters";
        }
        catch (MarshalException exe) {
        }
        catch (RemoteException exe) {
            return "RMI does not exist on host " + rmiHost + " or is not listening on port " + rmiPort;
        }
        catch (NotBoundException exep) {
            // empty catch block
        }
        return null;
    }

    public static String isJADERunning(String host, String port) {
        int rmiPort = 1099;
        String rmiHost = "localhost";
        String url = null;
        try {
            rmiPort = Integer.parseInt(port);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (host != null) {
            rmiHost = host;
        }
        url = "rmi://" + rmiHost + ":" + rmiPort + "/" + smName;
        try {
            ServiceManagerRMI obj = (ServiceManagerRMI)Naming.lookup(url);
            String test = obj.getPlatformName();
        }
        catch (NotBoundException e) {
            return "JADE is not yet bound to the remote registry";
        }
        catch (MalformedURLException e) {
            return "Not a properly formatted RMI URL (" + url + "). Check for invalid characters";
        }
        catch (MarshalException e) {
        }
        catch (RemoteException e) {
            return "RMI does not exist on host " + rmiHost + " or is not listening on port " + rmiPort;
        }
        return null;
    }

    public static void main(String[] arg) {
        String mess = JADEPlatformTest.isRMIRunning(null, "1099");
        if (mess == null) {
            mess = "RMI has no problem";
        }
        logger.log(Logger.INFO, mess);
        mess = JADEPlatformTest.isJADERunning(null, "1099");
        if (mess == null) {
            mess = "JADE has no problem";
        }
        logger.log(Logger.INFO, mess);
    }

    public static String getName() {
        return name;
    }

    public static void setName(String newName) {
        name = newName;
    }
}

