/*
 * Decompiled with CFR 0.152.
 */
package jade.misc;

import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ServiceException;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.ParallelBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.core.messaging.TopicManagementHelper;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.misc.Leader;
import jade.misc.LeaderElectionOntology;
import jade.util.leap.Serializable;

public class LeadershipManager
implements Serializable {
    public static final long DEFAULT_PROPOSAL_RESPONSE_TIMEOUT = 10000L;
    public static final long DEFAULT_PROPOSAL_RETRY_INTERVAL = 10000L;
    public static final String LEADER_ELECTION_TOPIC = "leader-election";
    public static final int IDLE = -1;
    public static final int LEADERSHIP_KNOWN = 0;
    public static final int LEADERSHIP_ACQUIRED = 1;
    public static final int ACQUIRING_LEADERSHIP = 2;
    public static final int WAITING = 3;
    private static final String TRY_ACQUIRE_STATE = "Try-Acquire";
    private static final String WAIT_STATE = "Wait";
    private static final String DUMMY_FINAL_STATE = "Dummy-Final";
    private Agent myAgent;
    private int status = -1;
    private AID leader;
    private AID leaderElectionTopic;
    private long upTime;
    private long proposalResponseTimeout = 10000L;
    private long proposalRetryInterval = 10000L;
    private int cnt = 0;

    public void init(Agent a) throws ServiceException {
        this.myAgent = a;
        if (this.myAgent.getContentManager().lookupLanguage("fipa-sl") == null) {
            this.myAgent.getContentManager().registerLanguage((Codec)new SLCodec(), "fipa-sl");
        }
        this.myAgent.getContentManager().registerOntology(LeaderElectionOntology.getInstance());
        TopicManagementHelper topicHelper = (TopicManagementHelper)this.myAgent.getHelper("jade.core.messaging.TopicManagement");
        this.leaderElectionTopic = topicHelper.createTopic(LEADER_ELECTION_TOPIC);
        topicHelper.register(this.leaderElectionTopic);
        this.myAgent.addBehaviour((Behaviour)new LeaderElectionResponder(this.myAgent));
        this.upTime = System.currentTimeMillis();
    }

    public boolean isLeader() {
        return this.status == 1;
    }

    public AID getLeader() {
        return this.leader;
    }

    public void updateLeadership() {
        this.leader = null;
        this.status = 2;
        this.myAgent.addBehaviour((Behaviour)new LeaderElectionInitiator(this.myAgent));
    }

    public void setProposalResponseTimeout(long t) {
        this.proposalResponseTimeout = t;
    }

    public void setProposalRetryInterval(long t) {
        this.proposalRetryInterval = t;
    }

    protected void leaderElected(AID leader) {
    }

    private void acquireLeadership() {
        this.status = 1;
        this.leader = this.myAgent.getAID();
        this.sendLeadershipMessage(7, null);
        this.leaderElected(this.leader);
    }

    private void handleLeadershipNotification(ACLMessage inform) {
        try {
            Leader l = (Leader)this.myAgent.getContentManager().extractContent(inform);
            AID oldLeader = this.leader;
            this.leader = l.getName();
            if (l.getAge() < System.currentTimeMillis() - this.upTime) {
                System.out.println("WARNING: New leader " + this.leader.getLocalName() + " is younger than me");
            }
            this.status = 0;
            if (!this.leader.equals((Object)oldLeader)) {
                this.leaderElected(this.leader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendLeadershipMessage(int performative, String conversationId) {
        ACLMessage msg = new ACLMessage(performative);
        msg.addReceiver(this.leaderElectionTopic);
        msg.setOntology(LeaderElectionOntology.getInstance().getName());
        msg.setLanguage("fipa-sl");
        msg.setConversationId(conversationId);
        Leader l = new Leader(this.myAgent.getAID(), System.currentTimeMillis() - this.upTime);
        try {
            this.myAgent.getContentManager().fillContent(msg, (ContentElement)l);
            this.myAgent.send(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String buildConvId() {
        return "LE-" + this.myAgent.getLocalName() + "-" + this.cnt++;
    }

    private class SingleAttemptLeaderElectionInitiator
    extends ParallelBehaviour {
        private boolean proposalAccepted;
        private MessageTemplate template;

        private SingleAttemptLeaderElectionInitiator(Agent a) {
            super(a, 1);
            this.proposalAccepted = true;
            this.addSubBehaviour((Behaviour)new CyclicBehaviour(a){

                public void onStart() {
                    String convId = LeadershipManager.this.buildConvId();
                    LeadershipManager.this.sendLeadershipMessage(11, convId);
                    SingleAttemptLeaderElectionInitiator.this.template = MessageTemplate.MatchConversationId((String)convId);
                }

                public void action() {
                    ACLMessage msg = this.myAgent.receive(SingleAttemptLeaderElectionInitiator.this.template);
                    if (msg != null) {
                        if (!msg.getSender().equals((Object)this.myAgent.getAID())) {
                            switch (msg.getPerformative()) {
                                case 0: {
                                    break;
                                }
                                case 15: {
                                    SingleAttemptLeaderElectionInitiator.this.proposalAccepted = false;
                                    break;
                                }
                                case 7: {
                                    LeadershipManager.this.handleLeadershipNotification(msg);
                                }
                            }
                        }
                    } else {
                        this.block();
                    }
                }
            });
            this.addSubBehaviour((Behaviour)new WakerBehaviour(a, LeadershipManager.this.proposalResponseTimeout){

                public void onWake() {
                    if (LeadershipManager.this.status == 2 && SingleAttemptLeaderElectionInitiator.this.proposalAccepted) {
                        LeadershipManager.this.acquireLeadership();
                    }
                }
            });
        }

        public int onEnd() {
            if (LeadershipManager.this.status == 2) {
                LeadershipManager.this.status = 3;
            }
            return LeadershipManager.this.status;
        }

        public void reset() {
            this.proposalAccepted = true;
            super.reset();
        }
    }

    private class LeaderElectionInitiator
    extends FSMBehaviour {
        private LeaderElectionInitiator(Agent a) {
            super(a);
            this.registerFirstState((Behaviour)new SingleAttemptLeaderElectionInitiator(a), LeadershipManager.TRY_ACQUIRE_STATE);
            this.registerState((Behaviour)new WakerBehaviour(a, -1L){

                public void onStart() {
                    long interval = (long)((double)LeadershipManager.this.proposalRetryInterval * Math.random());
                    if (interval == 0L) {
                        interval = LeadershipManager.this.proposalRetryInterval;
                    }
                    this.reset(interval);
                }

                public void onWake() {
                    if (LeadershipManager.this.status == 3) {
                        LeadershipManager.this.status = 2;
                    }
                }

                public int onEnd() {
                    return LeadershipManager.this.status;
                }
            }, LeadershipManager.WAIT_STATE);
            this.registerLastState((Behaviour)new OneShotBehaviour(a){

                public void action() {
                }
            }, LeadershipManager.DUMMY_FINAL_STATE);
            this.registerTransition(LeadershipManager.TRY_ACQUIRE_STATE, LeadershipManager.WAIT_STATE, 3);
            this.registerDefaultTransition(LeadershipManager.TRY_ACQUIRE_STATE, LeadershipManager.DUMMY_FINAL_STATE);
            this.registerTransition(LeadershipManager.WAIT_STATE, LeadershipManager.TRY_ACQUIRE_STATE, 2, new String[]{LeadershipManager.TRY_ACQUIRE_STATE, LeadershipManager.WAIT_STATE});
            this.registerDefaultTransition(LeadershipManager.WAIT_STATE, LeadershipManager.DUMMY_FINAL_STATE);
        }
    }

    private class LeaderElectionResponder
    extends CyclicBehaviour {
        private MessageTemplate template;

        private LeaderElectionResponder(Agent a) {
            super(a);
            this.template = MessageTemplate.MatchTopic((AID)LeadershipManager.this.leaderElectionTopic);
        }

        public void action() {
            ACLMessage msg = this.myAgent.receive(this.template);
            if (msg != null) {
                if (!msg.getSender().equals((Object)this.myAgent.getAID())) {
                    switch (msg.getPerformative()) {
                        case 11: {
                            this.handlePropose(msg);
                            break;
                        }
                        case 7: {
                            LeadershipManager.this.handleLeadershipNotification(msg);
                        }
                    }
                }
            } else {
                this.block();
            }
        }

        private void handlePropose(ACLMessage propose) {
            ACLMessage reply;
            block8: {
                reply = propose.createReply();
                if (LeadershipManager.this.status != 1) {
                    try {
                        Leader l = (Leader)this.myAgent.getContentManager().extractContent(propose);
                        long myAge = System.currentTimeMillis() - LeadershipManager.this.upTime;
                        if (l.getAge() < myAge) {
                            reply.setPerformative(15);
                            break block8;
                        }
                        if (l.getAge() == myAge) {
                            reply.setPerformative(LeadershipManager.this.status == 2 ? 15 : 0);
                            break block8;
                        }
                        reply.setPerformative(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    reply.setPerformative(7);
                    Leader l = new Leader(this.myAgent.getAID(), System.currentTimeMillis() - LeadershipManager.this.upTime);
                    try {
                        this.myAgent.getContentManager().fillContent(reply, (ContentElement)l);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.myAgent.send(reply);
        }
    }
}

