/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.leap.LEAPCodec;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Done;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREResponder;
import java.lang.reflect.Method;
import java.util.Hashtable;
import test.common.agentConfigurationOntology.AddBehaviour;
import test.common.agentConfigurationOntology.AgentConfigurationOntology;
import test.common.agentConfigurationOntology.LoadLanguage;
import test.common.agentConfigurationOntology.LoadOntology;
import test.common.agentConfigurationOntology.Quit;
import test.common.agentConfigurationOntology.RemoveBehaviour;

public class ConfigurableAgent
extends Agent {
    private Hashtable behaviours = new Hashtable();
    private Codec codec = new LEAPCodec();
    private Ontology ontology = AgentConfigurationOntology.getInstance();
    private MessageTemplate mt = MessageTemplate.and((MessageTemplate)MessageTemplate.and((MessageTemplate)MessageTemplate.MatchLanguage((String)this.codec.getName()), (MessageTemplate)MessageTemplate.MatchOntology((String)this.ontology.getName())), (MessageTemplate)MessageTemplate.MatchProtocol((String)"fipa-request"));

    protected void setup() {
        System.out.println("Agent " + this.getName() + " started");
        this.getContentManager().registerLanguage(this.codec);
        this.getContentManager().registerOntology(this.ontology);
        this.addBehaviour((Behaviour)new AchieveREResponder(this, this.mt){

            protected ACLMessage prepareResponse(ACLMessage aCLMessage) throws NotUnderstoodException, RefuseException {
                try {
                    ContentElement contentElement = this.myAgent.getContentManager().extractContent(aCLMessage);
                    this.getDataStore().put((Object)((Object)((Object)this)).toString(), (Object)contentElement);
                    ACLMessage aCLMessage2 = aCLMessage.createReply();
                    aCLMessage2.setPerformative(1);
                    return aCLMessage2;
                }
                catch (Exception exception) {
                    throw new NotUnderstoodException(exception.getMessage());
                }
            }

            protected ACLMessage prepareResultNotification(ACLMessage aCLMessage, ACLMessage aCLMessage2) throws FailureException {
                try {
                    ContentElement contentElement = (ContentElement)this.getDataStore().get((Object)((Object)((Object)this)).toString());
                    if (contentElement instanceof AddBehaviour) {
                        ConfigurableAgent.this.loadBehaviour((AddBehaviour)contentElement);
                    } else if (contentElement instanceof RemoveBehaviour) {
                        ConfigurableAgent.this.unloadBehaviour((RemoveBehaviour)contentElement);
                    } else if (contentElement instanceof LoadLanguage) {
                        ConfigurableAgent.this.loadLanguage((LoadLanguage)contentElement);
                    } else if (contentElement instanceof LoadOntology) {
                        ConfigurableAgent.this.loadOntology((LoadOntology)contentElement);
                    } else if (contentElement instanceof Quit) {
                        this.registerPrepareResponse((Behaviour)new OneShotBehaviour(){

                            public void action() {
                            }

                            public void reset() {
                                this.myAgent.doDelete();
                            }
                        });
                    } else {
                        throw new FailureException("Unknown action " + contentElement);
                    }
                    Done done = new Done((Concept)((AgentAction)contentElement));
                    ACLMessage aCLMessage3 = aCLMessage.createReply();
                    aCLMessage3.setPerformative(7);
                    this.myAgent.getContentManager().fillContent(aCLMessage3, (ContentElement)done);
                    return aCLMessage3;
                }
                catch (Exception exception) {
                    throw new FailureException(exception.getMessage());
                }
            }
        });
    }

    private void loadBehaviour(AddBehaviour addBehaviour) throws Exception {
        String string = addBehaviour.getName();
        String string2 = addBehaviour.getClassName();
        Behaviour behaviour = (Behaviour)Class.forName(string2).newInstance();
        if (string != null) {
            this.behaviours.put(string, behaviour);
        }
        System.out.println("Agent " + this.getName() + ": Loading behaviour " + behaviour);
        this.addBehaviour(behaviour);
    }

    private void unloadBehaviour(RemoveBehaviour removeBehaviour) throws Exception {
        String string = removeBehaviour.getName();
        Behaviour behaviour = (Behaviour)this.behaviours.get(string);
        if (behaviour != null) {
            System.out.println("Agent " + this.getName() + ": Removing behaviour " + behaviour);
            this.removeBehaviour(behaviour);
        }
    }

    private void loadLanguage(LoadLanguage loadLanguage) throws Exception {
        String string = loadLanguage.getClassName();
        String string2 = loadLanguage.getName();
        Codec codec = (Codec)Class.forName(string).newInstance();
        if (string2 == null) {
            string2 = codec.getName();
        }
        System.out.println("Agent " + this.getName() + ": Registering language " + string2);
        this.getContentManager().registerLanguage(codec, string2);
    }

    private void loadOntology(LoadOntology loadOntology) throws Exception {
        String string = loadOntology.getClassName();
        String string2 = loadOntology.getName();
        Class<?> clazz = Class.forName(string);
        Method method = clazz.getMethod("getInstance", new Class[0]);
        Ontology ontology = (Ontology)method.invoke(null, new Object[0]);
        if (string2 == null) {
            string2 = ontology.getName();
        }
        System.out.println("Agent " + this.getName() + ": Registering ontology " + string2);
        this.getContentManager().registerOntology(ontology, string2);
    }
}

