/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.logging.Level;
import test.common.ExecException;
import test.common.JadeController;
import test.common.OutputHandler;
import test.common.TestException;

class LocalJadeController
implements JadeController,
OutputHandler {
    private static Logger logger = Logger.getMyLogger((String)LocalJadeController.class.getName());
    private Object lock = new Object();
    private boolean ready = false;
    private List addresses = new ArrayList();
    private String containerName = null;
    private Process proc;
    private OutputHandler outHandler;

    public LocalJadeController(String string, String string2, String[] stringArray, OutputHandler outputHandler, String string3, String string4) throws TestException {
        this.outHandler = outputHandler != null ? outputHandler : this;
        string3 = string3 != null ? string3 : ".";
        try {
            logger.log(Level.INFO, "Starting JADE with command line: " + string2);
            this.proc = Runtime.getRuntime().exec(string2, null, new File(string3).getCanonicalFile());
            SubProcessManager subProcessManager = new SubProcessManager(string, this.proc, stringArray, string4);
            subProcessManager.start();
            this.waitForJadeStartup();
        }
        catch (Exception exception) {
            if (this.proc != null) {
                this.proc.destroy();
            }
            throw new ExecException("Error launching remote JADE", exception);
        }
        if (!this.ready) {
            logger.log(Level.WARNING, "JADE startup timeout expired");
            this.proc.destroy();
            throw new TestException("Remote JADE startup was not completed successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForJadeStartup() {
        Object object = this.lock;
        synchronized (object) {
            while (!this.ready) {
                try {
                    this.lock.wait(60000L);
                    break;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStarted() {
        Object object = this.lock;
        synchronized (object) {
            this.ready = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTerminated() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.ready) {
                this.lock.notifyAll();
            }
        }
    }

    public List getAddresses() {
        return this.addresses;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void kill() {
        if (this.proc != null) {
            this.proc.destroy();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void handleOutput(String string, String string2) {
        System.out.println(string + ">> " + string2);
    }

    public void handleTermination(int n) {
        System.out.println("Process terminated with exitValue=" + n);
    }

    class SubProcessManager
    extends Thread {
        private Process subProc;
        private BufferedReader br;
        private BufferedReader brErr;
        private String[] protoNames;
        private String name;
        private Thread errorManager;
        private String startupTag;

        public SubProcessManager(String string, Process process, String[] stringArray, String string2) {
            this.name = string;
            this.subProc = process;
            this.startupTag = string2;
            this.br = new BufferedReader(new InputStreamReader(this.subProc.getInputStream()));
            this.protoNames = stringArray != null ? stringArray : new String[]{};
            this.errorManager = this.startErrorManager();
        }

        public void run() {
            while (true) {
                try {
                    int n = this.subProc.exitValue();
                    logger.log(Level.INFO, "Remote JADE instance " + this.name + " terminated");
                    LocalJadeController.this.outHandler.handleTermination(n);
                    LocalJadeController.this.notifyTerminated();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        String string = this.br.readLine();
                        this.handleLine(string);
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, "Error handling output line", (Throwable)exception);
                    }
                    continue;
                }
                break;
            }
            this.stopErrorManager();
        }

        private void handleLine(String string) {
            if (string != null) {
                String string2 = this.name;
                if (string2 == null) {
                    string2 = LocalJadeController.this.containerName;
                }
                if (string2 == null) {
                    string2 = "(unknown)";
                }
                LocalJadeController.this.outHandler.handleOutput(string2, string);
                this.catchAddress(string);
                if (LocalJadeController.this.containerName == null && string.startsWith(this.startupTag)) {
                    this.catchContainerName(string);
                    LocalJadeController.this.notifyStarted();
                }
            }
        }

        private void catchAddress(String string) {
            for (int i = 0; i < this.protoNames.length; ++i) {
                if (!string.startsWith(this.protoNames[i])) continue;
                LocalJadeController.this.addresses.add((Object)string);
                break;
            }
        }

        private void catchContainerName(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " @");
            stringTokenizer.nextToken();
            LocalJadeController.this.containerName = stringTokenizer.nextToken();
        }

        private Thread startErrorManager() {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        SubProcessManager.this.brErr = new BufferedReader(new InputStreamReader(SubProcessManager.this.subProc.getErrorStream()));
                        while (true) {
                            String string = SubProcessManager.this.brErr.readLine();
                            SubProcessManager.this.handleLine(string);
                        }
                    }
                    catch (Exception exception) {
                        logger.log(Level.INFO, "ErrorManager exiting");
                        return;
                    }
                }
            });
            thread.start();
            return thread;
        }

        private void stopErrorManager() {
            try {
                this.brErr.close();
                this.errorManager.interrupt();
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Error closing Error stream", (Throwable)exception);
            }
        }
    }
}

