/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import test.common.HTMLManager;

public class Logger {
    static Logger theLogger = new Logger();
    private static File logFile;
    private static PrintStream out;
    private static int nLog;
    public static final int CONSOLE_LOGGER = 0;
    public static final int TXT_LOGGER = 1;
    public static final int HTML_LOGGER = 2;
    private static int currentType;
    public static final String[] typeStringArray;
    public static String loggedCurrentTest;

    public void simpleLog(String string) {
        switch (currentType) {
            case 0: 
            case 1: {
                out.println(string);
                break;
            }
            case 2: {
                HTMLManager.addBody(string + "<BR/>\n");
            }
        }
    }

    public void log(String string) {
        this.simpleLog(string);
    }

    public void log(Object object) {
        String string = object.toString();
        this.log(string);
    }

    public void logString(String string) {
        switch (currentType) {
            case 0: 
            case 1: {
                out.print(string);
                break;
            }
            case 2: {
                HTMLManager.addBody(string);
            }
        }
    }

    public void logStackTrace(Throwable throwable) {
        switch (currentType) {
            case 0: 
            case 1: {
                throwable.printStackTrace(out);
                break;
            }
            case 2: {
                HTMLManager.addBody(throwable.toString() + "\n");
            }
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (currentType == 2) {
            HTMLManager.addBody("<BLOCKQUOTE>\n");
        }
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (currentType != 2) continue;
            HTMLManager.addBody("\t" + stackTraceElementArray[i].toString() + "<BR/>\n");
        }
        if (currentType == 2) {
            HTMLManager.addBody("</BLOCKQUOTE>\n");
        }
    }

    public static Logger getLogger() {
        return theLogger;
    }

    public static void setFileLogger(int n) {
        currentType = n;
        switch (currentType) {
            case 1: {
                logFile = new File("log000.txt");
                nLog = 0;
                try {
                    while (logFile.exists()) {
                        logFile = new File("log00" + ++nLog + ".txt");
                    }
                    out = new PrintStream(new FileOutputStream(logFile));
                }
                catch (Exception exception) {
                    System.out.println("Error writing to TXT log file");
                }
                break;
            }
            case 2: {
                logFile = new File("log000.html");
                nLog = 0;
                try {
                    while (logFile.exists()) {
                        logFile = new File("log00" + ++nLog + ".html");
                    }
                    out = new PrintStream(new FileOutputStream(logFile));
                }
                catch (Exception exception) {
                    System.out.println("Error writing to HTML log file");
                }
                HTMLManager.init(logFile.toString());
            }
        }
    }

    public static void setTextLogger() {
        currentType = 0;
        out = System.out;
    }

    public void closeLogger() {
        if (currentType == 2) {
            HTMLManager.buildFile(out);
        }
        out.close();
    }

    public static int getLoggerType() {
        return currentType;
    }

    public static String getLoggerStringType() {
        return typeStringArray[currentType];
    }

    public static int getBlockCounter() {
        return HTMLManager.getBlockCounter();
    }

    public static void incBlockCounter() {
        HTMLManager.incBlockCounter();
    }

    public static void addIndex(String string, String string2) {
        if (!string.equals("")) {
            HTMLManager.addIndex("  <TR><TD BGCOLOR=\"#AEAEFF\" COLSPAN=\"3\" HEIGHT=\"2\"></TD></TR>\n");
        }
        HTMLManager.addIndex("  <TR>\n    <TD BGCOLOR=\"#EEEEFF\" WIDTH=\"200\">" + string + "</TD>\n" + "    <TD BGCOLOR=\"#FFFFFF\"><a href=\"#a" + HTMLManager.getBlockCounter() + "\">" + string2 + "</a></TD>\n");
    }

    public static void addIndexSummary(String string) {
        HTMLManager.addIndex("    <TD BGCOLOR=\"#F7F7FF\" WIDTH=\"200\">" + string + "</TD>\n" + "  </TR>\n");
    }

    public static void addBody(String string) {
        HTMLManager.addBody(string);
    }

    public static void addBodyHeading(String string) {
        HTMLManager.addBody("\n<P>\n<TABLE BORDER=\"0\" CELLPADDING=\"10\" CELLSPACING=\"0\">\n  <TR>\n    <TD BGCOLOR=#D0D0FF><FONT SIZE=\"-1\"><A HREF=\"#\">BACK TO TOP<A></FONT></TD>\n    <TD BGCOLOR=#A0A0FF><FONT SIZE=\"+2\"><B><A name=\"a" + HTMLManager.getBlockCounter() + "\">" + string + "</a></B></FONT></TD>\n" + "  </TR>\n" + "</TABLE>\n" + "<P>\n");
    }

    public static void addBodyCloser() {
        HTMLManager.addBody("<P>\n<TABLE BORDER=\"0\" CELLPADDING=\"10\" CELLSPACING=\"0\">\n  <TR>\n    <TD BGCOLOR=#D0D0FF><FONT SIZE=\"-1\"><A HREF=\"#\">BACK TO TOP<A></FONT></TD>\n  </TR>\n</TABLE>\n<HR>\n<P>\n\n");
    }

    public static void deleteLogger() {
        switch (currentType) {
            case 1: {
                out.close();
                logFile.delete();
                break;
            }
            case 0: {
                break;
            }
        }
    }

    static {
        out = System.out;
        nLog = 0;
        currentType = 0;
        typeStringArray = new String[]{"Console", "Txt File", "HTML File"};
    }
}

