/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.ParallelBehaviour;
import jade.core.behaviours.SerialBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.ArrayList;
import jade.util.leap.Collection;
import jade.util.leap.List;
import jade.util.leap.Serializable;
import test.common.Logger;
import test.common.TestException;
import test.common.TestGroup;
import test.common.xml.TestDescriptor;

public abstract class Test
implements Serializable {
    public static final int TEST_PASSED = 1;
    public static final int TEST_FAILED = 0;
    public static final int TEST_SKIPPED = 2;
    public static final int NOT_AVAILABLE = -1;
    public static final int DEFAULT_PORT = 1099;
    public static final String DEFAULT_PROTO = "http";
    public static final String DEFAULT_MTP = "jade.mtp.http.MessageTransportProtocol";
    private TestGroup myGroup;
    private TestDescriptor myDescriptor;
    private Wrapper myWrapper;
    private DataStore myStore;
    private String myKey;
    private String errorMsg = null;
    private long timeout = -1L;
    private boolean pauseEnabled = false;
    private static MessageTemplate resumeTemplate = MessageTemplate.MatchContent((String)"resume");

    public Behaviour load(Agent agent) throws TestException {
        return null;
    }

    public Behaviour load(Agent agent, DataStore dataStore, String string) throws TestException {
        this.myStore = dataStore;
        this.myKey = string;
        Behaviour behaviour = this.load(agent);
        if (this.timeout > 0L) {
            ParallelBehaviour parallelBehaviour = new ParallelBehaviour(agent, 1);
            parallelBehaviour.addSubBehaviour(behaviour);
            parallelBehaviour.addSubBehaviour((Behaviour)new WatchDog(agent, this.timeout));
            this.myWrapper = new Wrapper(agent, (Behaviour)parallelBehaviour);
        } else {
            this.myWrapper = new Wrapper(agent, behaviour);
        }
        return this.myWrapper;
    }

    public void clean(Agent agent) {
    }

    protected final Object getGroupArgument(String string) {
        return this.myGroup.getArgument(string);
    }

    protected final String getTestArgument(String string) {
        return this.myDescriptor.getArg(string);
    }

    protected void setTimeout(long l) {
        this.timeout = l;
    }

    protected final void passed(String string) {
        this.log(string);
        this.myStore.put((Object)this.myKey, (Object)new Integer(1));
        this.myWrapper.stop();
    }

    protected final void failed(String string) {
        this.log(string);
        this.errorMsg = string;
        this.myStore.put((Object)this.myKey, (Object)new Integer(0));
        this.myWrapper.stop();
    }

    protected final boolean isFailed() {
        Integer n = (Integer)this.myStore.get((Object)this.myKey);
        return n != null && n == 0;
    }

    protected final void log(String string) {
        Logger.getLogger().log(string);
    }

    protected final void pause() {
        if (this.pauseEnabled) {
            this.myWrapper.pause();
            this.log("Test paused. Send a REQUEST message with content \"resume\" to go on");
        }
    }

    protected final void enablePause(boolean bl) {
        this.pauseEnabled = bl;
    }

    TestDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    String getErrorMsg() {
        return this.errorMsg;
    }

    void setErrorMsg(String string) {
        this.errorMsg = string;
    }

    void setDescriptor(TestDescriptor testDescriptor) {
        this.myDescriptor = testDescriptor;
    }

    void setGroup(TestGroup testGroup) {
        this.myGroup = testGroup;
    }

    private class WatchDog
    extends WakerBehaviour {
        private WatchDog(Agent agent, long l) {
            super(agent, l);
        }

        protected void handleElapsedTimeout() {
            Test.this.failed("Timeout expired");
        }
    }

    private class Wrapper
    extends SerialBehaviour {
        private boolean stopped;
        private Behaviour wrapped;
        private Behaviour paused;
        private List children;

        private Wrapper(Agent agent, Behaviour behaviour) {
            super(agent);
            this.stopped = false;
            this.children = new ArrayList(1);
            this.wrapped = behaviour;
            this.registerAsChild(this.wrapped);
            this.children.add((Object)this.wrapped);
        }

        protected void scheduleFirst() {
        }

        protected void scheduleNext(boolean bl, int n) {
            if (this.stopped) {
                this.wrapped = null;
            }
        }

        protected boolean checkTermination(boolean bl, int n) {
            return this.stopped || bl;
        }

        protected Behaviour getCurrent() {
            return this.wrapped;
        }

        public Collection getChildren() {
            return this.children;
        }

        private void stop() {
            this.stopped = true;
            this.restart();
        }

        private void pause() {
            this.paused = this.wrapped;
            this.wrapped = new CyclicBehaviour(this.myAgent){

                public void action() {
                    ACLMessage aCLMessage = this.myAgent.receive(resumeTemplate);
                    if (aCLMessage != null) {
                        Wrapper.this.wrapped = Wrapper.this.paused;
                    } else {
                        this.block();
                    }
                }
            };
        }

        public void reset() {
            this.stopped = false;
            super.reset();
        }
    }
}

