/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import test.common.Logger;
import test.common.SkippedException;
import test.common.Test;
import test.common.TestException;
import test.common.TestGroup;
import test.common.TesterAgent;
import test.common.testerAgentControlOntology.TestResult;
import test.common.xml.TestDescriptor;

public class TestGroupExecutor
extends FSMBehaviour {
    private static final String INIT_TEST_GROUP_STATE = "Init-test-group";
    private static final String LOAD_TEST_STATE = "Load-test";
    private static final String CLEAN_TEST_STATE = "Clean-test";
    private static final String EXECUTE_TEST_STATE = "Execute-test";
    private static final String HANDLE_RESULT_STATE = "Handle-result";
    private static final String END_STATE = "End";
    private static final String PAUSE_STATE = "Pause";
    private static final String TEST_RESULT_KEY = "_test-result_";
    private static final int EXIT = 0;
    private static final int EXECUTE = 1;
    private static final int SKIP = 2;
    private static final int PAUSE = 3;
    private static final int ABORT = 4;
    private boolean aborted = false;
    protected int passedCnt = 0;
    protected int failedCnt = 0;
    protected int skippedCnt = 0;
    private TestGroup tests;
    private Test currentTest;
    private boolean debugMode = false;
    private boolean inPause = false;

    public TestGroupExecutor(Agent agent, TestGroup testGroup) {
        super(agent);
        if (testGroup == null) {
            throw new IllegalArgumentException("Null test group");
        }
        this.tests = testGroup;
        this.registerDefaultTransition(INIT_TEST_GROUP_STATE, LOAD_TEST_STATE);
        this.registerTransition(INIT_TEST_GROUP_STATE, END_STATE, 4);
        this.registerTransition(LOAD_TEST_STATE, EXECUTE_TEST_STATE, 1);
        this.registerTransition(LOAD_TEST_STATE, CLEAN_TEST_STATE, 2);
        this.registerTransition(LOAD_TEST_STATE, END_STATE, 0);
        this.registerTransition(LOAD_TEST_STATE, PAUSE_STATE, 3);
        this.registerDefaultTransition(PAUSE_STATE, EXECUTE_TEST_STATE);
        this.registerDefaultTransition(EXECUTE_TEST_STATE, HANDLE_RESULT_STATE);
        this.registerDefaultTransition(HANDLE_RESULT_STATE, CLEAN_TEST_STATE);
        this.registerDefaultTransition(CLEAN_TEST_STATE, LOAD_TEST_STATE);
        Object object = new OneShotBehaviour(){

            public void action() {
                try {
                    TestGroupExecutor.this.tests.initialize(this.myAgent);
                }
                catch (TestException testException) {
                    TestGroupExecutor.this.log("Error in TestGroup initialization. Abort");
                    testException.printStackTrace();
                    TestGroupExecutor.this.aborted = true;
                }
            }

            public int onEnd() {
                return TestGroupExecutor.this.aborted ? 4 : -1;
            }
        };
        this.registerFirstState((Behaviour)object, INIT_TEST_GROUP_STATE);
        object = new OneShotBehaviour(){
            private int ret;

            public void action() {
                try {
                    TestGroupExecutor.this.currentTest = TestGroupExecutor.this.tests.next();
                    if (TestGroupExecutor.this.currentTest != null) {
                        this.ret = 1;
                        TestDescriptor testDescriptor = TestGroupExecutor.this.currentTest.getDescriptor();
                        TestGroupExecutor.this.log("--------------------------------------------");
                        TestGroupExecutor.this.log("Executing test: " + testDescriptor.getName());
                        TestGroupExecutor.this.log("WHAT: " + testDescriptor.getWhat());
                        TestGroupExecutor.this.log("HOW:  " + testDescriptor.getHow());
                        TestGroupExecutor.this.log("PASSED WHEN: " + testDescriptor.getPassedWhen());
                        Logger.loggedCurrentTest = testDescriptor.getName();
                        Behaviour behaviour = TestGroupExecutor.this.currentTest.load(this.myAgent, this.getDataStore(), TestGroupExecutor.TEST_RESULT_KEY);
                        TestGroupExecutor.this.registerState(behaviour, TestGroupExecutor.EXECUTE_TEST_STATE);
                        if (TestGroupExecutor.this.debugMode) {
                            this.ret = 3;
                            TestGroupExecutor.this.inPause = true;
                        }
                    } else {
                        this.ret = 0;
                    }
                }
                catch (TestException testException) {
                    boolean bl = false;
                    if (testException instanceof SkippedException) {
                        SkippedException skippedException = (SkippedException)testException;
                        bl = skippedException.getExpected();
                        TestGroupExecutor.this.currentTest = new DummyTest(skippedException.getDescriptor());
                    }
                    if (!bl) {
                        TestGroupExecutor.this.log("Problems in test initialization [" + testException.getMessage() + "]");
                        TestGroupExecutor.this.log("Skip this test.");
                        ++TestGroupExecutor.this.skippedCnt;
                        TestGroupExecutor.this.currentTest.setErrorMsg(testException.getMessage());
                    } else {
                        TestGroupExecutor.this.currentTest.setErrorMsg("Set to skipped");
                    }
                    TestGroupExecutor.this.sendTestResultNotification(2);
                    this.ret = 2;
                }
            }

            public int onEnd() {
                if (this.ret == 1) {
                    TestGroupExecutor.this.flushMessageQueue();
                }
                return this.ret;
            }
        };
        object.setDataStore(this.getDataStore());
        this.registerState((Behaviour)object, LOAD_TEST_STATE);
        object = new OneShotBehaviour(){

            public void action() {
                int n = -1;
                try {
                    Integer n2 = (Integer)this.getDataStore().get((Object)TestGroupExecutor.TEST_RESULT_KEY);
                    if (n2 != null) {
                        n = n2;
                    }
                }
                catch (Exception exception) {
                    System.out.println("TestGroupExecutor exception");
                    exception.printStackTrace();
                }
                if (n == 1) {
                    TestGroupExecutor.this.log("Test PASSED");
                    ++TestGroupExecutor.this.passedCnt;
                    TestGroupExecutor.this.sendTestResultNotification(1);
                } else if (n == 0) {
                    TestGroupExecutor.this.log("Test FAILED");
                    ++TestGroupExecutor.this.failedCnt;
                    TestGroupExecutor.this.sendTestResultNotification(0);
                } else {
                    TestGroupExecutor.this.log("WARNING: Test result not available!!!");
                    ++TestGroupExecutor.this.skippedCnt;
                }
            }
        };
        object.setDataStore(this.getDataStore());
        this.registerState((Behaviour)object, HANDLE_RESULT_STATE);
        object = new OneShotBehaviour(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void action() {
                if (TestGroupExecutor.this.currentTest != null) {
                    try {
                        TestGroupExecutor.this.currentTest.clean(this.myAgent);
                    }
                    catch (Exception exception) {
                        TestGroupExecutor.this.log("Warning: Exception in test cleaning [" + exception.getMessage() + "]");
                    }
                    finally {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
        };
        object.setDataStore(this.getDataStore());
        this.registerState((Behaviour)object, CLEAN_TEST_STATE);
        object = new OneShotBehaviour(){

            public void action() {
                if (!TestGroupExecutor.this.aborted) {
                    StringBuffer stringBuffer = new StringBuffer("\n--------------------------------------------\n");
                    stringBuffer.append("--------------------------------------------\n");
                    stringBuffer.append("Test summary:\n");
                    stringBuffer.append(TestGroupExecutor.this.passedCnt + " tests PASSED\n");
                    stringBuffer.append(TestGroupExecutor.this.failedCnt + " tests FAILED\n");
                    if (TestGroupExecutor.this.skippedCnt > 0) {
                        stringBuffer.append(TestGroupExecutor.this.skippedCnt + " tests SKIPPED due to initialization/termination problems\n");
                    }
                    TestGroupExecutor.this.log(stringBuffer.toString());
                    TestGroupExecutor.this.tests.shutdown(this.myAgent);
                }
            }
        };
        object.setDataStore(this.getDataStore());
        this.registerLastState((Behaviour)object, END_STATE);
        object = new SimpleBehaviour(){
            private boolean finished;

            public void action() {
                if (TestGroupExecutor.this.inPause) {
                    this.block();
                    this.finished = false;
                } else {
                    this.finished = true;
                }
            }

            public boolean done() {
                return this.finished;
            }

            public int onEnd() {
                TestGroupExecutor.this.flushMessageQueue();
                return 0;
            }
        };
        object.setDataStore(this.getDataStore());
        this.registerState((Behaviour)object, PAUSE_STATE);
    }

    void resume() {
        this.inPause = false;
        super.restart();
    }

    void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    private void sendTestResultNotification(int n) {
        String string = this.currentTest.getDescriptor().getName();
        String string2 = null;
        if (n != 1) {
            string2 = this.currentTest.getErrorMsg();
        }
        TestResult testResult = new TestResult(string, n, string2);
        ((TesterAgent)this.myAgent).notifyController(testResult);
    }

    private void flushMessageQueue() {
        while (this.myAgent.receive() != null) {
        }
    }

    private void log(String string) {
        Logger.getLogger().log(string);
    }

    private class DummyTest
    extends Test {
        private DummyTest(TestDescriptor testDescriptor) {
            this.setDescriptor(testDescriptor);
        }
    }
}

