/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.ContentManager;
import jade.content.lang.Codec;
import jade.content.lang.leap.LEAPCodec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ContainerID;
import jade.core.Profile;
import jade.domain.FIPAService;
import jade.domain.JADEAgentManagement.CreateAgent;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.domain.JADEAgentManagement.KillAgent;
import jade.domain.JADEAgentManagement.KillContainer;
import jade.domain.mobility.MobilityOntology;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import java.io.File;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.UUID;
import test.common.ExecException;
import test.common.JadeController;
import test.common.LocalJadeController;
import test.common.ManualJadeController;
import test.common.OutputHandler;
import test.common.RemoteJadeController;
import test.common.TestException;
import test.common.agentConfigurationOntology.AddBehaviour;
import test.common.agentConfigurationOntology.AgentConfigurationOntology;
import test.common.remote.RemoteManager;

public class TestUtility {
    private static boolean verbose = true;
    public static String HTTP_MTP_CLASSPATH = "";
    public static String HTTP_MTP_ARG = "";
    public static final String CONFIGURABLE_AGENT = "test.common.ConfigurableAgent";
    private static final String SPY_NOTIFICATION = "spy-notification";
    private static int spyCnt = -1;
    private static ContentManager cm = new ContentManager();
    private static Codec codec = new LEAPCodec();
    private static Ontology onto = AgentConfigurationOntology.getInstance();
    private static RemoteManager defaultRm = null;

    public static AID createAgent(Agent agent, String string, String string2, Object[] objectArray) throws TestException {
        return TestUtility.createAgent(agent, string, string2, objectArray, null, null);
    }

    public static AID createAgent(Agent agent, String string, String string2, Object[] objectArray, AID aID, String string3) throws TestException {
        if (aID == null) {
            aID = agent.getAMS();
        }
        CreateAgent createAgent = new CreateAgent();
        createAgent.setAgentName(string);
        createAgent.setClassName(string2);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                createAgent.addArguments(objectArray[i]);
            }
        }
        if (string3 != null) {
            createAgent.setContainer(new ContainerID(string3, null));
        } else if (aID.equals((Object)agent.getAMS())) {
            createAgent.setContainer((ContainerID)agent.here());
        } else {
            createAgent.setContainer(new ContainerID("Main-Container", null));
        }
        try {
            TestUtility.requestAMSAction(agent, aID, (AgentAction)createAgent);
            return TestUtility.createNewAID(string, aID);
        }
        catch (TestException testException) {
            throw new TestException("Error creating Agent " + string, testException.getNested());
        }
    }

    public static void killAgent(Agent agent, AID aID) throws TestException {
        TestUtility.killAgent(agent, aID, null);
    }

    public static void killAgent(Agent agent, AID aID, AID aID2) throws TestException {
        if (aID2 == null) {
            aID2 = TestUtility.createNewAID("ams", aID);
        }
        ACLMessage aCLMessage = TestUtility.createRequestMessage(agent, aID2, "fipa-sl0", "JADE-Agent-Management");
        KillAgent killAgent = new KillAgent();
        killAgent.setAgent(aID);
        try {
            TestUtility.requestAMSAction(agent, aID2, (AgentAction)killAgent);
        }
        catch (TestException testException) {
            throw new TestException("Error killing TargetAgent " + aID.getName(), testException.getNested());
        }
    }

    public static void killContainer(Agent agent, AID aID, String string) throws TestException {
        if (aID == null) {
            aID = TestUtility.createNewAID("ams", agent.getAID());
        }
        KillContainer killContainer = new KillContainer();
        ContainerID containerID = new ContainerID();
        containerID.setName(string);
        killContainer.setContainer(containerID);
        try {
            TestUtility.requestAMSAction(agent, aID, (AgentAction)killContainer);
        }
        catch (TestException testException) {
            throw new TestException("Error killing container " + string, testException.getNested());
        }
    }

    public static void killContainer(Agent agent, String string) throws TestException {
        TestUtility.killContainer(agent, null, string);
    }

    public static Object requestAMSAction(Agent agent, AID aID, AgentAction agentAction) throws TestException {
        return TestUtility.requestAMSAction(agent, aID, agentAction, "JADE-Agent-Management");
    }

    public static Object requestAMSAction(Agent agent, AID aID, AgentAction agentAction, String string) throws TestException {
        return TestUtility.requestAMSAction(agent, aID, agentAction, string, 30000L);
    }

    public static Object requestAMSAction(Agent agent, AID aID, AgentAction agentAction, String string, long l) throws TestException {
        try {
            if (aID == null) {
                aID = agent.getAMS();
            }
            ACLMessage aCLMessage = TestUtility.createRequestMessage(agent, aID, "fipa-sl0", "JADE-Agent-Management");
            Action action = new Action();
            action.setActor(aID);
            action.setAction((Concept)agentAction);
            aCLMessage.setLanguage("fipa-sl0");
            aCLMessage.setOntology(string == null ? "JADE-Agent-Management" : string);
            cm.fillContent(aCLMessage, (ContentElement)action);
            ACLMessage aCLMessage2 = FIPAService.doFipaRequestClient((Agent)agent, (ACLMessage)aCLMessage, (long)l);
            if (aCLMessage2 != null) {
                ContentElement contentElement = cm.extractContent(aCLMessage2);
                if (contentElement instanceof Done) {
                    return null;
                }
                if (contentElement instanceof Result) {
                    return ((Result)contentElement).getValue();
                }
                throw new TestException("Unknown notification received from " + aID);
            }
            throw new TestException("Timeout expired");
        }
        catch (Exception exception) {
            throw new TestException("Error executing action " + agentAction, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBehaviour(Agent agent, AID aID, String string) throws TestException {
        try {
            ACLMessage aCLMessage = TestUtility.createRequestMessage(agent, aID, codec.getName(), onto.getName());
            AddBehaviour addBehaviour = new AddBehaviour(null, string);
            ContentManager contentManager = cm;
            synchronized (contentManager) {
                cm.fillContent(aCLMessage, (ContentElement)addBehaviour);
            }
            FIPAService.doFipaRequestClient((Agent)agent, (ACLMessage)aCLMessage);
        }
        catch (Exception exception) {
            throw new TestException("Error adding behaviour " + string + " to agent " + aID.getName(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceAction(Agent agent, AID aID, AgentAction agentAction) throws TestException {
        try {
            ACLMessage aCLMessage = TestUtility.createRequestMessage(agent, aID, codec.getName(), onto.getName());
            ContentManager contentManager = cm;
            synchronized (contentManager) {
                cm.fillContent(aCLMessage, (ContentElement)agentAction);
            }
            FIPAService.doFipaRequestClient((Agent)agent, (ACLMessage)aCLMessage);
        }
        catch (Exception exception) {
            throw new TestException("Error forcing action " + agentAction + " to agent " + aID.getName(), exception);
        }
    }

    public static JadeController launchJadeInstance(String string, String string2, String string3, String[] stringArray) throws TestException {
        return TestUtility.launchJadeInstance(null, string, string2, string3, stringArray);
    }

    public static JadeController launchJadeInstance(RemoteManager remoteManager, String string, String string2, String string3, String[] stringArray) throws TestException {
        return TestUtility.launch(remoteManager, string, string2, null, "jade.Boot", string3, stringArray, null);
    }

    public static JadeController launchSplitJadeInstance(String string, String string2, String string3) throws TestException {
        return TestUtility.launchSplitJadeInstance(null, string, string2, string3);
    }

    public static JadeController launchSplitJadeInstance(RemoteManager remoteManager, String string, String string2, String string3) throws TestException {
        return TestUtility.launch(remoteManager, string, string2, null, "jade.MicroBoot", string3, null, null);
    }

    public static JadeController launch(RemoteManager remoteManager, String string, String string2, String string3, String string4, String string5, String[] stringArray, OutputHandler outputHandler) throws TestException {
        JadeController jadeController = null;
        if (remoteManager == null) {
            remoteManager = defaultRm;
        }
        if (remoteManager != null) {
            try {
                int n = remoteManager.launchJadeInstance(string, string2, string3, string4, string5, stringArray);
                jadeController = new RemoteJadeController(remoteManager, n);
            }
            catch (RemoteException remoteException) {
                throw new TestException("Communication error launching JADE instance remotely", remoteException);
            }
        } else {
            jadeController = TestUtility.localLaunch(string, string2, string3, string4, string5, stringArray, outputHandler, null);
        }
        return jadeController;
    }

    public static JadeController localLaunch(String string, String charSequence, String string2, String string3, String string4, String[] stringArray, OutputHandler outputHandler, String string5) throws TestException {
        JadeController jadeController;
        String[] stringArray2;
        CharSequence charSequence2;
        if (string2 == null) {
            string2 = "";
        }
        String string6 = UUID.randomUUID().toString();
        string2 = string2 + " -Dstartup-tag=" + string6;
        if (System.getProperty("project-home") != null) {
            string2 = string2 + " -Dproject-home=" + System.getProperty("project-home");
        }
        String string7 = "";
        if (string2.indexOf("-cp ") < 0 && string2.indexOf("-classpath ") < 0) {
            if (charSequence == null || ((String)charSequence).startsWith("+")) {
                charSequence2 = System.getProperty("java.class.path");
                charSequence = charSequence == null ? charSequence2 : ((String)charSequence).substring(1) + System.getProperty("path.separator") + (String)charSequence2;
            }
            charSequence2 = new StringBuilder();
            for (String string8 : stringArray2 = ((String)charSequence).split(File.pathSeparator)) {
                if (string8.startsWith("\"") || System.getProperty("os.name").toLowerCase().indexOf("windows") == -1) {
                    ((StringBuilder)charSequence2).append(string8);
                } else {
                    ((StringBuilder)charSequence2).append("\"");
                    ((StringBuilder)charSequence2).append(string8);
                    ((StringBuilder)charSequence2).append("\"");
                }
                ((StringBuilder)charSequence2).append(File.pathSeparator);
            }
            charSequence = ((StringBuilder)charSequence2).toString();
            string7 = "-cp " + (String)charSequence;
        }
        charSequence2 = "java ";
        stringArray2 = System.getenv("JAVA_HOME");
        if (stringArray2 != null) {
            charSequence2 = (String)stringArray2 + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + (String)charSequence2;
        }
        String string9 = (String)charSequence2 + string7 + " " + string2 + " -DTSDaemon=true " + string3 + " " + string4;
        if ("true".equalsIgnoreCase(System.getProperty("DEBUG"))) {
            System.out.println("Manual launch!!!!!!!!!!!!!!");
            jadeController = new ManualJadeController(string, string9, stringArray);
        } else {
            try {
                jadeController = new LocalJadeController(string, string9, stringArray, outputHandler, string5, string6);
            }
            catch (ExecException execException) {
                System.out.println("Error launching JADE. Check the JAVA_HOME environment variable (JAVA_HOME=" + (String)stringArray2 + ")");
                throw execException;
            }
        }
        return jadeController;
    }

    public static RemoteManager createRemoteManager(String string, int n, String string2) throws TestException {
        String string3 = "rmi://" + string + ":" + n + "//" + string2;
        try {
            return (RemoteManager)Naming.lookup(string3);
        }
        catch (Exception exception) {
            throw new TestException("Error looking up remote manager " + string3, exception);
        }
    }

    public static void setDefaultRemoteManager(RemoteManager remoteManager) {
        defaultRm = remoteManager;
    }

    public static RemoteManager getDefaultRemoteManager() {
        return defaultRm;
    }

    public static String getLocalHostName() throws TestException {
        return Profile.getDefaultNetworkName();
    }

    public static String getContainerHostName(Agent agent, String string) throws TestException {
        return TestUtility.getContainerHostName(agent, null, string);
    }

    public static String getContainerHostName(Agent agent, AID aID, String string) throws TestException {
        try {
            Iterator iterator;
            ArrayList arrayList;
            if (string == null) {
                string = "Main-Container";
            }
            Object[] objectArray = null;
            if (aID == null || agent.getAMS().equals((Object)aID)) {
                objectArray = new String[]{agent.getLocalName()};
            } else {
                arrayList = new ArrayList();
                arrayList.add((Object)agent.getName());
                iterator = agent.getAID().getAllAddresses();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                objectArray = new String[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    objectArray[i] = (String)arrayList.get(i);
                }
            }
            arrayList = TestUtility.createAgent(agent, "spy" + ++spyCnt, "test.common.TestUtility$HostSpyAgent", objectArray, aID, string);
            iterator = agent.blockingReceive(MessageTemplate.MatchConversationId((String)SPY_NOTIFICATION), 10000L);
            if (iterator != null) {
                if (iterator.getPerformative() == 7) {
                    return iterator.getContent();
                }
                throw new TestException("Can't get hostname for container " + string + ": FAILURE received");
            }
            throw new TestException("Can't get hostname for container " + string + ": timeout expired");
        }
        catch (Exception exception) {
            throw new TestException("Can't get hostname for container " + string, exception);
        }
    }

    private static ACLMessage createRequestMessage(Agent agent, AID aID, String string, String string2) {
        ACLMessage aCLMessage = new ACLMessage(16);
        aCLMessage.setSender(agent.getAID());
        aCLMessage.addReceiver(aID);
        aCLMessage.setProtocol("fipa-request");
        aCLMessage.setLanguage(string);
        aCLMessage.setOntology(string2);
        aCLMessage.setReplyWith("rw" + agent.getName() + new Date().getTime());
        aCLMessage.setConversationId("conv" + agent.getName() + new Date().getTime());
        return aCLMessage;
    }

    public static AID createNewAID(String string, AID aID) {
        String string2 = aID.getName();
        String string3 = null;
        int n = string2.lastIndexOf(64);
        string3 = n == -1 ? string2 : string2.substring(n + 1);
        AID aID2 = new AID(string + "@" + string3, true);
        Iterator iterator = aID.getAllAddresses();
        while (iterator.hasNext()) {
            aID2.addAddresses((String)iterator.next());
        }
        return aID2;
    }

    public static void log(String string) {
        if (verbose) {
            System.out.println(string);
        }
    }

    public static void log(Object object) {
        TestUtility.log(object.toString());
    }

    public static void log(Throwable throwable) {
        if (verbose) {
            throwable.printStackTrace();
        }
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    static {
        cm.registerLanguage(codec);
        cm.registerOntology(onto);
        cm.registerLanguage((Codec)new SLCodec(0), "fipa-sl0");
        cm.registerOntology(JADEManagementOntology.getInstance());
        cm.registerOntology(MobilityOntology.getInstance());
    }

    public static class HostSpyAgent
    extends Agent {
        protected void setup() {
            Object[] objectArray = this.getArguments();
            if (objectArray.length > 0) {
                AID aID = null;
                if (objectArray.length == 1) {
                    aID = new AID((String)objectArray[0], false);
                } else {
                    aID = new AID((String)objectArray[0], true);
                    for (int i = 1; i < objectArray.length; ++i) {
                        aID.addAddresses((String)objectArray[i]);
                    }
                }
                ACLMessage aCLMessage = new ACLMessage(7);
                aCLMessage.addReceiver(aID);
                aCLMessage.setConversationId(TestUtility.SPY_NOTIFICATION);
                try {
                    aCLMessage.setContent(TestUtility.getLocalHostName());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    aCLMessage.setPerformative(6);
                }
                this.send(aCLMessage);
            }
            this.doDelete();
        }
    }
}

