/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.Predicate;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREResponder;
import jade.proto.states.ReplySender;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import test.common.Logger;
import test.common.TestGroup;
import test.common.TestGroupExecutor;
import test.common.testSuite.gui.InsertArgumentsDlg;
import test.common.testSuite.gui.SelectTestsDlg;
import test.common.testerAgentControlOntology.Configure;
import test.common.testerAgentControlOntology.ExecResult;
import test.common.testerAgentControlOntology.Execute;
import test.common.testerAgentControlOntology.Exit;
import test.common.testerAgentControlOntology.NumberOfTests;
import test.common.testerAgentControlOntology.Resume;
import test.common.testerAgentControlOntology.SelectTests;
import test.common.testerAgentControlOntology.TesterAgentControlOntology;
import test.common.xml.TestDescriptor;

public abstract class TesterAgent
extends Agent {
    public static final String TEST_NOTIFICATION = "test-notification";
    private Codec codec = new SLCodec();
    private Ontology onto = TesterAgentControlOntology.getInstance();
    private TestGroup theTestGroup = null;
    private boolean remoteControlMode = false;
    private AID remoteControllerAID = null;
    private ACLMessage exitNotification = null;

    protected void setup() {
        this.getContentManager().registerLanguage(this.codec);
        this.getContentManager().registerOntology(this.onto);
        Object[] objectArray = this.getArguments();
        try {
            if ("true".equalsIgnoreCase((String)objectArray[0])) {
                this.remoteControlMode = true;
            }
            String string = (String)objectArray[1];
            this.remoteControllerAID = new AID(string, false);
            System.out.println("TesterAgent " + this.getLocalName() + " running in controlled mode: controller is " + string);
        }
        catch (Exception exception) {
            System.out.println("TesterAgent " + this.getLocalName() + " running in stand-alone mode");
        }
        this.theTestGroup = this.getTestGroup();
        this.theTestGroup.setArguments(this.theTestGroup.getArgumentsSpecification());
        if (this.remoteControlMode) {
            this.addBehaviour((Behaviour)new Controller(this));
            this.notifyController(new NumberOfTests(this.theTestGroup.size()));
        } else {
            this.addBehaviour((Behaviour)new TestGroupExecutor(this, this.theTestGroup){

                public int onEnd() {
                    this.myAgent.doDelete();
                    return 0;
                }
            });
        }
    }

    protected void takeDown() {
        if (this.remoteControlMode) {
            if (this.exitNotification != null) {
                this.send(this.exitNotification);
            }
        } else {
            Logger.getLogger().log("Exit...");
            Logger.getLogger().closeLogger();
        }
    }

    protected abstract TestGroup getTestGroup();

    void notifyController(Predicate predicate) {
        ACLMessage aCLMessage = new ACLMessage(7);
        aCLMessage.addReceiver(this.remoteControllerAID);
        aCLMessage.setLanguage(this.codec.getName());
        aCLMessage.setOntology(this.onto.getName());
        aCLMessage.setConversationId(TEST_NOTIFICATION);
        try {
            this.getContentManager().fillContent(aCLMessage, (ContentElement)predicate);
            this.send(aCLMessage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class Controller
    extends AchieveREResponder {
        private TestGroupExecutor executor;
        private Action aa;
        private AgentAction requestedAction;

        Controller(Agent agent) {
            super(agent, MessageTemplate.MatchOntology((String)TesterAgentControlOntology.getInstance().getName()));
        }

        protected ACLMessage prepareResponse(ACLMessage aCLMessage) throws NotUnderstoodException, RefuseException {
            try {
                this.aa = (Action)this.myAgent.getContentManager().extractContent(aCLMessage);
                this.requestedAction = (AgentAction)this.aa.getAction();
            }
            catch (Exception exception) {
                throw new NotUnderstoodException(exception.getMessage());
            }
            return null;
        }

        protected ACLMessage prepareResultNotification(ACLMessage aCLMessage, ACLMessage aCLMessage2) throws FailureException {
            if (this.requestedAction instanceof Execute) {
                final ACLMessage aCLMessage3 = aCLMessage;
                TesterAgent.this.theTestGroup.reset();
                this.executor = new TestGroupExecutor(TesterAgent.this, TesterAgent.this.theTestGroup){

                    public int onEnd() {
                        Controller.this.executor = null;
                        ACLMessage aCLMessage = Controller.this.createInform((AgentAction)Controller.this.aa, aCLMessage3, this.passedCnt, this.failedCnt, this.skippedCnt);
                        ReplySender.adjustReply((Agent)this.myAgent, (ACLMessage)aCLMessage, (ACLMessage)aCLMessage3);
                        this.myAgent.send(aCLMessage);
                        return 0;
                    }
                };
                this.executor.setDebugMode(((Execute)this.requestedAction).getDebugMode());
                this.myAgent.addBehaviour((Behaviour)this.executor);
                return null;
            }
            if (this.requestedAction instanceof Configure) {
                List list = TesterAgent.this.theTestGroup.getArgumentsSpecification();
                if (list != null && list.size() > 0) {
                    InsertArgumentsDlg.insertValues(list);
                }
                TesterAgent.this.theTestGroup.setArguments(list);
                return this.createInform((AgentAction)this.aa, aCLMessage);
            }
            if (this.requestedAction instanceof SelectTests) {
                TestDescriptor[] testDescriptorArray = TesterAgent.this.theTestGroup.getDescriptors();
                if (testDescriptorArray != null && testDescriptorArray.length > 0) {
                    SelectTestsDlg.selectTests(testDescriptorArray);
                }
                return this.createInform((AgentAction)this.aa, aCLMessage);
            }
            if (this.requestedAction instanceof Resume) {
                if (this.executor != null) {
                    this.executor.setDebugMode(((Resume)this.requestedAction).getDebugMode());
                    this.executor.resume();
                    return this.createInform((AgentAction)this.aa, aCLMessage);
                }
                throw new FailureException("Test group not in execution");
            }
            if (this.requestedAction instanceof Exit) {
                TesterAgent.this.exitNotification = this.createInform((AgentAction)this.aa, aCLMessage);
                ReplySender.adjustReply((Agent)this.myAgent, (ACLMessage)TesterAgent.this.exitNotification, (ACLMessage)aCLMessage);
                this.myAgent.doDelete();
                return null;
            }
            throw new FailureException("Unknown action");
        }

        private ACLMessage createInform(AgentAction agentAction, ACLMessage aCLMessage) {
            ACLMessage aCLMessage2 = aCLMessage.createReply();
            aCLMessage2.setPerformative(7);
            try {
                Done done = new Done((Concept)agentAction);
                this.myAgent.getContentManager().fillContent(aCLMessage2, (ContentElement)done);
            }
            catch (Exception exception) {
                Logger.getLogger().logStackTrace(exception);
            }
            return aCLMessage2;
        }

        private ACLMessage createInform(AgentAction agentAction, ACLMessage aCLMessage, int n, int n2, int n3) {
            ACLMessage aCLMessage2 = aCLMessage.createReply();
            aCLMessage2.setPerformative(7);
            try {
                ExecResult execResult = new ExecResult(n, n2, n3);
                ArrayList arrayList = new ArrayList();
                arrayList.add((Object)execResult);
                Result result = new Result((Concept)agentAction, (Object)arrayList);
                this.myAgent.getContentManager().fillContent(aCLMessage2, (ContentElement)result);
            }
            catch (Exception exception) {
                Logger.getLogger().logStackTrace(exception);
            }
            return aCLMessage2;
        }
    }
}

