/*
 * Decompiled with CFR 0.152.
 */
package test.common.remote;

import jade.util.leap.List;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import test.common.JadeController;
import test.common.OutputHandler;
import test.common.TestException;
import test.common.TestUtility;
import test.common.remote.RemoteManager;

public class TSDaemon
extends UnicastRemoteObject
implements RemoteManager,
OutputHandler {
    public static final String DEFAULT_NAME = "TSDaemon";
    public static final int DEFAULT_PORT = 7777;
    private Hashtable controllers = new Hashtable();
    private int instanceCnt = 0;
    private String additionalArgs = null;

    public TSDaemon() throws RemoteException {
        super(Integer.parseInt(System.getProperty("tsdaemon.remoteobjectport", "0")));
    }

    public TSDaemon(int n) throws RemoteException {
        super(n);
    }

    protected void printWelcomeMessage(String string, String string2) {
        System.out.println("Test Suite Daemon ready on port " + string + " using name: " + string2);
    }

    public static void main(String[] stringArray) {
        try {
            TSDaemon tSDaemon = new TSDaemon();
            tSDaemon.start(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void start(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(" ");
            }
        }
        try {
            String string = System.getProperty("tsdaemon.name", DEFAULT_NAME);
            String string2 = System.getProperty("tsdaemon.port", String.valueOf(7777));
            String string3 = InetAddress.getLocalHost().getHostName();
            Registry registry = TSDaemon.getRmiRegistry(string3, Integer.parseInt(string2));
            String string4 = "rmi://" + string3 + ":" + string2;
            this.additionalArgs = stringBuffer.toString();
            Naming.bind(string4 + "//" + string, this);
            this.printWelcomeMessage(string2, string);
        }
        catch (Exception exception) {
            System.out.println("ERROR starting Test Suite Daemon");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static Registry getRmiRegistry(String string, int n) throws RemoteException {
        Registry registry = null;
        try {
            registry = LocateRegistry.getRegistry(string, n);
            registry.list();
        }
        catch (Exception exception) {
            registry = null;
        }
        if (registry == null) {
            registry = LocateRegistry.createRegistry(n);
        }
        return registry;
    }

    protected int localLaunchJadeInstance(String string, String string2, String string3, String string4, String string5, String[] stringArray, OutputHandler outputHandler, String string6) throws TestException {
        ++this.instanceCnt;
        string5 = this.additionalArgs + string5;
        JadeController jadeController = null;
        jadeController = TestUtility.localLaunch(string, string2, string3, string4, string5, stringArray, outputHandler, string6);
        this.controllers.put(new Integer(this.instanceCnt), jadeController);
        return this.instanceCnt;
    }

    public int launchJadeInstance(String string, String string2, String string3, String string4, String string5, String[] stringArray) throws TestException, RemoteException {
        ++this.instanceCnt;
        string5 = this.additionalArgs + string5;
        JadeController jadeController = null;
        jadeController = TestUtility.launch(null, string, string2, string3, string4, string5, stringArray, this);
        this.controllers.put(new Integer(this.instanceCnt), jadeController);
        return this.instanceCnt;
    }

    public List getJadeInstanceAddresses(int n) throws TestException, RemoteException {
        JadeController jadeController = (JadeController)this.controllers.get(new Integer(n));
        if (jadeController != null) {
            return jadeController.getAddresses();
        }
        throw new TestException("No JADE instance corresponding to ID " + n);
    }

    public String getJadeInstanceContainerName(int n) throws TestException, RemoteException {
        JadeController jadeController = (JadeController)this.controllers.get(new Integer(n));
        if (jadeController != null) {
            return jadeController.getContainerName();
        }
        throw new TestException("No JADE instance corresponding to ID " + n);
    }

    public void killJadeInstance(int n) throws TestException, RemoteException {
        JadeController jadeController = (JadeController)this.controllers.remove(new Integer(n));
        if (jadeController == null) {
            throw new TestException("No JADE instance corresponding to ID " + n);
        }
        jadeController.kill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJadeInstanceId(String string) throws TestException, RemoteException {
        Hashtable hashtable = this.controllers;
        synchronized (hashtable) {
            for (Integer n : this.controllers.keySet()) {
                JadeController jadeController = (JadeController)this.controllers.get(n);
                if (!jadeController.getContainerName().equalsIgnoreCase(string)) continue;
                return n;
            }
            return -1;
        }
    }

    public void handleOutput(String string, String string2) {
        System.out.println("###" + string + ">> " + string2);
    }

    public void handleTermination(int n) {
        System.out.println("Process terminated with exitValue=" + n);
    }
}

