/*
 * Decompiled with CFR 0.152.
 */
package test.common.testSuite;

import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.Predicate;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.Profile;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.domain.JADEAgentManagement.ShutdownPlatform;
import jade.gui.GuiAgent;
import jade.gui.GuiEvent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREInitiator;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import jade.wrapper.AgentContainer;
import jade.wrapper.AgentController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import test.common.JadeController;
import test.common.Logger;
import test.common.TestUtility;
import test.common.behaviours.ListProcessor;
import test.common.testSuite.gui.TestSuiteGui;
import test.common.testerAgentControlOntology.Configure;
import test.common.testerAgentControlOntology.ExecResult;
import test.common.testerAgentControlOntology.Execute;
import test.common.testerAgentControlOntology.Exit;
import test.common.testerAgentControlOntology.NumberOfTests;
import test.common.testerAgentControlOntology.Resume;
import test.common.testerAgentControlOntology.SelectTests;
import test.common.testerAgentControlOntology.TestResult;
import test.common.testerAgentControlOntology.TesterAgentControlOntology;
import test.common.xml.FunctionalityDescriptor;
import test.common.xml.XMLManager;

public class TestSuiteAgent
extends GuiAgent {
    private static ACLMessage AMSRequest = new ACLMessage(16);
    public static JadeController mainController;
    public static final String MAIN_SERVICES = "jade.core.mobility.AgentMobilityService;jade.core.event.NotificationService;jade.core.replication.MainReplicationService;jade.core.replication.AddressNotificationService;jade.core.messaging.PersistentDeliveryService;jade.core.messaging.TopicManagementService";
    public static final String TEST_PLATFORM_NAME = "TestPlatform";
    private static final String NAME = "test-suite";
    private static final String TESTER_NAME = "tester";
    public static final int LOAD_EVENT = 0;
    public static final int RUN_EVENT = 2;
    public static final int DEBUG_EVENT = 3;
    public static final int CONFIGURE_EVENT = 4;
    public static final int STEP_EVENT = 5;
    public static final int GO_EVENT = 6;
    public static final int EXIT_EVENT = 7;
    public static final int SELECT_EVENT = 8;
    public static final int RUNALL_EVENT = 9;
    public static final int TEST_CLICK_EVENT = 10;
    private Hashtable groupTestsResults;
    private Hashtable runAllTestsResults = new Hashtable();
    private Hashtable runAllSummaries = new Hashtable();
    private boolean runAllSuccessful;
    private boolean firstGroup;
    private Codec codec;
    private TestSuiteGui myGui;
    private long startTime;
    Timer timer = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            TestSuiteAgent.this.updateElapsedTime();
        }
    });
    private String xmlFileName = "test/testerList.xml";
    private FunctionalityDescriptor[] allFunc;
    private FunctionalityDescriptor currentFunc;

    protected void setup() {
        Object[] objectArray = this.getArguments();
        if (objectArray != null && objectArray.length > 0) {
            this.xmlFileName = (String)objectArray[0];
        }
        System.out.println("Loading functionality list form file " + this.xmlFileName);
        this.allFunc = XMLManager.getFunctionalities(this.xmlFileName);
        this.codec = new SLCodec();
        this.getContentManager().registerLanguage(this.codec);
        this.getContentManager().registerOntology(TesterAgentControlOntology.getInstance());
        this.myGui = new TestSuiteGui(this, this.xmlFileName);
        this.myGui.showCorrect();
        CyclicReceiver cyclicReceiver = new CyclicReceiver((Agent)this);
        this.addBehaviour((Behaviour)cyclicReceiver);
        if (System.getProperty("test.common.testSuite.TestSuiteAgent.runAutomatic") != null) {
            Logger.getLogger();
            Logger.setFileLogger(1);
            this.onGuiEvent(new GuiEvent((Object)this, 9));
        }
    }

    protected void takeDown() {
        Logger.getLogger().closeLogger();
        if (this.myGui != null) {
            this.myGui.dispose();
        }
    }

    public TestResult getTestResult(String string, String string2) {
        Hashtable hashtable = null;
        hashtable = string2 != null ? (Hashtable)this.runAllTestsResults.get(string2) : this.groupTestsResults;
        if (hashtable != null) {
            TestResult testResult = (TestResult)hashtable.get(string);
            return testResult;
        }
        return null;
    }

    protected void onGuiEvent(GuiEvent guiEvent) {
        Logger logger = Logger.getLogger();
        switch (guiEvent.getType()) {
            case 0: {
                this.groupTestsResults = new Hashtable();
                this.myGui.clearFailedTestsMessage();
                final FunctionalityDescriptor functionalityDescriptor = (FunctionalityDescriptor)guiEvent.getParameter(0);
                if (this.myGui.getStatus() == 0) {
                    this.loadTester(functionalityDescriptor);
                    break;
                }
                this.addBehaviour((Behaviour)new Requester((Agent)this, new Exit()){

                    public int onEnd() {
                        TestSuiteAgent.waitABit();
                        TestSuiteAgent.this.loadTester(functionalityDescriptor);
                        return 0;
                    }
                });
                break;
            }
            case 2: {
                this.groupTestsResults.clear();
                this.startTime = System.currentTimeMillis();
                this.timer.start();
                if (logger.getLoggerType() == 2) {
                    Logger.addIndex("Single Group Execution", this.currentFunc.toString());
                    Logger.addBodyHeading(this.currentFunc.toString());
                    logger.incBlockCounter();
                }
                this.addBehaviour((Behaviour)new Requester((Agent)this, new Execute(false)){

                    public int onEnd() {
                        TestSuiteAgent.this.timer.stop();
                        TestSuiteAgent.this.updateElapsedTime();
                        TestSuiteAgent.this.myGui.setStatus(1);
                        TestSuiteAgent.this.myGui.getStatusLabel().setText("Done");
                        TestSuiteAgent.this.myGui.getStatusLabel().setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/test/common/testSuite/gui/images/idle_buttons.gif")));
                        return 0;
                    }
                });
                this.myGui.clearFailedTestsMessage();
                break;
            }
            case 9: {
                final ArrayList arrayList = new ArrayList();
                if (this.allFunc == null) break;
                for (int i = 0; i < this.allFunc.length; ++i) {
                    arrayList.add(i, (Object)this.allFunc[i]);
                }
                if (this.myGui.getStatus() == 0) {
                    this.addBehaviour((Behaviour)new AllTesterExecutor((Agent)this, arrayList));
                    break;
                }
                this.addBehaviour((Behaviour)new Requester((Agent)this, new Exit()){

                    public int onEnd() {
                        TestSuiteAgent.waitABit();
                        TestSuiteAgent.this.addBehaviour((Behaviour)new AllTesterExecutor(this.myAgent, arrayList));
                        return 0;
                    }
                });
                break;
            }
            case 3: {
                this.groupTestsResults.clear();
                this.myGui.getStatusLabel().setText("Debug Mode, press Next or Run to continue");
                this.myGui.getStatusLabel().setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/test/common/testSuite/gui/images/blink_buttons.gif")));
                if (logger.getLoggerType() == 2) {
                    Logger.addIndex("Debug Mode", this.currentFunc.toString());
                    Logger.addBodyHeading(this.currentFunc.toString());
                    logger.incBlockCounter();
                }
                this.addBehaviour((Behaviour)new Requester((Agent)this, new Execute(true)){

                    public int onEnd() {
                        TestSuiteAgent.this.myGui.getStatusLabel().setText("Done");
                        TestSuiteAgent.this.myGui.getStatusLabel().setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/test/common/testSuite/gui/images/idle_buttons.gif")));
                        TestSuiteAgent.this.myGui.setStatus(1);
                        return 0;
                    }
                });
                break;
            }
            case 4: {
                this.addBehaviour((Behaviour)new Requester((Agent)this, new Configure()){

                    public int onEnd() {
                        TestSuiteAgent.this.myGui.setStatus(1);
                        return 0;
                    }
                });
                break;
            }
            case 8: {
                this.addBehaviour((Behaviour)new Requester((Agent)this, new SelectTests()){

                    public int onEnd() {
                        TestSuiteAgent.this.myGui.setStatus(1);
                        return 0;
                    }
                });
                break;
            }
            case 5: {
                this.myGui.getStatusLabel().setText("Sigle test execution...");
                this.myGui.getStatusLabel().setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/test/common/testSuite/gui/images/progress_buttons.gif")));
                this.addBehaviour((Behaviour)new Requester((Agent)this, new Resume(true)));
                break;
            }
            case 6: {
                this.addBehaviour((Behaviour)new Requester((Agent)this, new Resume(false)));
                break;
            }
            case 7: {
                if (this.myGui.getStatus() == 0) {
                    this.doDelete();
                    break;
                }
                this.addBehaviour((Behaviour)new Requester((Agent)this, new Exit()){

                    public int onEnd() {
                        TestSuiteAgent.this.doDelete();
                        return 0;
                    }
                });
            }
        }
    }

    private void loadTester(FunctionalityDescriptor functionalityDescriptor) {
        block4: {
            Logger.getLogger().log("Loading functionality: " + functionalityDescriptor);
            try {
                TestUtility.createAgent((Agent)this, TESTER_NAME, functionalityDescriptor.getTesterClassName(), new String[]{"true", this.getLocalName()}, this.getAMS(), null);
                if (this.myGui.getStatus() != 6) {
                    this.myGui.setStatus(1);
                }
                this.currentFunc = functionalityDescriptor;
                if (this.myGui.getStatus() == 6) {
                    this.myGui.addToHistory(functionalityDescriptor);
                }
                this.myGui.getTestsTree().showTestsHierarchy(functionalityDescriptor.getTestsListFile(), functionalityDescriptor.getName(), true);
            }
            catch (Exception exception) {
                System.out.println("Error loading tester agent. ");
                exception.printStackTrace();
                Logger.getLogger().log("Error loading tester agent. ");
                Logger.getLogger().logStackTrace(exception);
                if (this.myGui.getStatus() == 6) break block4;
                this.myGui.setStatus(0);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            ProfileImpl profileImpl = new ProfileImpl(null, 1099, null);
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].startsWith("-") || i >= stringArray.length - 1) continue;
                    stringBuffer.append(' ');
                    stringBuffer.append(stringArray[i]);
                    profileImpl.setParameter(stringArray[i].substring(1), stringArray[i + 1]);
                    stringBuffer.append(' ');
                    stringBuffer.append(stringArray[++i]);
                }
            }
            mainController = TestUtility.launchJadeInstance("Main", null, "-gui -nomtp -local-port 1099 -services jade.core.mobility.AgentMobilityService;jade.core.event.NotificationService;jade.core.replication.MainReplicationService;jade.core.replication.AddressNotificationService;jade.core.messaging.PersistentDeliveryService;jade.core.messaging.TopicManagementService -name TestPlatform" + stringBuffer + " -jade_domain_df_autocleanup true", null);
            Runtime runtime = Runtime.instance();
            runtime.setCloseVM(true);
            profileImpl.setParameter("main", "false");
            profileImpl.setParameter("services", "jade.core.event.NotificationService;jade.core.mobility.AgentMobilityService;jade.core.replication.AddressNotificationService;jade.core.messaging.TopicManagementService");
            profileImpl.setSpecifiers("mtps", (List)new ArrayList());
            AgentContainer agentContainer = runtime.createAgentContainer((Profile)profileImpl);
            AgentController agentController = agentContainer.createNewAgent(NAME, TestSuiteAgent.class.getName(), null);
            agentController.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateElapsedTime() {
        this.myGui.setElapsedTime(System.currentTimeMillis() - this.startTime);
    }

    private static void waitABit() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            Logger.getLogger().logStackTrace(exception);
        }
    }

    class Requester
    extends AchieveREInitiator {
        private AgentAction requestedAction;

        Requester(Agent agent, AgentAction agentAction) {
            super(agent, null);
            this.requestedAction = agentAction;
        }

        protected Vector prepareRequests(ACLMessage aCLMessage) {
            Vector<ACLMessage> vector = new Vector<ACLMessage>();
            try {
                AID aID = new AID(TestSuiteAgent.TESTER_NAME, false);
                ACLMessage aCLMessage2 = new ACLMessage(16);
                aCLMessage2.addReceiver(aID);
                aCLMessage2.setLanguage(TestSuiteAgent.this.codec.getName());
                aCLMessage2.setOntology(TesterAgentControlOntology.getInstance().getName());
                Action action = new Action(aID, (Concept)this.requestedAction);
                TestSuiteAgent.this.getContentManager().fillContent(aCLMessage2, (ContentElement)action);
                vector.addElement(aCLMessage2);
            }
            catch (Exception exception) {
                Logger.getLogger().logStackTrace(exception);
            }
            return vector;
        }

        protected void handleInform(ACLMessage aCLMessage) {
            if (this.requestedAction instanceof Execute) {
                try {
                    Result result = (Result)TestSuiteAgent.this.getContentManager().extractContent(aCLMessage);
                    ArrayList arrayList = (ArrayList)result.getItems();
                    ExecResult execResult = (ExecResult)arrayList.get(0);
                    TestSuiteAgent.this.runAllSummaries.put(TestSuiteAgent.this.currentFunc, execResult);
                }
                catch (Exception exception) {
                    Logger.getLogger().logStackTrace(exception);
                }
            }
        }

        protected void handleRefuse(ACLMessage aCLMessage) {
            Logger.getLogger().log("Tester agent action refused. Message is:");
            Logger.getLogger().log(aCLMessage);
        }

        protected void handleNotUnderstood(ACLMessage aCLMessage) {
            Logger.getLogger().log("Tester agent action not understood. Message is:");
            Logger.getLogger().log(aCLMessage);
        }

        protected void handleFailure(ACLMessage aCLMessage) {
            Logger.getLogger().log("Tester agent action failed. Message is:");
            Logger.getLogger().log(aCLMessage);
        }
    }

    class CyclicReceiver
    extends CyclicBehaviour {
        private MessageTemplate templ;

        public CyclicReceiver(Agent agent) {
            super(agent);
            this.templ = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchPerformative((int)7), (MessageTemplate)MessageTemplate.MatchConversationId((String)"test-notification"));
        }

        public void action() {
            ACLMessage aCLMessage = this.myAgent.receive(this.templ);
            if (aCLMessage != null) {
                int n = TestSuiteAgent.this.myGui.getStatus();
                TestSuiteAgent.this.myGui;
                if (n == 4) {
                    TestSuiteGui testSuiteGui = TestSuiteAgent.this.myGui;
                    TestSuiteAgent.this.myGui;
                    testSuiteGui.setStatus(3);
                    TestSuiteAgent.this.myGui.getStatusLabel().setText("Debug Mode, press Next or Run to continue");
                    TestSuiteAgent.this.myGui.getStatusLabel().setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/test/common/testSuite/gui/images/blink_buttons.gif")));
                }
                try {
                    Predicate predicate = (Predicate)TestSuiteAgent.this.getContentManager().extractContent(aCLMessage);
                    if (predicate instanceof TestResult) {
                        TestResult testResult = (TestResult)predicate;
                        TestSuiteAgent.this.groupTestsResults.put(testResult.getName(), testResult);
                        switch (testResult.getResult()) {
                            case 1: {
                                TestSuiteAgent.this.myGui.showPassed(testResult.getName());
                                break;
                            }
                            case 0: {
                                TestSuiteAgent.this.myGui.showFailed(testResult.getName());
                                TestSuiteAgent.this.runAllSuccessful = false;
                                break;
                            }
                            case 2: {
                                TestSuiteAgent.this.myGui.showSkipped(testResult.getName());
                            }
                        }
                    } else if (predicate instanceof NumberOfTests) {
                        NumberOfTests numberOfTests = (NumberOfTests)predicate;
                        TestSuiteAgent.this.myGui.setTotal(numberOfTests.getN());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.block();
            }
        }
    }

    class SingleTesterExecutor
    extends SequentialBehaviour {
        private FunctionalityDescriptor func;
        private ListProcessor lpToBeResumed;

        public SingleTesterExecutor(Agent agent, FunctionalityDescriptor functionalityDescriptor, ListProcessor listProcessor) {
            super(agent);
            this.func = null;
            this.func = functionalityDescriptor;
            this.lpToBeResumed = listProcessor;
            this.addSubBehaviour((Behaviour)new OneShotBehaviour(this.myAgent){

                public void action() {
                    Logger logger = Logger.getLogger();
                    if (logger.getLoggerType() == 2) {
                        String string = "";
                        if (TestSuiteAgent.this.firstGroup) {
                            TestSuiteAgent.this.firstGroup = false;
                            string = "Multiple Groups Execution";
                        }
                        Logger.addIndex(string, SingleTesterExecutor.this.func.getName());
                        Logger.addBodyHeading(SingleTesterExecutor.this.func.getName());
                        logger.incBlockCounter();
                    }
                    TestSuiteAgent.this.loadTester(SingleTesterExecutor.this.func);
                }
            });
            this.addSubBehaviour((Behaviour)new Requester(this.myAgent, new Execute(false)){

                public void onStart() {
                    super.onStart();
                    TestSuiteAgent.this.groupTestsResults = new Hashtable();
                }

                public int onEnd() {
                    TestSuiteAgent.this.runAllTestsResults.put(TestSuiteAgent.this.currentFunc.getName(), TestSuiteAgent.this.groupTestsResults);
                    return super.onEnd();
                }
            });
            this.addSubBehaviour((Behaviour)new Requester(this.myAgent, new Exit()){

                public int onEnd() {
                    TestSuiteAgent.waitABit();
                    return 0;
                }
            });
        }

        public int onEnd() {
            Logger.getLogger().log("Test terminated");
            this.lpToBeResumed.resume();
            TestSuiteAgent.this.myGui.updateProgressBar(TestSuiteAgent.this.runAllSuccessful);
            return 0;
        }
    }

    class AllTesterExecutor
    extends ListProcessor {
        public AllTesterExecutor(Agent agent, ArrayList arrayList) {
            super(agent, (List)arrayList);
        }

        public void onStart() {
            TestSuiteAgent.this.myGui.setStatus(6);
            TestSuiteAgent.this.myGui.startProgressBar(this.getNonSkippedCount());
            TestSuiteAgent.this.runAllTestsResults.clear();
            TestSuiteAgent.this.runAllSummaries.clear();
            TestSuiteAgent.this.firstGroup = true;
            TestSuiteAgent.this.runAllSuccessful = true;
            TestSuiteAgent.this.startTime = System.currentTimeMillis();
            TestSuiteAgent.this.timer.start();
        }

        private int getNonSkippedCount() {
            int n = 0;
            for (FunctionalityDescriptor functionalityDescriptor : this.items) {
                if (functionalityDescriptor.getSkip()) continue;
                ++n;
            }
            return n;
        }

        protected void processItem(Object object, int n) {
            FunctionalityDescriptor functionalityDescriptor = (FunctionalityDescriptor)object;
            if (!functionalityDescriptor.getSkip()) {
                this.myAgent.addBehaviour((Behaviour)new SingleTesterExecutor(this.myAgent, functionalityDescriptor, this));
                this.pause();
                TestSuiteAgent.this.myGui.resetAll(false);
            }
        }

        public int onEnd() {
            Object object;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            Logger logger = Logger.getLogger();
            logger.log(" ");
            logger.log(" ");
            logger.log("************ FINAL REPORT ****************");
            logger.log(" ");
            for (int i = 0; i < this.items.size(); ++i) {
                object = (FunctionalityDescriptor)this.items.get(i);
                ExecResult execResult = (ExecResult)TestSuiteAgent.this.runAllSummaries.get(object);
                if (((FunctionalityDescriptor)object).getSkip()) continue;
                logger.log("Functionality:  " + ((FunctionalityDescriptor)object).getName());
                if (execResult != null) {
                    n += execResult.getPassed();
                    n2 += execResult.getSkipped();
                    n3 += execResult.getFailed();
                    logger.log("Passed:  " + execResult.getPassed());
                    logger.log("Failed:  " + execResult.getFailed());
                    logger.log("Skipped: " + execResult.getSkipped());
                } else {
                    logger.log("No result available");
                }
                logger.log("-----------------------------------------------");
            }
            TestSuiteAgent.this.timer.stop();
            TestSuiteAgent.this.updateElapsedTime();
            TestSuiteAgent.this.myGui.getTestsTree().showTestsHierarchy(TestSuiteAgent.this.xmlFileName, null, true);
            TestSuiteAgent.this.myGui.setStatus(0);
            logger.log("******************************************");
            String string = "Final Report: " + n + " passed, " + n2 + " skipped, " + n3 + " failed of " + (n + n2 + n3) + " executed";
            logger.log(string);
            logger.log("******************************************");
            TestSuiteAgent.this.myGui.getStatusLabel().setText(string);
            object = n3 > 0 ? "failed_buttons.gif" : (n2 > 0 ? "skipped_buttons.gif" : "passed_buttons.gif");
            TestSuiteAgent.this.myGui.getStatusLabel().setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/test/common/testSuite/gui/images/" + (String)object)));
            logger.addBodyCloser();
            if (System.getProperty("test.common.testSuite.TestSuiteAgent.runAutomatic") != null) {
                try {
                    TestUtility.requestAMSAction(this.myAgent, TestSuiteAgent.this.getAMS(), (AgentAction)new ShutdownPlatform());
                    TestSuiteAgent.this.onGuiEvent(new GuiEvent((Object)this, 7));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(0);
                }
            }
            return 0;
        }
    }
}

