/*
 * Decompiled with CFR 0.152.
 */
package test.common.testSuite.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class CounterPanel
extends JPanel
implements Serializable {
    private JTextField fNumberOfFailed;
    private JTextField fNumberOfPassed;
    private JTextField fNumberOfRuns;
    private JTextField fTimeElapsed;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private int fTotalRuns = 0;
    private int testsRuns = 0;
    private int testsPassed = 0;
    private int testsFailed = 0;

    public CounterPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.fNumberOfRuns = new JTextField();
        this.jLabel2 = new JLabel();
        this.fNumberOfPassed = new JTextField();
        this.jLabel3 = new JLabel();
        this.fNumberOfFailed = new JTextField();
        this.jLabel4 = new JLabel();
        this.fTimeElapsed = new JTextField();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.setMaximumSize(this.fNumberOfRuns.getPreferredSize());
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText("Executed:  ");
        this.jLabel1.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.fNumberOfRuns.setColumns(5);
        this.fNumberOfRuns.setEditable(false);
        this.fNumberOfRuns.setFont(new Font("Dialog", 1, 12));
        this.fNumberOfRuns.setHorizontalAlignment(2);
        this.fNumberOfRuns.setText("0 / 0");
        this.fNumberOfRuns.setToolTipText("Number of tests already runned");
        this.fNumberOfRuns.setBorder(null);
        this.fNumberOfRuns.setMaximumSize(this.fNumberOfRuns.getPreferredSize());
        this.fNumberOfRuns.setMinimumSize(this.fNumberOfRuns.getPreferredSize());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.fNumberOfRuns, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(2);
        this.jLabel2.setText("Passed:  ");
        this.jLabel2.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.fNumberOfPassed.setColumns(4);
        this.fNumberOfPassed.setEditable(false);
        this.fNumberOfPassed.setFont(new Font("Dialog", 1, 12));
        this.fNumberOfPassed.setHorizontalAlignment(2);
        this.fNumberOfPassed.setText("0");
        this.fNumberOfPassed.setToolTipText("Number of tests succeded");
        this.fNumberOfPassed.setBorder(null);
        this.fNumberOfPassed.setMaximumSize(this.fNumberOfPassed.getPreferredSize());
        this.fNumberOfPassed.setMinimumSize(this.fNumberOfPassed.getPreferredSize());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.fNumberOfPassed, gridBagConstraints);
        this.jLabel3.setText("Failed:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.fNumberOfFailed.setColumns(4);
        this.fNumberOfFailed.setEditable(false);
        this.fNumberOfFailed.setFont(new Font("Dialog", 1, 12));
        this.fNumberOfFailed.setHorizontalAlignment(2);
        this.fNumberOfFailed.setText("0");
        this.fNumberOfFailed.setToolTipText("Number of tests failed");
        this.fNumberOfFailed.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.fNumberOfFailed, gridBagConstraints);
        this.jLabel4.setText("Elapsed time:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.fTimeElapsed.setColumns(9);
        this.fTimeElapsed.setEditable(false);
        this.fTimeElapsed.setFont(new Font("Dialog", 1, 12));
        this.fTimeElapsed.setHorizontalAlignment(2);
        this.fTimeElapsed.setText("0,0 seconds");
        this.fTimeElapsed.setToolTipText("Tests time elapsed");
        this.fTimeElapsed.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.fTimeElapsed, gridBagConstraints);
    }

    public int getFTotalRuns() {
        return this.fTotalRuns;
    }

    public void setFTotalRuns(int n) {
        this.fTotalRuns = n;
        this.setRunsValue();
    }

    public void setRunsCount(int n) {
        this.testsRuns = n;
        this.setRunsValue();
    }

    public int getRunsCount() {
        return this.testsRuns;
    }

    public void setPassedCount(int n) {
        this.testsPassed = n;
        this.setLabelValue(this.fNumberOfPassed, this.testsPassed);
    }

    public int getPassedCount() {
        return this.testsPassed;
    }

    public void setFailedCount(int n) {
        this.testsFailed = n;
        this.setLabelValue(this.fNumberOfFailed, this.testsFailed);
    }

    public int getFailedCount() {
        return this.testsFailed;
    }

    public void reset(boolean bl, boolean bl2) {
        if (!bl) {
            this.fTotalRuns = 0;
        }
        this.testsRuns = 0;
        this.testsPassed = 0;
        this.testsFailed = 0;
        this.updateGUI(bl, bl2);
    }

    public void setRunsValue() {
        this.fNumberOfRuns.setText(Integer.toString(this.testsRuns) + " / " + this.fTotalRuns);
    }

    public void setElapsedTime(long l, boolean bl) {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        String string = "";
        n2 = (int)((double)l / 1000.0);
        d = (double)l % 1000.0;
        if (n2 > 59) {
            n = (int)((double)n2 / 60.0);
            n2 -= 60 * n;
        }
        string = n == 0 ? NumberFormat.getInstance().format(n2) : (n2 < 10 ? NumberFormat.getInstance().format(n) + " : " + "0" + NumberFormat.getInstance().format(n2) : NumberFormat.getInstance().format(n) + " : " + NumberFormat.getInstance().format(n2));
        if (!bl) {
            string = string + "." + NumberFormat.getInstance().format(d);
        }
        this.fTimeElapsed.setText(string + " secs");
    }

    private void setLabelValue(JTextField jTextField, int n) {
        jTextField.setText(Integer.toString(n));
    }

    private void updateGUI(boolean bl, boolean bl2) {
        this.fNumberOfRuns.setText("0 / " + Integer.toString(this.fTotalRuns));
        this.fNumberOfPassed.setText("0");
        this.fNumberOfFailed.setText("0");
        if (!bl2) {
            this.fTimeElapsed.setText("0,0 seconds");
        }
    }

    private void updateGUI() {
        this.fNumberOfRuns.setText("0 / " + Integer.toString(this.fTotalRuns));
        this.fNumberOfPassed.setText("0");
        this.fNumberOfFailed.setText("0");
        this.fTimeElapsed.setText("0,0 seconds");
    }
}

