/*
 * Decompiled with CFR 0.152.
 */
package test.common.testSuite.gui;

import jade.util.leap.List;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import test.common.ArgumentSpec;

public class InsertArgumentsDlg
extends JDialog {
    private List argSpecs;
    private JButton okB;
    private JLabel[] labels;
    private JTextField[] values;
    private JTextField[] defaults;

    private InsertArgumentsDlg(Frame frame, List list) {
        super(frame);
        this.setModal(true);
        this.setTitle("Test group arguments");
        this.setResizable(false);
        this.argSpecs = list;
        final int n = this.argSpecs.size();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(n + 1, 3));
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel("Value"));
        jPanel.add(new JLabel("Default"));
        this.labels = new JLabel[n];
        this.values = new JTextField[n];
        this.defaults = new JTextField[n];
        for (int i = 0; i < n; ++i) {
            ArgumentSpec argumentSpec = (ArgumentSpec)this.argSpecs.get(i);
            this.labels[i] = new JLabel(argumentSpec.getLabel());
            this.values[i] = new JTextField();
            this.values[i].setText(argumentSpec.getValue());
            this.defaults[i] = new JTextField();
            this.defaults[i].setText(argumentSpec.getDefaultValue());
            this.defaults[i].setEnabled(false);
            jPanel.add(this.labels[i]);
            jPanel.add(this.values[i]);
            jPanel.add(this.defaults[i]);
        }
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel = new JPanel();
        this.okB = new JButton("OK");
        this.okB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < n; ++i) {
                    ArgumentSpec argumentSpec = (ArgumentSpec)InsertArgumentsDlg.this.argSpecs.get(i);
                    String string = InsertArgumentsDlg.this.values[i].getText();
                    if (string != null && !string.equals("")) {
                        argumentSpec.setValue(string);
                        continue;
                    }
                    if (argumentSpec.isMandatory()) {
                        return;
                    }
                    argumentSpec.setValue(argumentSpec.getDefaultValue());
                }
                InsertArgumentsDlg.this.dispose();
            }
        });
        jPanel.add(this.okB);
        this.getContentPane().add((Component)jPanel, "South");
    }

    public static void insertValues(List list) {
        InsertArgumentsDlg insertArgumentsDlg = new InsertArgumentsDlg(null, list);
        insertArgumentsDlg.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)dimension.getWidth() / 2;
        int n2 = (int)dimension.getHeight() / 2;
        insertArgumentsDlg.setLocation(n - insertArgumentsDlg.getWidth() / 2, n2 - insertArgumentsDlg.getHeight() / 2);
        insertArgumentsDlg.show();
    }
}

