/*
 * Decompiled with CFR 0.152.
 */
package test.common.testSuite.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressBar
extends JPanel
implements Serializable {
    private JProgressBar jProgressBar;
    private int currentValue;
    private Color statusColor;
    private boolean fError = false;

    public ProgressBar() {
        this.initComponents();
        this.jProgressBar.setStringPainted(true);
    }

    private void initComponents() {
        this.jProgressBar = new JProgressBar();
        this.setLayout(new GridBagLayout());
        this.jProgressBar.setForeground(this.getStatusColor());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jProgressBar, gridBagConstraints);
    }

    public Color getStatusColor() {
        return this.statusColor;
    }

    public void setStatusColor(Color color) {
        this.statusColor = color;
    }

    public void start(int n) {
        this.jProgressBar.setMaximum(n);
        this.reset();
    }

    public void reset() {
        this.currentValue = 0;
        this.fError = false;
        this.statusColor = Color.green;
        this.jProgressBar.setForeground(this.statusColor);
        this.jProgressBar.setValue(0);
    }

    public void step(boolean bl) {
        ++this.currentValue;
        this.update(bl);
    }

    public void setValue(int n, boolean bl) {
        this.currentValue = n;
        this.update(bl);
    }

    private void update(boolean bl) {
        this.jProgressBar.setValue(this.currentValue);
        this.fError = this.fError || !bl;
        this.statusColor = this.fError ? Color.red : Color.green;
        this.jProgressBar.setForeground(this.statusColor);
    }
}

