/*
 * Decompiled with CFR 0.152.
 */
package test.common.testSuite.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import test.common.xml.TestDescriptor;

public class SelectTestsDlg
extends JDialog {
    private JCheckBox[] names;
    private JButton okB;
    private JButton cancelB;

    private SelectTestsDlg(Frame frame, final TestDescriptor[] testDescriptorArray) {
        this.setModal(true);
        this.setTitle("Tests");
        this.setResizable(false);
        int n = testDescriptorArray.length;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(n, 1));
        this.names = new JCheckBox[n];
        for (int i = 0; i < n; ++i) {
            this.names[i] = new JCheckBox(testDescriptorArray[i].getName(), !testDescriptorArray[i].getSkip());
            jPanel.add(this.names[i]);
        }
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel = new JPanel();
        this.okB = new JButton("OK");
        this.okB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                for (int i = 0; i < testDescriptorArray.length; ++i) {
                    if (SelectTestsDlg.this.names[i].isSelected()) {
                        testDescriptorArray[i].setSkip(false);
                        ++n;
                        continue;
                    }
                    testDescriptorArray[i].setSkip(true);
                }
                SelectTestsDlg.this.dispose();
            }
        });
        jPanel.add(this.okB);
        this.cancelB = new JButton("Cancel");
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectTestsDlg.this.dispose();
            }
        });
        jPanel.add(this.cancelB);
        this.okB.setPreferredSize(this.cancelB.getPreferredSize());
        this.getContentPane().add((Component)jPanel, "South");
    }

    public static void selectTests(TestDescriptor[] testDescriptorArray) {
        SelectTestsDlg selectTestsDlg = new SelectTestsDlg(null, testDescriptorArray);
        selectTestsDlg.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)dimension.getWidth() / 2;
        int n2 = (int)dimension.getHeight() / 2;
        selectTestsDlg.setLocation(n - selectTestsDlg.getWidth() / 2, n2 - selectTestsDlg.getHeight() / 2);
        selectTestsDlg.show();
    }
}

