/*
 * Decompiled with CFR 0.152.
 */
package test.common.testSuite.gui;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import test.common.testSuite.gui.TestSuiteGui;
import test.common.testerAgentControlOntology.TestResult;

public class TestResultCellRenderer
extends DefaultTreeCellRenderer {
    private TestIconManager theIconManager = TestIconManager.theIconManager;
    private TestSuiteGui myGui;

    TestResultCellRenderer(TestSuiteGui testSuiteGui) {
        this.myGui = testSuiteGui;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        TestResult testResult;
        TreePath treePath;
        Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        String string = object.toString();
        String string2 = null;
        if (bl3) {
            this.setIcon(this.theIconManager.defaultIcon);
        }
        if (string.endsWith("SKIPPED")) {
            this.setIcon(this.theIconManager.skippedIcon);
        }
        if ((treePath = jTree.getPathForRow(n)) != null && (testResult = this.myGui.getTestResult(treePath)) != null) {
            switch (testResult.getResult()) {
                case 1: {
                    this.setIcon(this.theIconManager.successIcon);
                    string2 = " - Passed";
                    break;
                }
                case 0: {
                    this.setIcon(this.theIconManager.errorIcon);
                    string2 = " - Failed";
                    break;
                }
                case 2: {
                    this.setIcon(this.theIconManager.skippedIcon);
                    string2 = " - Skipped";
                }
            }
        }
        if (component instanceof JComponent && string2 != null) {
            ((JComponent)component).setToolTipText(string2);
        }
        return component;
    }

    private static class TestIconManager {
        static TestIconManager theIconManager = new TestIconManager();
        private Icon errorIcon = new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/failed.png"));
        private Icon skippedIcon = new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/skipped.png"));
        private Icon successIcon = new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/success.png"));
        private Icon defaultIcon = new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/default.png"));

        private TestIconManager() {
        }
    }
}

