/*
 * Decompiled with CFR 0.152.
 */
package test.common.testSuite.gui;

import jade.gui.GuiEvent;
import jade.gui.JadeLogoButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import test.common.Logger;
import test.common.TestException;
import test.common.TestUtility;
import test.common.remote.RemoteManager;
import test.common.testSuite.TestSuiteAgent;
import test.common.testSuite.gui.CounterPanel;
import test.common.testSuite.gui.ExitDialog;
import test.common.testSuite.gui.FailedTestsView;
import test.common.testSuite.gui.FunctionalitySelectionDlg;
import test.common.testSuite.gui.LoggerDialog;
import test.common.testSuite.gui.ProgressBar;
import test.common.testSuite.gui.TSDaemonConnectionConfiguration;
import test.common.testSuite.gui.TSDaemonConnectionDlg;
import test.common.testSuite.gui.TestResultCellRenderer;
import test.common.testerAgentControlOntology.TestResult;
import test.common.xml.FunctionalityDescriptor;
import test.common.xml.TestsTree;

public class TestSuiteGui
extends JFrame {
    public static final int IDLE_STATE = 0;
    public static final int READY_STATE = 1;
    public static final int RUNNING_STATE = 2;
    public static final int DEBUGGING_STATE = 3;
    public static final int STEPPING_STATE = 4;
    public static final int CONFIGURING_STATE = 5;
    public static final int RUNALL_STATE = 6;
    private static final int HISTORY_MAX_LENGTH = 4;
    private int status;
    private TestSuiteAgent myAgent;
    private String xmlFileName;
    private TSDaemonConnectionConfiguration daemonConf = new TSDaemonConnectionConfiguration();
    private int totalRuns = 0;
    private int totalPassed = 0;
    private int totalFailed = 0;
    private JToolBar JToolBar;
    private JButton configB;
    private JButton connectB;
    private CounterPanel counterPanel;
    private JButton debugB;
    private JButton exitB;
    private FailedTestsView failedTestsView;
    private JComboBox historyCB;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator;
    private JSplitPane jSplitPane;
    private JLabel jStatusLabel;
    private JButton loggerB;
    private JButton openB;
    private ProgressBar progressBar;
    private JPanel rootPanel;
    private JButton runAllB;
    private JButton runB;
    private JButton selectB;
    private JButton stepB;
    private TestsTree testsTree;
    private JScrollPane testsTreeView;

    public TestSuiteGui(TestSuiteAgent testSuiteAgent, String string) {
        this.myAgent = testSuiteAgent;
        this.xmlFileName = string;
        this.initComponents();
        this.jStatusLabel.setText("Current logger type: " + Logger.getLoggerStringType() + ", click on Logger button to change it");
    }

    private void initComponents() {
        this.rootPanel = new JPanel();
        this.JToolBar = new JToolBar();
        this.exitB = new JButton();
        this.connectB = new JButton();
        this.openB = new JButton();
        this.configB = new JButton();
        this.selectB = new JButton();
        this.runB = new JButton();
        this.runAllB = new JButton();
        this.debugB = new JButton();
        this.stepB = new JButton();
        this.loggerB = new JButton();
        this.jLabel1 = new JLabel();
        this.historyCB = new JComboBox();
        try {
            this.loadHistory();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.jLabel2 = new JLabel();
        this.jSeparator = new JSeparator();
        this.progressBar = new ProgressBar();
        this.jSplitPane = new JSplitPane();
        this.failedTestsView = new FailedTestsView();
        this.testsTree = new TestsTree();
        this.testsTree.setModel(null);
        this.testsTree.setCellRenderer(new TestResultCellRenderer(this));
        this.testsTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null) {
                    TestSuiteGui.this.failedTestsView.clear();
                    TestResult testResult = TestSuiteGui.this.getTestResult(treePath);
                    if (testResult != null && testResult.getErrorMsg() != null) {
                        TestSuiteGui.this.failedTestsView.print(testResult.getErrorMsg());
                    }
                }
            }
        });
        this.testsTreeView = new JScrollPane(this.testsTree);
        this.jStatusLabel = new JLabel();
        this.counterPanel = new CounterPanel();
        this.setTitle("JADE Test Suite");
        this.setMaximizedBounds(new Rectangle(0, 0, 589, 516));
        this.setName("rootFrame");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TestSuiteGui.this.exit();
            }
        });
        this.rootPanel.setLayout(new GridBagLayout());
        this.rootPanel.setMinimumSize(new Dimension(484, 190));
        this.JToolBar.setFloatable(false);
        this.exitB.setIcon(new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/exit.png")));
        this.exitB.setMnemonic('X');
        this.exitB.setText("Exit");
        this.exitB.setToolTipText("Exit the JADE Test Suite");
        this.exitB.setHorizontalTextPosition(0);
        this.exitB.setIconTextGap(0);
        this.exitB.setMaximumSize(new Dimension(64, 64));
        this.exitB.setMinimumSize(new Dimension(64, 64));
        this.exitB.setPreferredSize(new Dimension(64, 64));
        this.exitB.setVerticalTextPosition(3);
        this.exitB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestSuiteGui.this.exitBActionPerformed(actionEvent);
            }
        });
        this.JToolBar.add(this.exitB);
        this.connectB.setIcon(new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/connect_to_network.png")));
        this.connectB.setMnemonic('C');
        this.connectB.setText("Connect");
        this.connectB.setToolTipText("Use the Test Suite Daemon to launch other JADE instances remotely");
        this.connectB.setHorizontalTextPosition(0);
        this.connectB.setIconTextGap(0);
        this.connectB.setMaximumSize(new Dimension(64, 64));
        this.connectB.setMinimumSize(new Dimension(64, 64));
        this.connectB.setPreferredSize(new Dimension(64, 64));
        this.connectB.setVerticalTextPosition(3);
        this.connectB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestSuiteGui.this.connectBActionPerformed(actionEvent);
            }
        });
        this.JToolBar.add(this.connectB);
        this.openB.setIcon(new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/fileopen.png")));
        this.openB.setMnemonic('O');
        this.openB.setText("Open");
        this.openB.setToolTipText("Load a functionality test group");
        this.openB.setHorizontalTextPosition(0);
        this.openB.setIconTextGap(0);
        this.openB.setMaximumSize(new Dimension(64, 64));
        this.openB.setMinimumSize(new Dimension(64, 64));
        this.openB.setPreferredSize(new Dimension(64, 64));
        this.openB.setVerticalTextPosition(3);
        this.openB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestSuiteGui.this.openBActionPerformed(actionEvent);
            }
        });
        this.JToolBar.add(this.openB);
        this.configB.setIcon(new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/SuSEconf.png")));
        this.configB.setMnemonic('G');
        this.configB.setText("Config");
        this.configB.setToolTipText("Set arguments for the current test group");
        this.configB.setHorizontalTextPosition(0);
        this.configB.setIconTextGap(0);
        this.configB.setMaximumSize(new Dimension(64, 64));
        this.configB.setMinimumSize(new Dimension(64, 64));
        this.configB.setPreferredSize(new Dimension(64, 64));
        this.configB.setVerticalTextPosition(3);
        this.configB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestSuiteGui.this.configBActionPerformed(actionEvent);
            }
        });
        this.JToolBar.add(this.configB);
        this.selectB.setIcon(new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/button_ok.png")));
        this.selectB.setText("Select");
        this.selectB.setToolTipText("Select the tests to execute within the loaded group");
        this.selectB.setHorizontalTextPosition(0);
        this.selectB.setIconTextGap(0);
        this.selectB.setMaximumSize(new Dimension(64, 64));
        this.selectB.setMinimumSize(new Dimension(64, 64));
        this.selectB.setPreferredSize(new Dimension(64, 64));
        this.selectB.setVerticalTextPosition(3);
        this.selectB.setEnabled(false);
        this.selectB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestSuiteGui.this.selectBActionPerformed(actionEvent);
            }
        });
        this.JToolBar.add(this.selectB);
        this.runB.setIcon(new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/misc.png")));
        this.runB.setMnemonic('R');
        this.runB.setText("Run");
        this.runB.setToolTipText("Run the current functionality test group");
        this.runB.setHorizontalTextPosition(0);
        this.runB.setIconTextGap(0);
        this.runB.setMaximumSize(new Dimension(64, 64));
        this.runB.setMinimumSize(new Dimension(64, 64));
        this.runB.setPreferredSize(new Dimension(64, 64));
        this.runB.setVerticalTextPosition(3);
        this.runB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestSuiteGui.this.runBActionPerformed(actionEvent);
            }
        });
        this.JToolBar.add(this.runB);
        this.runAllB.setIcon(new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/kbackgammon_engine.png")));
        this.runAllB.setMnemonic('A');
        this.runAllB.setText("Run All");
        this.runAllB.setToolTipText("Run all tests");
        this.runAllB.setHorizontalTextPosition(0);
        this.runAllB.setIconTextGap(0);
        this.runAllB.setMaximumSize(new Dimension(64, 64));
        this.runAllB.setMinimumSize(new Dimension(64, 64));
        this.runAllB.setPreferredSize(new Dimension(64, 64));
        this.runAllB.setVerticalTextPosition(3);
        this.runAllB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestSuiteGui.this.runAllBActionPerformed(actionEvent);
            }
        });
        this.JToolBar.add(this.runAllB);
        this.debugB.setIcon(new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/search.png")));
        this.debugB.setMnemonic('D');
        this.debugB.setText("Debug");
        this.debugB.setToolTipText("Debug the current functionality test group");
        this.debugB.setHorizontalTextPosition(0);
        this.debugB.setIconTextGap(0);
        this.debugB.setMaximumSize(new Dimension(64, 64));
        this.debugB.setMinimumSize(new Dimension(64, 64));
        this.debugB.setPreferredSize(new Dimension(64, 64));
        this.debugB.setVerticalTextPosition(3);
        this.debugB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestSuiteGui.this.debugBActionPerformed(actionEvent);
            }
        });
        this.JToolBar.add(this.debugB);
        this.stepB.setIcon(new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/forward.png")));
        this.stepB.setMnemonic('N');
        this.stepB.setText("Next");
        this.stepB.setToolTipText("Execute next test");
        this.stepB.setHorizontalTextPosition(0);
        this.stepB.setIconTextGap(0);
        this.stepB.setMaximumSize(new Dimension(64, 64));
        this.stepB.setMinimumSize(new Dimension(64, 64));
        this.stepB.setPreferredSize(new Dimension(64, 64));
        this.stepB.setVerticalTextPosition(3);
        this.stepB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestSuiteGui.this.stepBActionPerformed(actionEvent);
            }
        });
        this.JToolBar.add(this.stepB);
        this.loggerB.setIcon(new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/kexi.png")));
        this.loggerB.setText("Log");
        this.loggerB.setToolTipText("Select the log type");
        this.loggerB.setHorizontalTextPosition(0);
        this.loggerB.setIconTextGap(0);
        this.loggerB.setMaximumSize(new Dimension(64, 64));
        this.loggerB.setMinimumSize(new Dimension(64, 64));
        this.loggerB.setPreferredSize(new Dimension(64, 64));
        this.loggerB.setVerticalTextPosition(3);
        this.loggerB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestSuiteGui.this.loggerBActionPerformed(actionEvent);
            }
        });
        this.JToolBar.add(this.loggerB);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 3, 4);
        this.rootPanel.add((Component)this.JToolBar, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Current functionality: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(21, 4, 21, 4);
        this.rootPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.historyCB.setMaximumRowCount(60);
        this.historyCB.setMinimumSize(new Dimension(200, 25));
        this.historyCB.setPreferredSize(new Dimension(200, 25));
        this.historyCB.setLightWeightPopupEnabled(false);
        this.historyCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestSuiteGui.this.historyActionPerformed(actionEvent);
            }
        });
        this.historyCB.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                TestSuiteGui.this.historyKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(17, 2, 16, 4);
        this.rootPanel.add((Component)this.historyCB, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Progress: ");
        this.jLabel2.setMaximumSize(null);
        this.jLabel2.setMinimumSize(null);
        this.jLabel2.setPreferredSize(null);
        this.jLabel2.setHorizontalTextPosition(4);
        this.rootPanel.add((Component)this.jLabel2, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.rootPanel.add((Component)this.jSeparator, gridBagConstraints);
        this.progressBar.setLayout(new GridLayout(1, 1));
        this.progressBar.setMinimumSize(new Dimension(200, 20));
        this.progressBar.setPreferredSize(new Dimension(200, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 0, 4);
        this.rootPanel.add((Component)this.progressBar, gridBagConstraints);
        this.jSplitPane.setDividerLocation(200);
        this.jSplitPane.setOrientation(0);
        this.failedTestsView.setLayout(new GridLayout(1, 1));
        this.failedTestsView.setPreferredSize(new Dimension(300, 150));
        this.jSplitPane.setRightComponent(this.failedTestsView);
        this.testsTreeView.setPreferredSize(new Dimension(400, 200));
        this.jSplitPane.setLeftComponent(this.testsTreeView);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rootPanel.add((Component)this.jSplitPane, gridBagConstraints);
        this.jStatusLabel.setFont(new Font("Dialog", 0, 12));
        this.jStatusLabel.setHorizontalAlignment(2);
        this.jStatusLabel.setIcon(new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/idle_buttons.gif")));
        this.jStatusLabel.setIconTextGap(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 3, 0);
        this.rootPanel.add((Component)this.jStatusLabel, gridBagConstraints);
        this.setStatus(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 4, 0, 4);
        this.rootPanel.add((Component)this.counterPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.rootPanel, "Center");
        this.JToolBar.addSeparator();
        JadeLogoButton jadeLogoButton = new JadeLogoButton();
        jadeLogoButton.setText("Web");
        jadeLogoButton.setToolTipText("Browse the JADE web site");
        jadeLogoButton.setHorizontalTextPosition(0);
        jadeLogoButton.setMaximumSize(new Dimension(64, 64));
        jadeLogoButton.setMinimumSize(new Dimension(64, 64));
        jadeLogoButton.setPreferredSize(new Dimension(64, 64));
        jadeLogoButton.setVerticalTextPosition(3);
        this.JToolBar.add((Component)jadeLogoButton);
        this.setIconImage(this.getToolkit().getImage(jadeLogoButton.getClass().getResource("/jade/gui/images/logosmall.jpg")));
        this.pack();
    }

    private void openBActionPerformed(ActionEvent actionEvent) {
        this.open();
    }

    private void configBActionPerformed(ActionEvent actionEvent) {
        this.config();
    }

    private void selectBActionPerformed(ActionEvent actionEvent) {
        this.select();
    }

    private void runBActionPerformed(ActionEvent actionEvent) {
        this.run();
    }

    private void stepBActionPerformed(ActionEvent actionEvent) {
        this.step();
    }

    private void debugBActionPerformed(ActionEvent actionEvent) {
        this.debug();
    }

    private void historyActionPerformed(ActionEvent actionEvent) {
        if (this.status != 6) {
            this.resetAll(true);
            GuiEvent guiEvent = new GuiEvent((Object)this, 0);
            guiEvent.addParameter(this.historyCB.getSelectedItem());
            this.myAgent.postGuiEvent(guiEvent);
        }
    }

    private void historyKeyTyped(KeyEvent keyEvent) {
        if (this.status == 1 && keyEvent.getKeyChar() == '\n') {
            this.run();
        }
    }

    private void runAllBActionPerformed(ActionEvent actionEvent) {
        this.runAll();
    }

    private void connectBActionPerformed(ActionEvent actionEvent) {
        this.connect();
    }

    private void exitBActionPerformed(ActionEvent actionEvent) {
        this.showExitForm();
    }

    private void loggerBActionPerformed(ActionEvent actionEvent) {
        Logger.getLogger();
        LoggerDialog loggerDialog = new LoggerDialog((Frame)this, Logger.getLoggerType());
        loggerDialog.setLocationRelativeTo(this);
        loggerDialog.show();
        if (loggerDialog.getExitValue() == 1) {
            int n = loggerDialog.getSelectedLoggerType();
            Logger.getLogger();
            if (Logger.getLoggerType() != n) {
                Logger.getLogger();
                Logger.deleteLogger();
                switch (n) {
                    case 1: {
                        Logger.getLogger();
                        Logger.setFileLogger(1);
                        break;
                    }
                    case 0: {
                        Logger.getLogger();
                        Logger.setTextLogger();
                        break;
                    }
                    case 2: {
                        Logger.getLogger();
                        Logger.setFileLogger(2);
                    }
                }
            }
            StringBuilder stringBuilder = new StringBuilder().append("Logger type is now set to: ");
            Logger.getLogger();
            this.jStatusLabel.setText(stringBuilder.append(Logger.getLoggerStringType()).toString());
        }
    }

    void exit() {
        GuiEvent guiEvent = new GuiEvent((Object)this, 7);
        this.myAgent.postGuiEvent(guiEvent);
        try {
            this.saveHistory();
        }
        catch (IOException iOException) {
            Logger.getLogger().log("Couldn't save test run history");
        }
    }

    void connect() {
        TSDaemonConnectionDlg.configure(this.daemonConf);
        if (this.daemonConf.getChanged()) {
            if (this.daemonConf.getConnect()) {
                try {
                    RemoteManager remoteManager = TestUtility.createRemoteManager(this.daemonConf.getHostName(), 7777, "TSDaemon");
                    TestUtility.setDefaultRemoteManager(remoteManager);
                }
                catch (TestException testException) {
                    Logger.getLogger().log("Error connecting to the Test Suite Daemon. " + testException.getMessage());
                }
            } else {
                TestUtility.setDefaultRemoteManager(null);
            }
        }
    }

    void open() {
        FunctionalityDescriptor functionalityDescriptor = FunctionalitySelectionDlg.showSelectionDlg(this, this.xmlFileName);
        if (functionalityDescriptor != null) {
            this.addToHistory(functionalityDescriptor);
        }
    }

    void config() {
        GuiEvent guiEvent = new GuiEvent((Object)this, 4);
        this.setStatus(5);
        this.myAgent.postGuiEvent(guiEvent);
    }

    void run() {
        GuiEvent guiEvent = null;
        if (this.status == 1) {
            this.totalRuns = 0;
            this.totalPassed = 0;
            this.totalFailed = 0;
            this.resetAll(true);
            this.jStatusLabel.setText("Running test group...");
            guiEvent = new GuiEvent((Object)this, 2);
        } else if (this.status == 3) {
            this.jStatusLabel.setText("Running remaining tests of the group...");
            guiEvent = new GuiEvent((Object)this, 6);
        }
        this.jStatusLabel.setIcon(new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/progress_buttons.gif")));
        this.setStatus(2);
        this.myAgent.postGuiEvent(guiEvent);
    }

    void runAll() {
        this.jStatusLabel.setText("Running all tests...");
        this.jStatusLabel.setIcon(new ImageIcon(this.getClass().getResource("/test/common/testSuite/gui/images/progress_buttons.gif")));
        this.counterPanel.reset(false, true);
        this.totalRuns = 0;
        this.totalPassed = 0;
        this.totalFailed = 0;
        GuiEvent guiEvent = new GuiEvent((Object)this, 9);
        this.myAgent.postGuiEvent(guiEvent);
    }

    void debug() {
        this.resetAll(true);
        GuiEvent guiEvent = new GuiEvent((Object)this, 3);
        this.setStatus(3);
        this.myAgent.postGuiEvent(guiEvent);
    }

    void step() {
        GuiEvent guiEvent = new GuiEvent((Object)this, 5);
        this.setStatus(4);
        this.myAgent.postGuiEvent(guiEvent);
    }

    void select() {
        GuiEvent guiEvent = new GuiEvent((Object)this, 8);
        this.setStatus(5);
        this.myAgent.postGuiEvent(guiEvent);
    }

    public TestResult getTestResult(TreePath treePath) {
        String string = treePath.getLastPathComponent().toString();
        if (string.endsWith(" SKIPPED")) {
            string = string.substring(0, string.length() - 8);
        }
        TestResult testResult = null;
        if (treePath.getPathComponent(0).toString().equals("JADE Test Suite")) {
            if (treePath.getPathCount() >= 3) {
                String string2 = treePath.getPathComponent(2).toString();
                testResult = this.myAgent.getTestResult(string, string2);
            }
        } else {
            testResult = this.myAgent.getTestResult(string, null);
        }
        return testResult;
    }

    public void showCorrect() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)dimension.getWidth() / 2;
        int n2 = (int)dimension.getHeight() / 2;
        this.setLocation(n - this.getWidth() / 2, n2 - this.getHeight() / 2);
        this.show();
    }

    public void setStatus(int n) {
        this.status = n;
        this.updateEnabled();
    }

    public int getStatus() {
        return this.status;
    }

    private void updateEnabled() {
        this.historyCB.setEnabled(this.status == 0 || this.status == 1);
        this.openB.setEnabled(this.status == 0 || this.status == 1);
        this.loggerB.setEnabled(this.status == 0 || this.status == 1);
        this.runB.setEnabled(this.status == 1 || this.status == 3);
        this.runAllB.setEnabled(this.status == 0 || this.status == 1);
        this.debugB.setEnabled(this.status == 1);
        this.stepB.setEnabled(this.status == 3);
        this.configB.setEnabled(this.status == 1);
        this.selectB.setEnabled(this.status == 1);
    }

    public void addToHistory(Object object) {
        for (int i = 0; i < this.historyCB.getItemCount(); ++i) {
            if (!object.equals(this.historyCB.getItemAt(i))) continue;
            if (i != 0) {
                this.historyCB.removeItemAt(i);
                continue;
            }
            return;
        }
        System.out.println("El " + object + " inserted");
        this.historyCB.insertItemAt(object, 0);
        this.historyCB.setSelectedIndex(0);
        this.resizeHistory();
    }

    private void resizeHistory() {
        if (this.historyCB.getItemCount() > 4) {
            this.historyCB.removeItemAt(4);
        }
    }

    private void loadHistory() throws IOException {
    }

    private void saveHistory() throws IOException {
    }

    private File getSettingsFile() {
        String string = System.getProperty("user.home");
        return new File(string, ".testsession");
    }

    public void setElapsedTime(final long l) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestSuiteGui.this.counterPanel.setElapsedTime(l, TestSuiteGui.this.getStatus() == 6);
            }
        });
    }

    public void startProgressBar(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestSuiteGui.this.progressBar.start(n);
            }
        });
    }

    public void updateProgressBar(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestSuiteGui.this.progressBar.step(bl);
            }
        });
    }

    public void resetAll(final boolean bl) {
        this.totalRuns = 0;
        this.totalPassed = 0;
        this.totalFailed = 0;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl2 = TestSuiteGui.this.getStatus() == 6;
                TestSuiteGui.this.counterPanel.reset(bl, bl2);
                if (!bl2) {
                    TestSuiteGui.this.progressBar.reset();
                }
            }
        });
    }

    public void setTotal(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestSuiteGui.this.counterPanel.setFTotalRuns(n);
                if (TestSuiteGui.this.getStatus() != 6) {
                    TestSuiteGui.this.startProgressBar(n);
                }
            }
        });
    }

    public void showPassed(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestSuiteGui.this.counterPanel.setPassedCount(++TestSuiteGui.this.totalPassed);
                TestSuiteGui.this.counterPanel.setRunsCount(++TestSuiteGui.this.totalRuns);
                TestSuiteGui.this.testsTree.fireTestChanged(string, true);
                if (TestSuiteGui.this.status != 6) {
                    TestSuiteGui.this.updateProgressBar(true);
                }
            }
        });
    }

    public void showFailed(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestSuiteGui.this.counterPanel.setFailedCount(++TestSuiteGui.this.totalFailed);
                TestSuiteGui.this.counterPanel.setRunsCount(++TestSuiteGui.this.totalRuns);
                TestSuiteGui.this.testsTree.fireTestChanged(string, true);
                if (TestSuiteGui.this.status != 6) {
                    TestSuiteGui.this.updateProgressBar(false);
                }
            }
        });
    }

    public void showSkipped(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestSuiteGui.this.testsTree.fireTestChanged(string, true);
                if (TestSuiteGui.this.status != 6) {
                    TestSuiteGui.this.updateProgressBar(true);
                }
            }
        });
    }

    private void showExitForm() {
        ExitDialog exitDialog = new ExitDialog(this);
        exitDialog.setLocationRelativeTo(this);
        exitDialog.show();
        switch (exitDialog.getExitValue()) {
            case 0: {
                break;
            }
            case 1: {
                this.exit();
                break;
            }
        }
    }

    public TestsTree getTestsTree() {
        return this.testsTree;
    }

    public void printFailedTestsMessage(String string) {
        this.failedTestsView.print(string);
    }

    public void clearFailedTestsMessage() {
        this.failedTestsView.clear();
    }

    public JLabel getStatusLabel() {
        return this.jStatusLabel;
    }

    public JButton getDebugButton() {
        return this.debugB;
    }

    public JButton getStepButton() {
        return this.stepB;
    }

    public JButton getRunButton() {
        return this.runB;
    }

    public JButton getSelectButton() {
        return this.selectB;
    }
}

