/*
 * Decompiled with CFR 0.152.
 */
package test.common.xml;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import test.common.xml.FunctionalityDescriptor;
import test.common.xml.XMLManager;

public class TestsTree
extends JTree
implements Serializable {
    public static final String DEFAULT_TREE_ROOT_NAME = "JADE Test Suite";
    private static final int ELEMENT_TYPE = 1;
    private static final int ATTR_TYPE = 2;
    private static final int TEXT_TYPE = 3;
    private static final int CDATA_TYPE = 4;
    private static final int PROCINSTR_TYPE = 7;
    private static final int COMMENT_TYPE = 8;
    private static final int DOCUMENT_TYPE = 9;
    private static final int DOCTYPE_TYPE = 10;
    private static final int NOTATION_TYPE = 12;
    private static final String[] typeName = new String[]{"none", "Element", "Attr", "Text", "CDATA", "ProcInstr", "Comment", "Document", "DocType", "Notation"};
    private static String[][] allTreeElementNames = new String[][]{{"Tester", "ClassName", "Description", "TestsListRif", "Test", "TestClassName", "WhatTest", "HowWorkTest", "WhenTestPass", "Argument", "TesterList", "TestsList"}, {"TesterList", "Tester", "TestsListRif", "TestsList", "Test"}};
    private String[] treeElementNames = allTreeElementNames[1];
    private Document document;
    private String rootName = "JADE Test Suite";
    private boolean compress = true;

    public boolean showTestsHierarchy(String string, String string2, boolean bl) {
        this.rootName = string2 != null ? string2 : DEFAULT_TREE_ROOT_NAME;
        this.document = XMLManager.getDocument(string);
        if (this.document != null) {
            this.setModel(new DomToTreeModelAdapter());
            if (bl) {
                this.expandAll();
            }
            return true;
        }
        return false;
    }

    public String getDisplayContent(Object object) {
        return ((AdapterNode)object).content();
    }

    public FunctionalityDescriptor getFunctionality(Object object) {
        Element element = (Element)((AdapterNode)object).domNode;
        return XMLManager.getFunctionalityDescriptor(element);
    }

    public Object getSelectedTest() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null && treePathArray.length == 1) {
            return treePathArray[0].getLastPathComponent();
        }
        return null;
    }

    public void fireTestChanged(final String string, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DomToTreeModelAdapter domToTreeModelAdapter = (DomToTreeModelAdapter)TestsTree.this.getModel();
                Vector vector = new Vector();
                int n = domToTreeModelAdapter.buildPath(string, domToTreeModelAdapter.getRoot(), vector);
                if (n >= 0) {
                    Object[] objectArray = new Object[vector.size()];
                    vector.copyInto(objectArray);
                    TreePath treePath = new TreePath(objectArray);
                    domToTreeModelAdapter.fireTreeNodesChanged(treePath, n);
                    if (bl) {
                        Object[] objectArray2 = new Object[vector.size() + 1];
                        vector.copyInto(objectArray2);
                        objectArray2[vector.size()] = domToTreeModelAdapter.getChild(treePath.getLastPathComponent(), n);
                        TreePath treePath2 = new TreePath(objectArray2);
                        TestsTree.this.scrollPathToVisible(treePath2);
                    }
                }
            }
        });
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void setTreeElementNames(int n) {
        this.treeElementNames = allTreeElementNames[n];
    }

    private boolean treeElement(String string) {
        for (int i = 0; i < this.treeElementNames.length; ++i) {
            if (!string.equals(this.treeElementNames[i])) continue;
            return true;
        }
        return false;
    }

    private class DomToTreeModelAdapter
    implements TreeModel,
    Serializable {
        private Vector listenerList = new Vector();

        private DomToTreeModelAdapter() {
        }

        public Object getRoot() {
            return new AdapterNode(TestsTree.this.document);
        }

        public boolean isLeaf(Object object) {
            AdapterNode adapterNode = (AdapterNode)object;
            Node node = adapterNode.domNode;
            if (node.getNodeName().equalsIgnoreCase("TestsListRif")) {
                Document document = XMLManager.getDocument(node.getFirstChild().getNodeValue());
                if (document == null) {
                    return true;
                }
                NodeList nodeList = document.getElementsByTagName("TestsList");
                adapterNode.domNode = nodeList.item(0);
                return false;
            }
            return adapterNode.childCount() == 0;
        }

        public int getChildCount(Object object) {
            AdapterNode adapterNode = (AdapterNode)object;
            return adapterNode.childCount();
        }

        public Object getChild(Object object, int n) {
            AdapterNode adapterNode = (AdapterNode)object;
            return adapterNode.child(n);
        }

        public int getIndexOfChild(Object object, Object object2) {
            AdapterNode adapterNode = (AdapterNode)object;
            return adapterNode.index((AdapterNode)object2);
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            if (treeModelListener != null && !this.listenerList.contains(treeModelListener)) {
                this.listenerList.addElement(treeModelListener);
            }
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            if (treeModelListener != null) {
                this.listenerList.removeElement(treeModelListener);
            }
        }

        public void fireTreeNodesChanged(TreePath treePath, int n) {
            int[] nArray = new int[]{n};
            Object[] objectArray = new Object[]{this.getChild(treePath.getLastPathComponent(), n)};
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
            Enumeration enumeration = this.listenerList.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeNodesChanged(treeModelEvent);
            }
        }

        public void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
            Enumeration enumeration = this.listenerList.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeNodesInserted(treeModelEvent);
            }
        }

        public void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
            Enumeration enumeration = this.listenerList.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeNodesRemoved(treeModelEvent);
            }
        }

        public void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
            Enumeration enumeration = this.listenerList.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        }

        private int buildPath(String string, Object object, Vector vector) {
            if (string.equals(object.toString())) {
                return 0;
            }
            for (int i = 0; i < this.getChildCount(object); ++i) {
                int n = this.buildPath(string, this.getChild(object, i), vector);
                if (n < 0) continue;
                vector.insertElementAt(object, 0);
                return i;
            }
            return -1;
        }
    }

    private class AdapterNode
    implements Serializable {
        Node domNode;

        private AdapterNode(Node node) {
            this.domNode = node;
        }

        public String toString() {
            String string = typeName[this.domNode.getNodeType()];
            if (this.domNode instanceof Element) {
                Element element = (Element)this.domNode;
                String string2 = element.getTagName();
                if (string2.equalsIgnoreCase("Tester") || string2.equalsIgnoreCase("Test")) {
                    string = element.getAttribute("name");
                    if ("true".equalsIgnoreCase(element.getAttribute("skip"))) {
                        string = string + " SKIPPED";
                    }
                } else {
                    string = string2.equalsIgnoreCase("Argument") ? "Arg: " + element.getAttribute("key") + " = " + element.getAttribute("value") : string2;
                }
            }
            if (string.equals("Notation")) {
                string = TestsTree.this.rootName;
            }
            return string;
        }

        private String content() {
            String string = "";
            if (this.domNode instanceof Element) {
                Element element = (Element)this.domNode;
                String string2 = element.getTagName();
                string = string2.equalsIgnoreCase("Tester") ? XMLManager.getContent(XMLManager.getSubElement(element, "Description")) : (string2.equalsIgnoreCase("Test") ? XMLManager.getContent(XMLManager.getSubElement(element, "WhatTest")) : XMLManager.getContent(element));
            }
            return string;
        }

        private int index(AdapterNode adapterNode) {
            int n = this.childCount();
            for (int i = 0; i < n; ++i) {
                AdapterNode adapterNode2 = this.child(i);
                if (adapterNode.domNode != adapterNode2.domNode) continue;
                return i;
            }
            return -1;
        }

        private AdapterNode child(int n) {
            Node node = this.domNode.getChildNodes().item(n);
            if (TestsTree.this.compress) {
                int n2 = 0;
                for (int i = 0; !(i >= this.domNode.getChildNodes().getLength() || (node = this.domNode.getChildNodes().item(i)).getNodeType() == 1 && TestsTree.this.treeElement(node.getNodeName()) && n2++ == n); ++i) {
                }
            }
            return new AdapterNode(node);
        }

        private int childCount() {
            if (!TestsTree.this.compress) {
                return this.domNode.getChildNodes().getLength();
            }
            int n = 0;
            for (int i = 0; i < this.domNode.getChildNodes().getLength(); ++i) {
                Node node = this.domNode.getChildNodes().item(i);
                if (node.getNodeType() != 1 || !TestsTree.this.treeElement(node.getNodeName())) continue;
                ++n;
            }
            return n;
        }
    }
}

