/*
 * Decompiled with CFR 0.152.
 */
package test.common.xml;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import test.common.xml.FunctionalityDescriptor;
import test.common.xml.TestDescriptor;

public class XMLManager {
    public static final String FUNCTIONALITIES_TAG = "TesterList";
    public static final String TESTS_TAG = "TestsList";
    public static final String FUNC_TAG = "Tester";
    public static final String FUNC_CLASS_TAG = "ClassName";
    public static final String FUNC_DESCRIPTION_TAG = "Description";
    public static final String FUNC_TESTSLIST_TAG = "TestsListRif";
    public static final String TEST_TAG = "Test";
    public static final String TEST_CLASS_TAG = "TestClassName";
    public static final String TEST_WHAT_TAG = "WhatTest";
    public static final String TEST_HOW_TAG = "HowWorkTest";
    public static final String TEST_WHEN_TAG = "WhenTestPass";
    public static final String TEST_ARG_TAG = "Argument";
    public static final String NAME_ATTR = "name";
    public static final String SKIP_ATTR = "skip";
    public static final String KEY_ATTR = "key";
    public static final String VALUE_ATTR = "value";
    private static String[] testSuiteTags = new String[]{"Tester", "ClassName", "Description", "TestsListRif", "Test", "TestClassName", "WhatTest", "HowWorkTest", "WhenTestPass", "Argument", "TesterList", "TestsList"};

    public static boolean isTestSuiteTag(String string) {
        for (int i = 0; i < testSuiteTags.length; ++i) {
            if (!string.equalsIgnoreCase(testSuiteTags[i])) continue;
            return true;
        }
        return false;
    }

    public static FunctionalityDescriptor[] getFunctionalities(String string) {
        ArrayList<FunctionalityDescriptor> arrayList = new ArrayList<FunctionalityDescriptor>();
        Document document = XMLManager.getDocument(string);
        if (document != null) {
            NodeList nodeList = document.getElementsByTagName(FUNC_TAG);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                FunctionalityDescriptor functionalityDescriptor = XMLManager.getFunctionalityDescriptor(element);
                arrayList.add(functionalityDescriptor);
            }
        }
        return arrayList.toArray(new FunctionalityDescriptor[0]);
    }

    public static TestDescriptor[] getTests(String string) {
        ArrayList<TestDescriptor> arrayList = new ArrayList<TestDescriptor>();
        Document document = XMLManager.getDocument(string);
        if (document != null) {
            NodeList nodeList = document.getElementsByTagName(TEST_TAG);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                TestDescriptor testDescriptor = XMLManager.getTestDescriptor(element);
                arrayList.add(testDescriptor);
            }
        }
        return arrayList.toArray(new TestDescriptor[0]);
    }

    public static FunctionalityDescriptor getFunctionalityDescriptor(Element element) {
        FunctionalityDescriptor functionalityDescriptor = new FunctionalityDescriptor();
        functionalityDescriptor.setName(element.getAttribute(NAME_ATTR).trim());
        functionalityDescriptor.setSkip(element.getAttribute(SKIP_ATTR).trim());
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string = element2.getTagName();
            if (string.equals(FUNC_CLASS_TAG)) {
                functionalityDescriptor.setTesterClassName(XMLManager.getContent(element2));
                continue;
            }
            if (string.equals(FUNC_TESTSLIST_TAG)) {
                functionalityDescriptor.setTestsListFile(XMLManager.getContent(element2));
                continue;
            }
            if (!string.equals(FUNC_DESCRIPTION_TAG)) continue;
            functionalityDescriptor.setDescription(XMLManager.getContent(element2));
        }
        return functionalityDescriptor;
    }

    public static TestDescriptor getTestDescriptor(Element element) {
        TestDescriptor testDescriptor = new TestDescriptor();
        testDescriptor.setName(element.getAttribute(NAME_ATTR).trim());
        testDescriptor.setSkip(element.getAttribute(SKIP_ATTR).trim());
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string = element2.getTagName();
            if (string.equals(TEST_CLASS_TAG)) {
                testDescriptor.setTestClass(XMLManager.getContent(element2));
                continue;
            }
            if (string.equals(TEST_WHAT_TAG)) {
                testDescriptor.setWhat(XMLManager.getContent(element2));
                continue;
            }
            if (string.equals(TEST_HOW_TAG)) {
                testDescriptor.setHow(XMLManager.getContent(element2));
                continue;
            }
            if (string.equals(TEST_WHEN_TAG)) {
                testDescriptor.setPassedWhen(XMLManager.getContent(element2));
                continue;
            }
            if (!string.equals(TEST_ARG_TAG)) continue;
            testDescriptor.setArg(element2.getAttribute(KEY_ATTR).trim(), element2.getAttribute(VALUE_ATTR).trim());
        }
        return testDescriptor;
    }

    public static String getContent(Element element) {
        String string = "";
        NodeList nodeList = element.getChildNodes();
        block5: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short s = node.getNodeType();
            switch (s) {
                case 1: {
                    String string2 = node.getNodeName();
                    if (XMLManager.isTestSuiteTag(string2)) continue block5;
                    string = string + "<" + string2 + ">";
                    string = string + XMLManager.getContent((Element)node);
                    string = string + "</" + string2 + ">";
                    continue block5;
                }
                case 3: {
                    string = string + node.getNodeValue();
                    continue block5;
                }
                case 4: {
                    StringBuffer stringBuffer = new StringBuffer(node.getNodeValue());
                    for (int j = 0; j < stringBuffer.length(); ++j) {
                        if (stringBuffer.charAt(j) == '<') {
                            stringBuffer.setCharAt(j, '&');
                            stringBuffer.insert(j + 1, "lt;");
                            j += 3;
                            continue;
                        }
                        if (stringBuffer.charAt(j) != '&') continue;
                        stringBuffer.setCharAt(j, '&');
                        stringBuffer.insert(j + 1, "amp;");
                        j += 4;
                    }
                    string = string + "<pre>" + stringBuffer + "\n</pre>";
                }
            }
        }
        return string.trim();
    }

    public static Element getSubElement(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !string.equalsIgnoreCase((element2 = (Element)node).getTagName())) continue;
            return element2;
        }
        return null;
    }

    public static Document getDocument(String string) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            URL uRL = ClassLoader.getSystemResource(string);
            if (uRL == null) {
                System.out.println("Can't find file " + string);
                return null;
            }
            document = documentBuilder.parse(uRL.openStream());
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }
}

