/*
 * Decompiled with CFR 0.152.
 */
package test.interPlatform.tests;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.ParallelBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import test.common.Test;
import test.common.TestException;
import test.common.TestUtility;

public class TestCharset
extends Test {
    public static final String KEY1 = "pass";
    public static final String KEY2 = "charset";
    private static final String RESPONDER_NAME = "responder";
    private final String CONV_ID = "conv_ID" + this.hashCode();
    private final String CONTENT = "\u00e9\u00e8\u00e7\u00e0\u00fb\u00ef";
    private boolean pass = false;
    private String charset;
    private AID resp = null;

    public Behaviour load(Agent agent) throws TestException {
        try {
            String string = this.getTestArgument(KEY1);
            if (string != null) {
                this.pass = Boolean.valueOf(string);
            }
            this.charset = this.getTestArgument(KEY2);
            AID aID = (AID)this.getGroupArgument("remote-ams");
            this.resp = TestUtility.createAgent(agent, RESPONDER_NAME, "test.common.ConfigurableAgent", null, aID, null);
            TestUtility.addBehaviour(agent, this.resp, "test.common.behaviours.NotUnderstoodResponder");
            this.log("Responder correctly started on remote platform");
            SimpleBehaviour simpleBehaviour = new SimpleBehaviour(){
                private boolean finished = false;

                public void onStart() {
                    ACLMessage aCLMessage = new ACLMessage(7);
                    aCLMessage.addReceiver(TestCharset.this.resp);
                    aCLMessage.setConversationId(TestCharset.this.CONV_ID);
                    aCLMessage.setContent("\u00e9\u00e8\u00e7\u00e0\u00fb\u00ef");
                    if (TestCharset.this.charset != null) {
                        aCLMessage.setDefaultEnvelope();
                        aCLMessage.getEnvelope().setPayloadEncoding(TestCharset.this.charset);
                    } else {
                        TestCharset.this.charset = "US-ASCII";
                    }
                    this.myAgent.send(aCLMessage);
                }

                public void action() {
                    ACLMessage aCLMessage = this.myAgent.receive(MessageTemplate.MatchConversationId((String)TestCharset.this.CONV_ID));
                    if (aCLMessage != null) {
                        AID aID = aCLMessage.getSender();
                        if (!aID.equals((Object)TestCharset.this.resp)) {
                            TestCharset.this.failed("Unexpected reply sender " + aID.getName());
                        } else if (aCLMessage.getPerformative() != 10) {
                            TestCharset.this.failed("Unexpected reply performative " + aCLMessage.getPerformative());
                        } else if (TestCharset.this.pass ^ "\u00e9\u00e8\u00e7\u00e0\u00fb\u00ef".equals(aCLMessage.getContent())) {
                            TestCharset.this.failed("Unexpected reply content " + aCLMessage.getContent());
                        } else {
                            TestCharset.this.passed("Correct reply message received");
                        }
                        this.finished = true;
                    } else {
                        this.block();
                    }
                }

                public boolean done() {
                    return this.finished;
                }
            };
            WakerBehaviour wakerBehaviour = new WakerBehaviour(agent, 10000L){

                protected void handleElapsedTimeout() {
                    TestCharset.this.failed("Reply timeout expired");
                }
            };
            ParallelBehaviour parallelBehaviour = new ParallelBehaviour(agent, 1);
            parallelBehaviour.addSubBehaviour((Behaviour)simpleBehaviour);
            parallelBehaviour.addSubBehaviour((Behaviour)wakerBehaviour);
            return parallelBehaviour;
        }
        catch (TestException testException) {
            throw testException;
        }
        catch (Exception exception) {
            throw new TestException("Error loading test", exception);
        }
    }

    public void clean(Agent agent) {
        try {
            TestUtility.killAgent(agent, this.resp);
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

