/*
 * Decompiled with CFR 0.152.
 */
package test.interPlatform.tests;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAAgentManagement.Property;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.Iterator;
import java.io.Serializable;
import test.common.Test;
import test.common.TestException;
import test.common.TestUtility;

public class TestEnvelope
extends Test {
    private static final String RESPONDER_NAME = "responder";
    private static final String CONV_ID = "conv_ID";
    private static final TestSerializable TEST_SERIALIZABLE = new TestSerializable("XXXX", 1);
    private static final String TEST_STRING = "Test";
    private static final String KEY1 = "k1";
    private static final String KEY2 = "k2";
    private AID resp = null;

    public Behaviour load(Agent agent) throws TestException {
        this.setTimeout(10000L);
        try {
            AID aID = (AID)this.getGroupArgument("remote-ams");
            this.resp = TestUtility.createAgent(agent, RESPONDER_NAME, this.getClass().getName() + "$CheckEnvelopeAgent", null, aID, null);
            this.log("Responder correctly started on remote platform");
            SimpleBehaviour simpleBehaviour = new SimpleBehaviour(){
                private boolean finished = false;

                public void onStart() {
                    ACLMessage aCLMessage = new ACLMessage(7);
                    aCLMessage.setConversationId(TestEnvelope.CONV_ID);
                    aCLMessage.setDefaultEnvelope();
                    Envelope envelope = aCLMessage.getEnvelope();
                    envelope.addTo(TestEnvelope.this.resp);
                    envelope.addProperties(new Property(TestEnvelope.KEY1, (Object)TEST_SERIALIZABLE));
                    envelope.addProperties(new Property(TestEnvelope.KEY2, (Object)TestEnvelope.TEST_STRING));
                    this.myAgent.send(aCLMessage);
                }

                public void action() {
                    ACLMessage aCLMessage = this.myAgent.receive(MessageTemplate.MatchConversationId((String)TestEnvelope.CONV_ID));
                    if (aCLMessage != null) {
                        AID aID = aCLMessage.getSender();
                        if (aID.equals((Object)TestEnvelope.this.resp) && aCLMessage.getPerformative() == 7) {
                            TestEnvelope.this.passed("Message envelope OK");
                        } else {
                            TestEnvelope.this.failed("Wrong message envelope: " + aCLMessage.getContent());
                        }
                        this.finished = true;
                    } else {
                        this.block();
                    }
                }

                public boolean done() {
                    return this.finished;
                }
            };
            return simpleBehaviour;
        }
        catch (TestException testException) {
            throw testException;
        }
        catch (Exception exception) {
            throw new TestException("Error loading test", exception);
        }
    }

    public void clean(Agent agent) {
        try {
            TestUtility.killAgent(agent, this.resp);
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static class TestSerializable
    implements Serializable {
        private String s;
        private int n;

        TestSerializable(String string, int n) {
            this.s = string;
            this.n = n;
        }

        public boolean equals(Object object) {
            if (object instanceof TestSerializable) {
                TestSerializable testSerializable = (TestSerializable)object;
                return this.s.equals(testSerializable.s) && this.n == testSerializable.n;
            }
            return false;
        }
    }

    public static class CheckEnvelopeAgent
    extends Agent {
        protected void setup() {
            System.out.println("Responder started.");
            ACLMessage aCLMessage = this.blockingReceive(MessageTemplate.MatchConversationId((String)TestEnvelope.CONV_ID));
            System.out.println("Responder received test message.");
            ACLMessage aCLMessage2 = aCLMessage.createReply();
            aCLMessage2.setPerformative(6);
            try {
                Envelope envelope = aCLMessage.getEnvelope();
                Iterator iterator = envelope.getAllProperties();
                boolean bl = false;
                boolean bl2 = false;
                int n = 0;
                while (iterator.hasNext()) {
                    Property property = (Property)iterator.next();
                    ++n;
                    String string = property.getName();
                    if (string.equals(TestEnvelope.KEY1)) {
                        if (property.getValue().equals(TEST_SERIALIZABLE)) {
                            bl = true;
                            continue;
                        }
                        aCLMessage2.setContent("Wrong Serializable property value.");
                        break;
                    }
                    if (string.equals(TestEnvelope.KEY2)) {
                        if (property.getValue().equals(TestEnvelope.TEST_STRING)) {
                            bl2 = true;
                            continue;
                        }
                        aCLMessage2.setContent("Wrong String property value.");
                        break;
                    }
                    aCLMessage2.setContent("Unexpected property key " + string);
                    break;
                }
                if (n == 2) {
                    if (bl && bl2) {
                        aCLMessage2.setPerformative(7);
                    }
                } else {
                    aCLMessage2.setContent(n + " properties found while 2 were expected");
                }
            }
            catch (Throwable throwable) {
                aCLMessage2.setContent("Exception parsing envelope properties " + throwable.toString());
                throwable.printStackTrace();
            }
            this.send(aCLMessage2);
        }
    }
}

