/*
 * Decompiled with CFR 0.152.
 */
package test.interPlatform.tests;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import test.common.JadeController;
import test.common.Test;
import test.common.TestException;
import test.common.TestUtility;

public class TestIncomingMessageRouting
extends Test {
    private static final String RESPONDER_NAME = "responder";
    private final String CONV_ID = "conv_ID" + this.hashCode();
    private final String CONTENT = "\"PING\"";
    private JadeController jc;
    private AID resp = null;

    public Behaviour load(Agent agent) throws TestException {
        this.setTimeout(10000L);
        try {
            AID aID = (AID)this.getGroupArgument("remote-ams");
            String string = TestUtility.getContainerHostName(agent, aID, null);
            String string2 = "9003";
            this.jc = TestUtility.launchJadeInstance("Remote-Container", null, "-container -host " + string + " -port " + string2, null);
            this.log("Peripheral container correctly created on remote platform");
            this.resp = TestUtility.createAgent(agent, RESPONDER_NAME, "test.interPlatform.tests.TestIncomingMessageRouting$PingAgent", null, aID, this.jc.getContainerName());
            this.log("Responder correctly started on remote platform");
            SimpleBehaviour simpleBehaviour = new SimpleBehaviour(){
                private boolean finished = false;

                public void onStart() {
                    ACLMessage aCLMessage = new ACLMessage(7);
                    aCLMessage.addReceiver(TestIncomingMessageRouting.this.resp);
                    aCLMessage.setConversationId(TestIncomingMessageRouting.this.CONV_ID);
                    aCLMessage.setContent("\"PING\"");
                    this.myAgent.send(aCLMessage);
                }

                public void action() {
                    ACLMessage aCLMessage = this.myAgent.receive(MessageTemplate.MatchConversationId((String)TestIncomingMessageRouting.this.CONV_ID));
                    if (aCLMessage != null) {
                        AID aID = aCLMessage.getSender();
                        if (!aID.equals((Object)TestIncomingMessageRouting.this.resp)) {
                            TestIncomingMessageRouting.this.failed("Unexpected reply sender " + aID.getName());
                        } else if (aCLMessage.getPerformative() != 10) {
                            TestIncomingMessageRouting.this.failed("Unexpected reply performative " + aCLMessage.getPerformative());
                        } else if (!"\"PING\"".equals(aCLMessage.getContent())) {
                            TestIncomingMessageRouting.this.failed("Unexpected reply content " + aCLMessage.getContent());
                        } else {
                            TestIncomingMessageRouting.this.passed("Reply message correctly received");
                        }
                        this.finished = true;
                    } else {
                        this.block();
                    }
                }

                public boolean done() {
                    return this.finished;
                }
            };
            return simpleBehaviour;
        }
        catch (TestException testException) {
            throw testException;
        }
        catch (Exception exception) {
            throw new TestException("Error loading test", exception);
        }
    }

    public void clean(Agent agent) {
        try {
            this.jc.kill();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class PingAgent
    extends Agent {
        protected void setup() {
            this.addBehaviour((Behaviour)new CyclicBehaviour(this){

                public void action() {
                    ACLMessage aCLMessage = this.myAgent.receive();
                    if (aCLMessage != null) {
                        ACLMessage aCLMessage2 = aCLMessage.createReply();
                        aCLMessage2.setPerformative(10);
                        aCLMessage2.setContent(aCLMessage.getContent());
                        this.myAgent.send(aCLMessage2);
                    } else {
                        this.block();
                    }
                }
            });
        }
    }
}

