/*
 * Decompiled with CFR 0.152.
 */
package test.interPlatform.tests;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.Properties;
import test.common.Test;
import test.common.TestException;
import test.common.TestUtility;

public class TestRemotePing
extends Test {
    private static final String RESPONDER_NAME = "responder";
    private final String CONV_ID = "conv_ID" + this.hashCode();
    private final String CONTENT = "\"PING\"";
    private final String USER_DEF_KEY = "U_KEY";
    private final String USER_DEF_VALUE = "U_VALUE";
    private AID resp = null;

    public Behaviour load(Agent agent) throws TestException {
        this.setTimeout(10000L);
        try {
            AID aID = (AID)this.getGroupArgument("remote-ams");
            this.resp = TestUtility.createAgent(agent, RESPONDER_NAME, "test.common.ConfigurableAgent", null, aID, null);
            TestUtility.addBehaviour(agent, this.resp, "test.common.behaviours.NotUnderstoodResponder");
            this.log("Responder correctly started on remote platform");
            SimpleBehaviour simpleBehaviour = new SimpleBehaviour(){
                private boolean finished = false;

                public void onStart() {
                    ACLMessage aCLMessage = new ACLMessage(7);
                    aCLMessage.addReceiver(TestRemotePing.this.resp);
                    aCLMessage.setConversationId(TestRemotePing.this.CONV_ID);
                    aCLMessage.setContent("\"PING\"");
                    aCLMessage.addUserDefinedParameter("U_KEY", "U_VALUE");
                    this.myAgent.send(aCLMessage);
                }

                public void action() {
                    ACLMessage aCLMessage = this.myAgent.receive(MessageTemplate.MatchConversationId((String)TestRemotePing.this.CONV_ID));
                    if (aCLMessage != null) {
                        AID aID = aCLMessage.getSender();
                        Properties properties = aCLMessage.getAllUserDefinedParameters();
                        if (!aID.equals((Object)TestRemotePing.this.resp)) {
                            TestRemotePing.this.failed("Unexpected reply sender " + aID.getName());
                        } else if (aCLMessage.getPerformative() != 10) {
                            TestRemotePing.this.failed("Unexpected reply performative " + aCLMessage.getPerformative());
                        } else if (!"\"PING\"".equals(aCLMessage.getContent())) {
                            TestRemotePing.this.failed("Unexpected reply content " + aCLMessage.getContent());
                        } else if (properties.size() != 1) {
                            TestRemotePing.this.failed(properties.size() + " user defined parameters found while 1 was expected");
                        } else if (!"U_VALUE".equals(aCLMessage.getUserDefinedParameter("U_KEY"))) {
                            TestRemotePing.this.failed("Unexpected user defined parameter " + aCLMessage.getUserDefinedParameter("U_KEY"));
                        } else {
                            TestRemotePing.this.passed("Reply message correctly received");
                        }
                        this.finished = true;
                    } else {
                        this.block();
                    }
                }

                public boolean done() {
                    return this.finished;
                }
            };
            return simpleBehaviour;
        }
        catch (TestException testException) {
            throw testException;
        }
        catch (Exception exception) {
            throw new TestException("Error loading test", exception);
        }
    }

    public void clean(Agent agent) {
        try {
            TestUtility.killAgent(agent, this.resp);
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

