/*
 * Decompiled with CFR 0.152.
 */
package test.interPlatform.tests;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import test.common.JadeController;
import test.common.Test;
import test.common.TestException;
import test.common.TestUtility;

public class TestReplyTo
extends Test {
    private static final String AGENT_A = "A";
    private static final String AGENT_B = "B";
    private static final String CONV_ID = "conv_ID";
    private AID agentA;
    private AID agentB;
    private JadeController jc;

    public Behaviour load(Agent agent) throws TestException {
        this.setTimeout(10000L);
        this.jc = TestUtility.launchJadeInstance("Container-1", null, "-container -host " + TestUtility.getContainerHostName(agent, null) + " -port " + 1099, null);
        this.agentA = TestUtility.createAgent(agent, AGENT_A, this.getClass().getName() + "$ResponderAgent", null, agent.getAMS(), this.jc.getContainerName());
        AID aID = (AID)this.getGroupArgument("remote-ams");
        this.agentB = TestUtility.createAgent(agent, AGENT_B, this.getClass().getName() + "$ResponderAgent", null, aID, null);
        Behaviour behaviour = new Behaviour(agent){
            public boolean finished;
            {
                this.finished = false;
            }

            public void onStart() {
                ACLMessage aCLMessage = new ACLMessage(7);
                aCLMessage.addReceiver(TestReplyTo.this.agentA);
                aCLMessage.addReplyTo(TestReplyTo.this.agentB);
                aCLMessage.setConversationId(TestReplyTo.CONV_ID);
                System.out.println("Sending message " + aCLMessage);
                this.myAgent.send(aCLMessage);
            }

            public void action() {
                ACLMessage aCLMessage = this.myAgent.receive(MessageTemplate.MatchConversationId((String)TestReplyTo.CONV_ID));
                if (aCLMessage != null) {
                    TestReplyTo.this.log("Reply received.");
                    if (aCLMessage.getSender().equals((Object)TestReplyTo.this.agentB)) {
                        TestReplyTo.this.passed("Reply correct.");
                    } else {
                        TestReplyTo.this.failed("Unexpected reply sender " + aCLMessage.getSender().getName());
                    }
                    this.finished = true;
                } else {
                    this.block();
                }
            }

            public boolean done() {
                return this.finished;
            }
        };
        return behaviour;
    }

    public void clean(Agent agent) {
        try {
            this.jc.kill();
            TestUtility.killAgent(agent, this.agentB);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class ResponderAgent
    extends Agent {
        protected void setup() {
            this.addBehaviour((Behaviour)new CyclicBehaviour(this){

                public void action() {
                    ACLMessage aCLMessage = this.myAgent.receive(MessageTemplate.MatchConversationId((String)TestReplyTo.CONV_ID));
                    if (aCLMessage != null) {
                        System.out.println(ResponderAgent.this.getLocalName() + ": Responder received test message.");
                        ACLMessage aCLMessage2 = aCLMessage.createReply();
                        aCLMessage2.addReplyTo(aCLMessage.getSender());
                        aCLMessage2.setPerformative(10);
                        this.myAgent.send(aCLMessage2);
                    } else {
                        this.block();
                    }
                }
            });
            System.out.println(this.getLocalName() + ": Responder started.");
        }
    }
}

