/*
 * Decompiled with CFR 0.152.
 */
package jade.webservice;

import jade.content.abs.AbsExtendedPrimitive;
import jade.content.abs.AbsObject;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.UnknownSchemaException;
import jade.content.schema.ObjectSchema;
import jade.content.schema.PrimitiveSchema;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XsdPrimitivesOntology
extends Ontology {
    private static final XsdPrimitivesOntology theInstance = new XsdPrimitivesOntology();

    private XsdPrimitivesOntology() {
        super("XSD_PRIMITIVES_ONTOLOGY", (Ontology)null, null);
    }

    private void add(Class c) throws OntologyException {
        this.add((ObjectSchema)new PrimitiveSchema(c.getName()), c);
    }

    private void initialize() {
        try {
            this.add(BigInteger.class);
            this.add(BigDecimal.class);
            this.add(Short.class);
            this.add(Byte.class);
            this.add(Short.TYPE);
            this.add(Byte.TYPE);
            this.add(Date.class);
            this.add(MessageElement.class);
            this.add(URI.class);
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
    }

    public static Ontology getInstance() {
        return theInstance;
    }

    protected Object toObject(AbsObject abs, String lcType, Ontology referenceOnto) throws UngroundedException, OntologyException {
        if (abs == null) {
            return null;
        }
        if (abs.getAbsType() == 10) {
            return ((AbsExtendedPrimitive)abs).get();
        }
        throw new UnknownSchemaException();
    }

    protected AbsObject fromObject(Object obj, Ontology referenceOnto) throws OntologyException {
        if (obj == null) {
            return null;
        }
        if (this.getSchema(obj.getClass()) != null) {
            return AbsExtendedPrimitive.wrap((Object)obj);
        }
        throw new UnknownSchemaException();
    }

    public static MessageElement xml2MessageElement(String xml) throws Exception {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document XMLDoc = documentBuilder.parse(new InputSource(new StringReader(xml)));
        return new MessageElement(XMLDoc.getDocumentElement());
    }

    public static String messageElement2Xml(MessageElement messageElement) throws Exception {
        return messageElement.getAsString();
    }

    static {
        theInstance.initialize();
    }
}

