/*
 * Decompiled with CFR 0.152.
 */
package jade.webservice.dynamicClient;

import jade.content.abs.AbsObject;
import jade.content.onto.BasicOntology;
import jade.content.onto.BeanOntology;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.security.ThreadGroupHttpAuthenticator;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import jade.webservice.XsdPrimitivesOntology;
import jade.webservice.dynamicClient.AddressingProperties;
import jade.webservice.dynamicClient.DynamicClientException;
import jade.webservice.dynamicClient.DynamicClientProperties;
import jade.webservice.dynamicClient.HeaderInfo;
import jade.webservice.dynamicClient.OperationInfo;
import jade.webservice.dynamicClient.OperationParser;
import jade.webservice.dynamicClient.ParameterInfo;
import jade.webservice.dynamicClient.PortInfo;
import jade.webservice.dynamicClient.SecurityProperties;
import jade.webservice.dynamicClient.ServiceInfo;
import jade.webservice.dynamicClient.WSData;
import jade.webservice.utils.CompilerUtils;
import jade.webservice.utils.FileUtils;
import jade.webservice.utils.SSLUtils;
import jade.webservice.utils.WSDLUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisProperties;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleChain;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.handlers.SimpleSessionHandler;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.ReferenceParametersType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.message.addressing.RelatesTo;
import org.apache.axis.message.addressing.handler.AddressingHandler;
import org.apache.axis.transport.http.HTTPSender;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.GeneratedFileInfo;
import org.apache.ws.axis.security.WSDoAllReceiver;
import org.apache.ws.axis.security.WSDoAllSender;
import org.apache.ws.axis.security.handler.WSDoAllHandler;
import org.apache.ws.security.WSPasswordCallback;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicClient {
    public static final SimpleDateFormat ISO8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static Logger logger = Logger.getMyLogger((String)DynamicClient.class.getName());
    private URL defaultEndpoint;
    private String defaultServiceName;
    private String defaultPortName;
    private int defaultTimeout = -1;
    private String defaultHttpUsername;
    private String defaultHttpPassword;
    private String defaultWSSUsername;
    private String defaultWSSPassword;
    private String defaultWSSPasswordType;
    private Boolean defaultWSSMustUnderstand;
    private Integer defaultWSSTimeToLive;
    private DynamicClientProperties properties;
    private ClassLoader classloader;
    private String documentation;
    private State state;
    private DynamicClientException initializationException;
    private BeanOntology typeOnto;
    private Map<String, ServiceInfo> servicesInfo = new HashMap<String, ServiceInfo>();
    private StringBuilder sbReport;

    public DynamicClient() {
        this.typeOnto = new BeanOntology("WSDL-TYPES", new Ontology[]{XsdPrimitivesOntology.getInstance(), BasicOntology.getInstance()});
        this.state = State.CREATED;
        this.classloader = Thread.currentThread().getContextClassLoader();
        this.properties = new DynamicClientProperties();
    }

    public DynamicClientProperties getProperties() {
        return this.properties;
    }

    public void setProperties(DynamicClientProperties properties) {
        this.properties = properties;
    }

    public URL getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public void setDefaultEndpoint(URL defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    public String getDefaultService() {
        return this.defaultServiceName;
    }

    public void setDefaultService(String defaultServiceName) {
        this.defaultServiceName = defaultServiceName;
    }

    public String getDefaultPort() {
        return this.defaultPortName;
    }

    public void setDefaultPort(String defaultPortName) {
        this.defaultPortName = defaultPortName;
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(int defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public String getDefaultHttpUsername() {
        return this.defaultHttpUsername;
    }

    public void setDefaultHttpUsername(String defaultHttpUsername) {
        this.defaultHttpUsername = defaultHttpUsername;
    }

    public String getDefaultHttpPassword() {
        return this.defaultHttpPassword;
    }

    public void setDefaultHttpPassword(String defaultHttpPassword) {
        this.defaultHttpPassword = defaultHttpPassword;
    }

    public String getDefaultWSSUsername() {
        return this.defaultWSSUsername;
    }

    public void setDefaultWSSUsername(String defaultWSSUsername) {
        this.defaultWSSUsername = defaultWSSUsername;
    }

    public String getDefaultWSSPassword() {
        return this.defaultWSSPassword;
    }

    public void setDefaultWSSPassword(String defaultWSSPassword) {
        this.defaultWSSPassword = defaultWSSPassword;
    }

    public String getDefaultWSSPasswordType() {
        return this.defaultWSSPasswordType;
    }

    public void setDefaultWSSPasswordType(String defaultWSSPasswordType) {
        this.defaultWSSPasswordType = defaultWSSPasswordType;
    }

    public Boolean isDefaultWSSMustUnderstand() {
        return this.defaultWSSMustUnderstand;
    }

    public void setDefaultWSSMustUnderstand(boolean defaultWSSMustUnderstand) {
        this.defaultWSSMustUnderstand = defaultWSSMustUnderstand;
    }

    public Integer getDefaultWSSTimeToLive() {
        return this.defaultWSSTimeToLive;
    }

    public void setDefaultWSSTimeToLive(int defaultWSSTimeToLive) {
        this.defaultWSSTimeToLive = defaultWSSTimeToLive;
    }

    public static void setTrustStore(String trustStore) {
        SSLUtils.setTrustStore(trustStore);
    }

    public static void setTrustStorePassword(String trustStorePassword) {
        SSLUtils.setTrustStorePassword(trustStorePassword);
    }

    public static void disableCertificateChecking() {
        AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)"org.apache.axis.components.net.SunFakeTrustSocketFactory");
        SSLUtils.trustAll();
    }

    public static void enableCertificateChecking() {
        AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)"");
        SSLUtils.resetTrustAll();
    }

    public static void setProxyHost(String proxyHost) {
        ThreadGroupHttpAuthenticator.getInstance();
        ThreadGroupHttpAuthenticator.setProxyHost((String)proxyHost);
    }

    public static void setProxyPort(String proxyPort) {
        ThreadGroupHttpAuthenticator.getInstance();
        ThreadGroupHttpAuthenticator.setProxyPort((String)proxyPort);
    }

    public static void setNonProxyHosts(String nonProxyHosts) {
        ThreadGroupHttpAuthenticator.getInstance();
        ThreadGroupHttpAuthenticator.setNonProxyHosts((String)nonProxyHosts);
    }

    public static void setProxyAuthentication(String proxyUser, String proxyPassword) {
        ThreadGroupHttpAuthenticator.getInstance().setProxyCredential(proxyUser, proxyPassword);
    }

    public State getState() {
        return this.state;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    DynamicClientException getInitializationExceptionException() {
        return this.initializationException;
    }

    public void initClient(URI wsdlUri) throws DynamicClientException {
        this.initClient(wsdlUri, this.defaultHttpUsername, this.defaultHttpPassword);
    }

    public void initClient(URI wsdlUri, String username, String password) throws DynamicClientException {
        Exception compilerException;
        boolean localNoWrap = this.properties.isNoWrap();
        boolean localWrapArrays = this.properties.isWrapArrays();
        try {
            compilerException = this.internalInitClient(wsdlUri, username, password, localNoWrap, localWrapArrays);
            if (compilerException != null && this.properties.isSafeMode() && !localWrapArrays) {
                localWrapArrays = true;
                compilerException = this.internalInitClient(wsdlUri, username, password, localNoWrap, localWrapArrays);
            }
            if (compilerException != null && this.properties.isSafeMode() && !localNoWrap) {
                localNoWrap = true;
                localWrapArrays = this.properties.isWrapArrays();
                compilerException = this.internalInitClient(wsdlUri, username, password, localNoWrap, localWrapArrays);
            }
        }
        catch (DynamicClientException dce) {
            this.state = State.INIT_FAILED;
            this.initializationException = dce;
            logger.log(Logger.WARNING, "Error discovering " + wsdlUri, (Throwable)dce);
            throw dce;
        }
        if (compilerException != null) {
            this.state = State.INIT_FAILED;
            this.initializationException = new DynamicClientException("Error compiling wsdl-java source files", compilerException);
            logger.log(Logger.WARNING, "Error discovering " + wsdlUri, (Throwable)this.initializationException);
            throw this.initializationException;
        }
        logger.info("Wsdl " + wsdlUri + " discovered, dynamic-client ready to invoke");
        this.state = State.INITIALIZED;
    }

    private Exception internalInitClient(URI wsdlUri, String username, String password, boolean noWrap, boolean wrapArrays) throws DynamicClientException {
        String id;
        File src;
        block30: {
            src = null;
            File classes = null;
            id = "DynamicClient-" + System.currentTimeMillis();
            if (wsdlUri == null) {
                throw new DynamicClientException("Wsdl uri not specified");
            }
            this.resetReport();
            this.addToReport("-- Dynamic Client Report --");
            this.addToReport("Wsdl:     " + wsdlUri);
            this.addToReport("Username: " + (username != null ? username : ""));
            this.addToReport("Password: " + (password != null ? password : ""));
            this.addToReport("Wrapped:  " + !noWrap);
            logger.log(Logger.FINE, "Tmp-dir:  " + this.properties.getTmpDir());
            this.defaultServiceName = null;
            this.defaultPortName = null;
            this.defaultEndpoint = null;
            Emitter emitter = new Emitter();
            emitter.setTimeout(this.properties.getDiscoverTimeout());
            emitter.setAllWanted(true);
            emitter.setNowrap(noWrap);
            emitter.setWrapArrays(wrapArrays);
            emitter.setPackageName(this.properties.getPackageName());
            emitter.setBobMode(true);
            emitter.setAllowInvalidURL(true);
            emitter.setVerbose(logger.isLoggable(Logger.FINE));
            ThreadGroup threadGroup = new ThreadGroup(id);
            emitter.setThreadGroup(threadGroup);
            if (username != null) {
                ThreadGroupHttpAuthenticator.getInstance().setServerCredential(id, username, password);
            }
            if (!(src = new File(this.properties.getTmpDir(), id + "-src")).mkdir()) {
                throw new DynamicClientException("Unable to create working directory " + src.getAbsolutePath());
            }
            classes = new File(this.properties.getTmpDir(), id + "-classes");
            if (!classes.mkdir()) {
                throw new DynamicClientException("Unable to create working directory " + classes.getAbsolutePath());
            }
            try {
                emitter.setOutputDir(src.getAbsolutePath());
                emitter.run(wsdlUri.toString());
            }
            catch (SocketException se) {
                throw new DynamicClientException("Wsdl " + wsdlUri.toString() + " unreachable", se);
            }
            catch (Exception e) {
                throw new DynamicClientException("Error parsing wsdl " + wsdlUri.toString() + " Cause: " + e.getMessage(), e);
            }
            StringBuilder classPath = this.properties.getClassPath();
            if (classPath == null) {
                classPath = new StringBuilder();
                try {
                    CompilerUtils.setupClasspath(classPath, this.classloader);
                }
                catch (Exception e) {
                    throw new DynamicClientException("Unable to create compiler classpath", e);
                }
            }
            java.util.List<File> srcFiles = FileUtils.getFilesRecurse(src, ".+\\.java$");
            try {
                CompilerUtils.compileJavaSrc(classPath.toString(), srcFiles, classes.toString());
            }
            catch (Exception e) {
                Exception exception = e;
                if (classes != null) {
                    FileUtils.removeDir(classes);
                }
                if (src != null) {
                    FileUtils.removeDir(src);
                }
                ThreadGroupHttpAuthenticator.getInstance().resetServerCredential(id);
                return exception;
            }
            try {
                URLClassLoader cl;
                try {
                    cl = new URLClassLoader(new URL[]{classes.toURI().toURL()}, this.classloader);
                }
                catch (MalformedURLException e) {
                    throw new DynamicClientException("Error creating classloader, a directory returns a malformed URL: " + e.getMessage(), e);
                }
                String className = null;
                try {
                    logger.log(Logger.FINE, "Classes loaded in classloader");
                    GeneratedFileInfo generatedFileInfo = emitter.getGeneratedFileInfo();
                    for (Object entry : generatedFileInfo.getList()) {
                        GeneratedFileInfo.Entry fileInfo = (GeneratedFileInfo.Entry)entry;
                        className = fileInfo.className;
                        logger.log(Logger.FINE, "\t(" + fileInfo.type + ") " + className);
                        Class<?> clazz = cl.loadClass(className);
                        if (!"complexType".equals(fileInfo.type) || this.typeOnto.getSchema(clazz) != null) continue;
                        this.typeOnto.add(clazz);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new DynamicClientException("Error loading class " + className, e);
                }
                catch (OntologyException e) {
                    throw new DynamicClientException("Error creating schema for class " + className, e);
                }
                Thread.currentThread().setContextClassLoader(cl);
                this.classloader = Thread.currentThread().getContextClassLoader();
                try {
                    this.parseWsdl(emitter);
                }
                catch (Exception e) {
                    throw new DynamicClientException("Error parsing wsdl", e);
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(out);
                this.typeOnto.dump(ps);
                this.addToReport(out.toString());
                if (classes == null) break block30;
            }
            catch (DynamicClientException e) {
                try {
                    logger.log(Logger.SEVERE, "Error discovering wsdl " + wsdlUri, (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (classes != null) {
                        FileUtils.removeDir(classes);
                    }
                    if (src != null) {
                        FileUtils.removeDir(src);
                    }
                    ThreadGroupHttpAuthenticator.getInstance().resetServerCredential(id);
                    throw throwable;
                }
            }
            FileUtils.removeDir(classes);
        }
        if (src != null) {
            FileUtils.removeDir(src);
        }
        ThreadGroupHttpAuthenticator.getInstance().resetServerCredential(id);
        return null;
    }

    public Ontology getOntology() {
        return this.typeOnto;
    }

    public Set<String> getServiceNames() {
        return this.servicesInfo.keySet();
    }

    public ServiceInfo getService(String serviceName) {
        if (serviceName == null && this.servicesInfo.values().iterator().hasNext()) {
            return this.servicesInfo.values().iterator().next();
        }
        return this.servicesInfo.get(serviceName);
    }

    private void parseWsdl(Emitter emitter) throws DynamicClientException, OntologyException, ClassNotFoundException, SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.documentation = this.getDocumentation(emitter.getSymbolTable().getDefinition());
        this.servicesInfo.clear();
        java.util.List<ServiceEntry> services = WSDLUtils.getServices((Parser)emitter);
        for (ServiceEntry serviceEntry : services) {
            String serviceName = serviceEntry.getOriginalServiceName();
            this.addToReport("Service: " + serviceName);
            Service locator = this.createLocator(serviceEntry);
            ServiceInfo serviceInfo = new ServiceInfo(serviceName, locator);
            serviceInfo.setDocumentation(this.getDocumentation(serviceEntry.getService()));
            this.servicesInfo.put(serviceName, serviceInfo);
            Collection<Port> ports = WSDLUtils.getPorts(serviceEntry);
            for (Port port : ports) {
                String portName = port.getName();
                this.addToReport("Port: " + portName, 1);
                Method stubMethod = this.getStubMethod(emitter, port, locator);
                if (stubMethod == null) continue;
                PortInfo portInfo = new PortInfo(portName, stubMethod);
                portInfo.setDocumentation(this.getDocumentation(port));
                serviceInfo.putPort(portName, portInfo);
                java.util.List<BindingOperation> operations = WSDLUtils.getOperations(port);
                for (BindingOperation bindingOperation : operations) {
                    OperationParser opParser;
                    String operationName = bindingOperation.getName();
                    this.addToReport("Operation: " + operationName, 2);
                    OperationInfo operationInfo = new OperationInfo(operationName);
                    String opDoc1 = this.getDocumentation(bindingOperation);
                    String opDoc2 = this.getDocumentation(bindingOperation.getOperation());
                    if (opDoc1 != null || opDoc2 != null) {
                        String opDoc = "";
                        if (opDoc1 != null) {
                            opDoc = opDoc + opDoc1;
                        }
                        if (opDoc2 != null) {
                            if (opDoc.length() > 0 && opDoc2.length() > 0) {
                                opDoc = opDoc + ", ";
                            }
                            opDoc = opDoc + opDoc2;
                        }
                        operationInfo.setDocumentation(opDoc);
                    }
                    portInfo.putOperation(operationName, operationInfo);
                    try {
                        opParser = new OperationParser(bindingOperation, port.getBinding(), emitter, this.typeOnto, this.classloader);
                    }
                    catch (ClassNotFoundException e) {
                        throw new DynamicClientException(e);
                    }
                    java.util.List<ParameterInfo> parameters = opParser.getParameters();
                    for (ParameterInfo parameterInfo : parameters) {
                        operationInfo.putParameter(parameterInfo.getName(), parameterInfo);
                        this.addToReport("Parameter: " + parameterInfo, 3);
                    }
                    Collection<HeaderInfo> explicitHeaders = opParser.getExplicitHeaders();
                    for (HeaderInfo headerInfo : explicitHeaders) {
                        operationInfo.putHeader(headerInfo.getName(), headerInfo);
                        this.addToReport("Explicit header: " + headerInfo, 3);
                    }
                    Collection<HeaderInfo> implicitHeaders = opParser.getImplicitHeaders();
                    for (HeaderInfo headerInfo : implicitHeaders) {
                        operationInfo.putHeader(headerInfo.getName(), headerInfo);
                        this.addToReport("Implicit header: " + headerInfo, 3);
                    }
                    Class<?> stubClass = stubMethod.getReturnType();
                    operationInfo.manageOperationStubMethod(stubClass);
                }
            }
        }
    }

    public WSData invoke(String operation, WSData input) throws DynamicClientException, RemoteException {
        return this.invoke(null, null, operation, null, -1, null, input);
    }

    public WSData invoke(String serviceName, String portName, String operation, URL endpoint, int timeout, WSData input) throws DynamicClientException, RemoteException {
        return this.invoke(serviceName, portName, operation, endpoint, timeout, null, input);
    }

    public WSData invoke(String serviceName, String portName, String operation, URL endpoint, int timeout, SecurityProperties securityProperties, WSData input) throws DynamicClientException, RemoteException {
        return this.invoke(serviceName, portName, operation, endpoint, timeout, securityProperties, null, input);
    }

    public WSData invoke(String serviceName, String portName, String operation, URL endpoint, int timeout, SecurityProperties securityProperties, AddressingProperties addressingProperties, WSData input) throws DynamicClientException, RemoteException {
        try {
            Stub stub;
            PortInfo portInfo;
            ServiceInfo serviceInfo;
            if (this.state != State.INITIALIZED) {
                throw new DynamicClientException("DynamicClient not inited, current state=" + (Object)((Object)this.state));
            }
            if (serviceName == null) {
                serviceName = this.defaultServiceName;
            }
            if ((serviceInfo = this.getService(serviceName)) == null) {
                throw new DynamicClientException("Service " + serviceName + " not present");
            }
            if (portName == null) {
                portName = this.defaultPortName;
            }
            if ((portInfo = serviceInfo.getPort(portName)) == null) {
                throw new DynamicClientException("Port " + portName + " not present in service " + serviceInfo.getName());
            }
            OperationInfo operationInfo = portInfo.getOperation(operation);
            if (operationInfo == null) {
                throw new DynamicClientException("Operation " + operation + " not present in service " + serviceInfo.getName() + ", port " + portInfo.getName());
            }
            Method stubMethod = portInfo.getStubMethod();
            Service service = serviceInfo.getLocator();
            SimpleSessionHandler sessionHandler = new SimpleSessionHandler();
            SimpleChain requestHandlers = new SimpleChain();
            SimpleChain responseHandlers = new SimpleChain();
            requestHandlers.addHandler((Handler)sessionHandler);
            responseHandlers.addHandler((Handler)sessionHandler);
            HTTPSender pivot = new HTTPSender();
            SimpleTargetedChain transport = new SimpleTargetedChain((Handler)requestHandlers, (Handler)pivot, (Handler)responseHandlers);
            SimpleProvider clientConfig = new SimpleProvider();
            clientConfig.deployTransport("http", (Handler)transport);
            service.setEngineConfiguration((EngineConfiguration)clientConfig);
            service.setEngine((AxisEngine)new AxisClient((EngineConfiguration)clientConfig));
            try {
                stub = this.createStub(stubMethod, service);
            }
            catch (Exception e) {
                throw new DynamicClientException("Error creating service stub for service " + serviceInfo.getName() + ", port " + portInfo.getName());
            }
            if (endpoint == null) {
                endpoint = this.defaultEndpoint;
            }
            if (endpoint != null) {
                stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)endpoint.toExternalForm());
            }
            if (timeout < 0) {
                timeout = this.defaultTimeout;
            }
            if (timeout >= 0) {
                stub.setTimeout(timeout);
            }
            this.applySecurity(stub, requestHandlers, responseHandlers, securityProperties);
            try {
                this.applyAddressing(stub, requestHandlers, responseHandlers, addressingProperties);
            }
            catch (Exception e) {
                throw new DynamicClientException("Error apply addressing for service " + serviceInfo.getName());
            }
            logger.info("Invoke " + serviceInfo.getName() + "->" + portInfo.getName() + "->" + operationInfo.getName());
            logger.info("Input\n" + input);
            Vector<ParameterInfo> methodParams = operationInfo.getStubMethodParameters();
            Object[] methodValuesObj = new Object[methodParams.size()];
            for (int index = 0; index < methodParams.size(); ++index) {
                ParameterInfo methodParam = methodParams.get(index);
                AbsObject methodParamAbs = null;
                if (input != null) {
                    methodParamAbs = methodParam instanceof HeaderInfo ? input.getHeader(methodParam.getName()) : input.getParameter(methodParam.getName());
                }
                Object methodParamValue = this.convertAbsToObj(methodParam, methodParamAbs);
                if (Holder.class.isAssignableFrom(methodParam.getTypeClass())) {
                    methodParamValue = JavaUtils.convert((Object)methodParamValue, (Class)methodParam.getTypeClass());
                }
                methodValuesObj[index] = methodParamValue;
            }
            if (input != null) {
                Iterator<String> ith = operationInfo.getInputHeaderNames().iterator();
                while (ith.hasNext()) {
                    AbsObject headerAbs;
                    HeaderInfo hi = operationInfo.getInputHeader(ith.next());
                    String headerName = hi.getName();
                    int signaturePosition = hi.getSignaturePosition();
                    if (signaturePosition != -1 || (headerAbs = input.getHeader(headerName)) == null) continue;
                    SOAPHeaderElement header = new SOAPHeaderElement(hi.getNamespace(), headerName, this.convertAbsToObj(hi, headerAbs));
                    header.setActor(hi.getActor());
                    header.setMustUnderstand(hi.isMustUnderstand());
                    header.setRelay(hi.isRelay());
                    stub.setHeader(header);
                }
            }
            Object returnValue = null;
            Method operationMethod = operationInfo.getOperationMethod();
            try {
                returnValue = operationMethod.invoke((Object)stub, methodValuesObj);
            }
            catch (InvocationTargetException ie) {
                if (ie.getCause() instanceof RemoteException) {
                    throw (RemoteException)ie.getCause();
                }
                throw new DynamicClientException("Error invoking operation " + operation + ", service " + serviceInfo.getName() + ", port " + portInfo.getName(), ie.getCause());
            }
            catch (Exception e) {
                throw new DynamicClientException("Error invoking operation " + operation + ", service " + serviceInfo.getName() + ", port " + portInfo.getName(), e);
            }
            WSData output = new WSData();
            Iterator<String> ith = operationInfo.getOutputHeaderNames().iterator();
            while (ith.hasNext()) {
                AbsObject headerAbs;
                HeaderInfo hi = operationInfo.getOutputHeader(ith.next());
                String headerName = hi.getName();
                int signaturePosition = hi.getSignaturePosition();
                if (signaturePosition != -1 || (headerAbs = this.getHeaderAbsValue(stub, hi)) == null) continue;
                output.setHeader(headerName, headerAbs);
            }
            for (int index = 0; index < methodParams.size(); ++index) {
                ParameterInfo methodParam = methodParams.get(index);
                String paramName = methodParam.getName();
                int paramMode = methodParam.getMode();
                if (paramMode != 1 && paramMode != 2) continue;
                Holder paramHolderValue = (Holder)methodValuesObj[index];
                Class paramValueClass = JavaUtils.getHolderValueType(paramHolderValue.getClass());
                Object methodParamValue = JavaUtils.convert((Object)paramHolderValue, (Class)paramValueClass);
                AbsObject absValue = this.convertObjToAbs(methodParam, methodParamValue);
                if (methodParam instanceof HeaderInfo) {
                    output.setHeader(paramName, absValue);
                    continue;
                }
                output.setParameter(paramName, absValue);
            }
            ParameterInfo returnParameter = operationInfo.getStubMethodReturnParameter();
            if (returnParameter != null) {
                AbsObject absValue = this.convertObjToAbs(returnParameter, returnValue);
                output.setParameter(returnParameter.getName(), absValue);
            }
            logger.info("Output\n" + output);
            return output;
        }
        catch (DynamicClientException e) {
            logger.log(Logger.WARNING, "Error invoking operation " + operation, (Throwable)e);
            throw e;
        }
    }

    private void applySecurity(Stub stub, SimpleChain requestHandlers, SimpleChain responseHandlers, SecurityProperties securityProperties) {
        Integer wssTimeToLive;
        Boolean wssMustUnderstand;
        String wssPasswordType;
        String wssPassword;
        String wssUsername;
        String httpPassword;
        String httpUsername;
        if (securityProperties == null) {
            securityProperties = new SecurityProperties();
        }
        if ((httpUsername = securityProperties.getHttpUsername()) == null) {
            httpUsername = this.defaultHttpUsername;
        }
        if ((httpPassword = securityProperties.getHttpPassword()) == null) {
            httpPassword = this.defaultHttpPassword;
        }
        if ((wssUsername = securityProperties.getWSSUsername()) == null) {
            wssUsername = this.defaultWSSUsername;
        }
        if ((wssPassword = securityProperties.getWSSPassword()) == null) {
            wssPassword = this.defaultWSSPassword;
        }
        if ((wssPasswordType = securityProperties.getWSSPasswordType()) == null) {
            wssPasswordType = this.defaultWSSPasswordType;
        }
        if ((wssMustUnderstand = securityProperties.isWSSMustUnderstand()) == null) {
            wssMustUnderstand = this.defaultWSSMustUnderstand;
        }
        if ((wssTimeToLive = securityProperties.getWSSTimeToLive()) == null) {
            wssTimeToLive = this.defaultWSSTimeToLive;
        }
        if (httpUsername != null && httpPassword != null) {
            stub.setUsername(httpUsername);
            stub.setPassword(httpPassword);
        }
        if (wssUsername != null && wssPassword != null || wssTimeToLive != null) {
            if (wssMustUnderstand != null) {
                stub._setProperty("mustUnderstand", (Object)wssMustUnderstand.toString());
            }
            WSDoAllSender wssSenderHandler = new WSDoAllSender();
            requestHandlers.addHandler((Handler)wssSenderHandler);
            if (wssUsername != null && wssPassword != null) {
                DynamicClient.addHandlerAction((WSDoAllHandler)wssSenderHandler, "UsernameToken");
                stub._setProperty("passwordType", (Object)wssPasswordType);
                stub._setProperty("user", (Object)wssUsername);
                WSSPasswordCallback passwordCallback = new WSSPasswordCallback(wssPassword);
                stub._setProperty("passwordCallbackRef", (Object)passwordCallback);
            }
            if (wssTimeToLive != null) {
                WSDoAllReceiver wssReceiverHandler = new WSDoAllReceiver();
                responseHandlers.addHandler((Handler)wssReceiverHandler);
                DynamicClient.addHandlerAction((WSDoAllHandler)wssSenderHandler, "Timestamp");
                DynamicClient.addHandlerAction((WSDoAllHandler)wssReceiverHandler, "Timestamp");
                stub._setProperty("timeToLive", (Object)wssTimeToLive.toString());
            }
        }
    }

    private void applyAddressing(Stub stub, SimpleChain requestHandlers, SimpleChain responseHandlers, AddressingProperties addressingProperties) throws Exception {
        java.util.List<RelatesTo> relatesTo;
        ReferencePropertiesType referenceProperties;
        ReferenceParametersType referenceParameters;
        String faultTo;
        String replyTo;
        String to;
        String from;
        String action;
        String messageID;
        String version;
        Boolean sendDefaultTo;
        Boolean sendDefaultFrom;
        Boolean sendDefaultMessageID;
        if (addressingProperties == null) {
            return;
        }
        AddressingHandler addressingHandler = new AddressingHandler();
        requestHandlers.addHandler((Handler)addressingHandler);
        responseHandlers.addHandler((Handler)addressingHandler);
        AddressingHeaders addressingHeaders = new AddressingHeaders();
        Boolean mustUnderstand = addressingProperties.isMustUnderstand();
        if (mustUnderstand != null) {
            stub._setProperty("addressing.setMustUnderstand", (Object)mustUnderstand.toString());
        }
        if ((sendDefaultMessageID = addressingProperties.isSendDefaultMessageID()) != null) {
            stub._setProperty("addressing.sendDefaultID", (Object)sendDefaultMessageID.toString());
        }
        if ((sendDefaultFrom = addressingProperties.isSendDefaultFrom()) != null) {
            stub._setProperty("addressing.sendDefaultFrom", (Object)sendDefaultFrom.toString());
        }
        if ((sendDefaultTo = addressingProperties.isSendDefaultTo()) != null) {
            stub._setProperty("addressing.sendDefaultTo", (Object)sendDefaultTo.toString());
        }
        if ((version = addressingProperties.getVersion()) != null) {
            stub._setProperty("addressing.namespace.URI", (Object)version);
        }
        if ((messageID = addressingProperties.getMessageID()) != null) {
            addressingHeaders.setMessageID(new MessageID(new org.apache.axis.types.URI(messageID)));
        }
        if ((action = addressingProperties.getAction()) != null) {
            addressingHeaders.setAction(action);
        }
        if ((from = addressingProperties.getFrom()) != null) {
            addressingHeaders.setFrom(new EndpointReference(from));
        }
        if ((to = addressingProperties.getTo()) != null) {
            addressingHeaders.setTo(new AttributedURI(to));
        }
        if ((replyTo = addressingProperties.getReplyTo()) != null) {
            addressingHeaders.setReplyTo(new EndpointReference(replyTo));
        }
        if ((faultTo = addressingProperties.getFaultTo()) != null) {
            addressingHeaders.setFaultTo(new EndpointReference(faultTo));
        }
        if ((referenceParameters = addressingProperties.getReferenceParametersType()) != null) {
            addressingHeaders.setReferenceParameters(referenceParameters);
        }
        if ((referenceProperties = addressingProperties.getReferencePropertiesType()) != null) {
            addressingHeaders.setReferenceProperties(referenceProperties);
        }
        if ((relatesTo = addressingProperties.getRelatesTo()) != null) {
            addressingHeaders.setRelatesTo(relatesTo);
        }
        stub._setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)addressingHeaders);
    }

    private static void addHandlerAction(WSDoAllHandler handler, String action) {
        String prevAction = (String)handler.getOption("action");
        if (prevAction != null) {
            action = prevAction + " " + action;
        }
        handler.setOption("action", (Object)action);
    }

    private String getDocumentation(Element documentationElement) {
        Node child;
        String documentation = null;
        if (documentationElement != null && (child = documentationElement.getFirstChild()) != null) {
            documentation = child.getNodeValue();
        }
        return documentation;
    }

    private String getDocumentation(Definition definition) {
        if (definition == null) {
            return null;
        }
        return this.getDocumentation(definition.getDocumentationElement());
    }

    private String getDocumentation(Port port) {
        if (port == null) {
            return null;
        }
        return this.getDocumentation(port.getDocumentationElement());
    }

    private String getDocumentation(BindingOperation bindingOperation) {
        if (bindingOperation == null) {
            return null;
        }
        return this.getDocumentation(bindingOperation.getDocumentationElement());
    }

    private String getDocumentation(Operation operation) {
        if (operation == null) {
            return null;
        }
        return this.getDocumentation(operation.getDocumentationElement());
    }

    private String getDocumentation(javax.wsdl.Service service) {
        if (service == null) {
            return null;
        }
        return this.getDocumentation(service.getDocumentationElement());
    }

    private Service createLocator(ServiceEntry axisService) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String locatorClassName = axisService.getName() + "Locator";
        Class<?> locatorClass = this.classloader.loadClass(locatorClassName);
        return (Service)locatorClass.newInstance();
    }

    private Method getStubMethod(Emitter emitter, Port axisPort, Service locator) {
        Method stubMethod = null;
        String portNameJavaId = WSDLUtils.buildPortNameJavaId(emitter.getSymbolTable(), axisPort);
        try {
            stubMethod = locator.getClass().getMethod("get" + portNameJavaId, new Class[0]);
        }
        catch (Exception e) {
            logger.log(Logger.WARNING, "Port " + portNameJavaId + " not found in locator");
        }
        return stubMethod;
    }

    private Stub createStub(Method stubMethod, Service locator) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (Stub)stubMethod.invoke((Object)locator, new Object[0]);
    }

    private Object convertAbsToObj(ParameterInfo pi, AbsObject abs) throws DynamicClientException {
        Object value;
        if (pi.getMode() == 1) {
            try {
                value = pi.getTypeClass().newInstance();
            }
            catch (Exception e) {
                throw new DynamicClientException("Parameter " + pi.getName() + " error creating instance of " + pi.getTypeClass());
            }
        }
        if (pi.getMode() == 2 && pi.getPrimitiveTypeClass() != null) {
            try {
                Object holderValue = this.typeOnto.toObject(abs);
                holderValue = BasicOntology.adjustPrimitiveValue((Object)holderValue, (Class)pi.getPrimitiveTypeClass());
                value = pi.getTypeClass().newInstance();
                JavaUtils.setHolderValue(value, (Object)holderValue);
            }
            catch (Exception e) {
                throw new DynamicClientException("Parameter " + pi.getName() + " error creating instance of " + pi.getTypeClass());
            }
        }
        try {
            value = this.typeOnto.toObject(abs);
            value = BasicOntology.adjustPrimitiveValue(value, (Class)pi.getTypeClass());
            if (Calendar.class.isAssignableFrom(pi.getTypeClass())) {
                if (value instanceof String) {
                    value = ISO8601_DATE_FORMAT.parse((String)value);
                }
                if (value instanceof Date) {
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime((Date)value);
                    value = calendar;
                }
            } else if (value instanceof List && pi.getTypeClass().isArray()) {
                ArrayList jadeList = (ArrayList)value;
                Object javaArray = Array.newInstance(pi.getTypeClass().getComponentType(), jadeList.size());
                for (int i = 0; i < jadeList.size(); ++i) {
                    Array.set(javaArray, i, jadeList.get(i));
                }
                value = javaArray;
            }
        }
        catch (Exception e) {
            throw new DynamicClientException("Parameter " + pi.getName() + " error converting from abs " + abs, e);
        }
        return value;
    }

    private AbsObject convertObjToAbs(ParameterInfo pi, Object value) throws DynamicClientException {
        AbsObject absObject = null;
        if (value != null) {
            try {
                if (value instanceof Calendar && pi.getSchema().getTypeName().equals("BO_Date")) {
                    value = ((Calendar)value).getTime();
                } else if (value.getClass().isArray() && pi.getSchema().getTypeName().equals("sequence")) {
                    ArrayList jadeList = new ArrayList();
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        jadeList.add(Array.get(value, i));
                    }
                    value = jadeList;
                }
                absObject = this.typeOnto.fromObject(value);
            }
            catch (OntologyException e) {
                throw new DynamicClientException("Parameter " + pi.getName() + " error converting to abs " + value, e);
            }
        }
        return absObject;
    }

    private AbsObject getHeaderAbsValue(Stub stub, HeaderInfo hi) throws DynamicClientException {
        AbsObject absObject = null;
        String name = hi.getName();
        SOAPHeaderElement header = stub.getResponseHeader(hi.getNamespace(), name);
        if (header == null) {
            header = stub.getResponseHeader(null, name);
        }
        Object headerValue = null;
        if (header != null) {
            try {
                headerValue = header.getObjectValue(hi.getTypeClass());
            }
            catch (Exception e) {
                throw new DynamicClientException("Header " + name + " error getting value");
            }
            absObject = this.convertObjToAbs(hi, headerValue);
        }
        return absObject;
    }

    private void resetReport() {
        this.sbReport = new StringBuilder();
    }

    private void addToReport(String line) {
        this.addToReport(line, 0);
    }

    private void addToReport(String line, int tabs) {
        StringBuilder sbLine = new StringBuilder();
        for (int i = 0; i < tabs; ++i) {
            sbLine.append("\t");
        }
        sbLine.append(line);
        this.sbReport.append((CharSequence)sbLine);
        this.sbReport.append("\n");
        logger.log(Logger.FINE, sbLine.toString());
    }

    public String getReport() {
        if (this.state == State.INITIALIZED) {
            return this.sbReport.toString();
        }
        return "Dynamic client not yet initialized";
    }

    private class WSSPasswordCallback
    implements CallbackHandler {
        private String password;

        public WSSPasswordCallback(String password) {
            this.password = password;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof WSPasswordCallback)) {
                    throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
                }
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                pc.setPassword(this.password);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CREATED,
        INITIALIZED,
        INIT_FAILED;

    }
}

