/*
 * Decompiled with CFR 0.152.
 */
package jade.webservice.dynamicClient;

import jade.webservice.dynamicClient.DynamicClient;
import jade.webservice.dynamicClient.DynamicClientException;
import jade.webservice.dynamicClient.DynamicClientProperties;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class DynamicClientCache {
    private static Map<URI, DynamicClient> cachedDynamicClients = new HashMap<URI, DynamicClient>();
    private static final DynamicClientCache theInstance = new DynamicClientCache();

    public static final DynamicClientCache getInstance() {
        return theInstance;
    }

    private DynamicClientCache() {
    }

    public DynamicClient get(URI wsdl) throws DynamicClientException {
        return this.get(wsdl, null, null, null);
    }

    public DynamicClient get(URI wsdl, DynamicClientProperties properties) throws DynamicClientException {
        return this.get(wsdl, null, null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicClient get(URI wsdl, String username, String password, DynamicClientProperties properties) throws DynamicClientException {
        DynamicClient dc;
        Thread owner = null;
        Map<URI, DynamicClient> map = cachedDynamicClients;
        synchronized (map) {
            dc = cachedDynamicClients.get(wsdl);
            if (dc == null) {
                dc = new DynamicClient();
                if (properties != null) {
                    dc.setProperties(properties);
                }
                cachedDynamicClients.put(wsdl, dc);
                owner = Thread.currentThread();
            }
        }
        if (Thread.currentThread() == owner) {
            try {
                dc.initClient(wsdl, username, password);
            }
            catch (DynamicClientException dce) {
                this.remove(wsdl);
                throw dce;
            }
        } else {
            while (dc.getState() != DynamicClient.State.INITIALIZED) {
                if (dc.getState() == DynamicClient.State.INIT_FAILED) {
                    throw dc.getInitializationExceptionException();
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return dc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<URI, DynamicClient> map = cachedDynamicClients;
        synchronized (map) {
            cachedDynamicClients.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(URI wsdl) {
        Map<URI, DynamicClient> map = cachedDynamicClients;
        synchronized (map) {
            cachedDynamicClients.remove(wsdl);
        }
    }

    public DynamicClient update(URI wsdl) throws DynamicClientException {
        return this.update(wsdl, null, null, null);
    }

    public DynamicClient update(URI wsdl, DynamicClientProperties properties) throws DynamicClientException {
        return this.update(wsdl, null, null, properties);
    }

    public DynamicClient update(URI wsdl, String username, String password, DynamicClientProperties properties) throws DynamicClientException {
        this.remove(wsdl);
        return this.get(wsdl, username, password, properties);
    }

    public static void setTrustStore(String trustStore) {
        DynamicClient.setTrustStore(trustStore);
    }

    public static void setTrustStorePassword(String trustStorePassword) {
        DynamicClient.setTrustStorePassword(trustStorePassword);
    }

    public static void disableCertificateChecking() {
        DynamicClient.disableCertificateChecking();
    }

    public static void enableCertificateChecking() {
        DynamicClient.enableCertificateChecking();
    }

    public static void setProxyHost(String proxyHost) {
        DynamicClient.setProxyHost(proxyHost);
    }

    public static void setProxyPort(String proxyPort) {
        DynamicClient.setProxyPort(proxyPort);
    }

    public static void setNonProxyHosts(String nonProxyHosts) {
        DynamicClient.setNonProxyHosts(nonProxyHosts);
    }

    public static void setProxyAuthentication(String proxyUser, String proxyPassword) {
        DynamicClient.setProxyAuthentication(proxyUser, proxyPassword);
    }
}

