/*
 * Decompiled with CFR 0.152.
 */
package jade.webservice.dynamicClient;

import jade.content.onto.OntologyException;
import jade.content.schema.AggregateSchema;
import jade.content.schema.PrimitiveSchema;
import jade.content.schema.TermSchema;
import jade.webservice.dynamicClient.DynamicClient;
import jade.webservice.dynamicClient.HeaderInfo;
import jade.webservice.dynamicClient.OperationInfo;
import jade.webservice.dynamicClient.ParameterInfo;
import jade.webservice.dynamicClient.PortInfo;
import jade.webservice.dynamicClient.ServiceInfo;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URI;
import java.util.HashMap;

public class DynamicClientShell {
    private static DynamicClient dc;
    private static ServiceInfo service;
    private static PortInfo port;
    private static OperationInfo operation;
    private static String wsdlHttpUsername;
    private static String wsdlHttpPassword;
    private static String proxyHost;
    private static String proxyPort;
    private static String proxyUsername;
    private static String proxyPassword;
    private static String trustStore;
    private static String trustStorePassword;
    private static boolean disableCertificateChecking;
    private static URI wsdl;
    private static String httpUsername;
    private static String httpPassword;
    private static String wssUsername;
    private static String wssPassword;
    private static String wssPasswordType;
    private static String wssTimeToLive;
    private static String wssMustUnderstand;
    private static String endpoint;
    private static String timeout;
    private static int varIndex;

    public static void main(String[] args) {
        dc = new DynamicClient();
        try {
            URI wsdl = DynamicClientShell.parseArguments(args);
            if (wsdl != null) {
                dc.initClient(wsdl);
                DynamicClientShell.writeLine();
                DynamicClientShell.writeLine();
                DynamicClientShell.writeLine("---------------------------");
                DynamicClientShell.writeLine("-- DynamicClient Shell --");
                DynamicClientShell.writeLine("---------------------------");
                DynamicClientShell.mainMenu();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void mainMenu() {
        while (true) {
            DynamicClientShell.writeLine();
            DynamicClientShell.writeLine("Main menu'");
            DynamicClientShell.writeLine("1) Show report");
            DynamicClientShell.writeLine("2) Navigate services");
            DynamicClientShell.writeLine("x) Exit");
            String choice = DynamicClientShell.readLine("Choice? ");
            DynamicClientShell.writeLine();
            if ("1".equalsIgnoreCase(choice)) {
                DynamicClientShell.writeLine(dc.getReport());
                continue;
            }
            if ("2".equalsIgnoreCase(choice)) {
                DynamicClientShell.servicesMenu();
                continue;
            }
            if (!"x".equalsIgnoreCase(choice)) continue;
            DynamicClientShell.exit();
        }
    }

    private static void servicesMenu() {
        boolean back = false;
        while (!back) {
            DynamicClientShell.writeLine();
            DynamicClientShell.writeLine("Services list");
            int i = 1;
            HashMap<Integer, String> services = new HashMap<Integer, String>();
            for (String serviceName : dc.getServiceNames()) {
                DynamicClientShell.writeLine(i + ") -> " + serviceName);
                services.put(i, serviceName);
                ++i;
            }
            DynamicClientShell.writeLine("b) Go back");
            DynamicClientShell.writeLine("x) Exit");
            String choice = DynamicClientShell.readLine("Choice? ");
            DynamicClientShell.writeLine();
            if ("x".equalsIgnoreCase(choice)) {
                DynamicClientShell.exit();
                continue;
            }
            if ("b".equalsIgnoreCase(choice)) {
                back = true;
                continue;
            }
            int pos = DynamicClientShell.getInt(choice);
            if (pos <= 0 || pos >= i) continue;
            service = dc.getService((String)services.get(pos));
            DynamicClientShell.portsMenu();
        }
    }

    private static void portsMenu() {
        boolean back = false;
        while (!back) {
            DynamicClientShell.writeLine();
            DynamicClientShell.writeLine("Ports list");
            int i = 1;
            HashMap<Integer, String> ports = new HashMap<Integer, String>();
            for (String portName : service.getPortNames()) {
                DynamicClientShell.writeLine(i + ") -> " + portName);
                ports.put(i, portName);
                ++i;
            }
            DynamicClientShell.writeLine("b) Go back");
            DynamicClientShell.writeLine("x) Exit");
            String choice = DynamicClientShell.readLine("Choice? ");
            DynamicClientShell.writeLine();
            if ("x".equalsIgnoreCase(choice)) {
                DynamicClientShell.exit();
                continue;
            }
            if ("b".equalsIgnoreCase(choice)) {
                back = true;
                continue;
            }
            int pos = DynamicClientShell.getInt(choice);
            if (pos <= 0 || pos >= i) continue;
            port = service.getPort((String)ports.get(pos));
            DynamicClientShell.operationsMenu();
        }
    }

    private static void operationsMenu() {
        boolean back = false;
        while (!back) {
            DynamicClientShell.writeLine();
            DynamicClientShell.writeLine("Operations list");
            int i = 1;
            HashMap<Integer, String> ops = new HashMap<Integer, String>();
            for (String opName : port.getOperationNames()) {
                DynamicClientShell.writeLine(i + ") -> " + opName);
                ops.put(i, opName);
                ++i;
            }
            DynamicClientShell.writeLine("b) Go back");
            DynamicClientShell.writeLine("x) Exit");
            String choice = DynamicClientShell.readLine("Choice? ");
            DynamicClientShell.writeLine();
            if ("x".equalsIgnoreCase(choice)) {
                DynamicClientShell.exit();
                continue;
            }
            if ("b".equalsIgnoreCase(choice)) {
                back = true;
                continue;
            }
            int pos = DynamicClientShell.getInt(choice);
            if (pos <= 0 || pos >= i) continue;
            operation = port.getOperation((String)ops.get(pos));
            DynamicClientShell.operationMenu();
        }
    }

    private static void operationMenu() {
        boolean back = false;
        while (!back) {
            DynamicClientShell.writeLine();
            DynamicClientShell.writeLine("Operation (" + operation.getName() + ") menu'");
            DynamicClientShell.writeLine("1) Show input parameters");
            DynamicClientShell.writeLine("2) Show output parameters");
            DynamicClientShell.writeLine("3) Show java-code");
            DynamicClientShell.writeLine("4) Write java-code");
            DynamicClientShell.writeLine("b) Go back");
            DynamicClientShell.writeLine("x) Exit");
            String choice = DynamicClientShell.readLine("Choice? ");
            DynamicClientShell.writeLine();
            if ("1".equalsIgnoreCase(choice)) {
                DynamicClientShell.showInput();
                continue;
            }
            if ("2".equalsIgnoreCase(choice)) {
                DynamicClientShell.showOutput();
                continue;
            }
            if ("3".equalsIgnoreCase(choice)) {
                try {
                    DynamicClientShell.showCode();
                }
                catch (OntologyException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("4".equalsIgnoreCase(choice)) {
                try {
                    DynamicClientShell.writeCode();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("b".equalsIgnoreCase(choice)) {
                back = true;
                continue;
            }
            if (!"x".equalsIgnoreCase(choice)) continue;
            DynamicClientShell.exit();
        }
    }

    private static void showInput() {
        DynamicClientShell.writeLine("Parameters:");
        for (String parameterName : operation.getInputParameterNames()) {
            ParameterInfo parameter = operation.getInputParameter(parameterName);
            DynamicClientShell.writeLine("- " + parameter.toString());
        }
        if (!operation.getInputHeaderNames().isEmpty()) {
            DynamicClientShell.writeLine();
            DynamicClientShell.writeLine("Headers:");
            for (String headerName : operation.getInputHeaderNames()) {
                HeaderInfo header = operation.getInputHeader(headerName);
                DynamicClientShell.writeLine("- " + header.toString());
            }
        }
        DynamicClientShell.writeLine();
    }

    private static void showOutput() {
        DynamicClientShell.writeLine("Parameters:");
        for (String parameterName : operation.getOutputParameterNames()) {
            ParameterInfo parameter = operation.getOutputParameter(parameterName);
            DynamicClientShell.writeLine("- " + parameter.toString());
        }
        if (!operation.getOutputHeaderNames().isEmpty()) {
            DynamicClientShell.writeLine();
            DynamicClientShell.writeLine("Headers:");
            for (String headerName : operation.getOutputHeaderNames()) {
                HeaderInfo header = operation.getOutputHeader(headerName);
                DynamicClientShell.writeLine("- " + header.toString());
            }
        }
        DynamicClientShell.writeLine();
    }

    private static String getCode() throws OntologyException {
        StringBuilder sbAbs;
        varIndex = 1;
        StringBuilder sb = new StringBuilder();
        sb.append("import jade.content.abs.AbsConcept;\n");
        sb.append("import jade.content.abs.AbsPrimitive;\n");
        sb.append("import jade.content.abs.AbsAggregate;\n");
        sb.append("import jade.webservice.dynamicClient.DynamicClient;\n");
        sb.append("import jade.webservice.dynamicClient.SecurityProperties;\n");
        sb.append("import jade.webservice.dynamicClient.WSData;\n");
        sb.append("import java.net.URI;\n");
        sb.append("import java.net.URL;\n");
        sb.append("import java.util.Date;\n");
        sb.append("\n");
        sb.append("public class Test {\n");
        sb.append("\tpublic static void main(String[] args) {\n");
        sb.append("\t\ttry {\n");
        sb.append("\t\t\tDynamicClient dc = new DynamicClient();\n");
        if (proxyHost != null) {
            sb.append("\t\t\tdc.setProxyHost(\"" + proxyHost + "\");\n");
        }
        if (proxyPort != null) {
            sb.append("\t\t\tdc.setProxyPort(\"" + proxyPort + "\");\n");
        }
        if (proxyUsername != null && proxyPassword != null) {
            sb.append("\t\t\tdc.setProxyAuthentication(\"" + proxyUsername + "\", \"" + proxyPassword + "\");\n");
        }
        if (trustStore != null) {
            sb.append("\t\t\tdc.setTrustStore(\"" + trustStore + "\");\n");
        }
        if (trustStorePassword != null) {
            sb.append("\t\t\tdc.setTrustStorePassword(\"" + trustStorePassword + "\");\n");
        }
        if (disableCertificateChecking) {
            sb.append("\t\t\tdc.disableCertificateChecking();\n");
        }
        sb.append("\n");
        if (wsdlHttpUsername != null && wsdlHttpPassword != null) {
            sb.append("\t\t\tdc.initClient(new URI(\"" + wsdl + "\"), \"" + wsdlHttpUsername + "\", \"" + wsdlHttpPassword + "\");\n");
        } else {
            sb.append("\t\t\tdc.initClient(new URI(\"" + wsdl + "\"));\n");
        }
        sb.append("\n");
        boolean spPresent = false;
        if (httpUsername != null || httpPassword != null || wssUsername != null || wssPassword != null || wssPasswordType != null || wssTimeToLive != null || wssMustUnderstand != null) {
            sb.append("\t\t\tSecurityProperties sp = new SecurityProperties();\n");
            if (httpUsername != null) {
                sb.append("\t\t\tsp.setHttpUsername(\"" + httpUsername + "\");\n");
            }
            if (httpPassword != null) {
                sb.append("\t\t\tsp.setHttpPassword(\"" + httpPassword + "\");\n");
            }
            if (wssUsername != null) {
                sb.append("\t\t\tsp.setWSSUsername(\"" + wssUsername + "\");\n");
            }
            if (wssPassword != null) {
                sb.append("\t\t\tsp.setWSSPassword(\"" + wssPassword + "\");\n");
            }
            if (wssPasswordType != null) {
                sb.append("\t\t\tsp.setWSSPasswordType(\"" + wssPasswordType + "\");\n");
            }
            if (wssTimeToLive != null) {
                sb.append("\t\t\tsp.setWSSTimeToLive(" + Integer.parseInt(wssTimeToLive) + ");\n");
            }
            if (wssMustUnderstand != null) {
                sb.append("\t\t\tsp.setWSSMustUnderstand(" + Boolean.parseBoolean(wssMustUnderstand) + ");\n");
            }
            sb.append("\n");
            spPresent = true;
        }
        sb.append("\t\t\tWSData input = new WSData();\n");
        sb.append("\n");
        StringBuilder sbInput = new StringBuilder();
        for (String parameterName : operation.getInputParameterNames()) {
            ParameterInfo parameter = operation.getInputParameter(parameterName);
            sbAbs = new StringBuilder();
            String paramValue = DynamicClientShell.getCode4Schema(parameter.getSchema(), sbAbs);
            if (sbAbs.length() > 0) {
                sb.append((CharSequence)sbAbs);
            }
            String opt = "";
            if (!parameter.isMandatory()) {
                opt = "  // Optional";
            }
            sbInput.append("\t\t\tinput.setParameter(\"" + parameter.getName() + "\", " + paramValue + ");" + opt + "\n");
        }
        if (sbInput.length() > 0) {
            sb.append((CharSequence)sbInput);
            sb.append("\n");
        }
        sbInput = new StringBuilder();
        for (String headerName : operation.getInputHeaderNames()) {
            HeaderInfo header = operation.getInputHeader(headerName);
            sbAbs = new StringBuilder();
            String headerValue = DynamicClientShell.getCode4Schema(header.getSchema(), sbAbs);
            if (sbAbs.length() > 0) {
                sb.append((CharSequence)sbAbs);
            }
            sbInput.append("\t\t\tinput.setHeader(\"" + header.getName() + "\", " + headerValue + ");\n");
        }
        if (sbInput.length() > 0) {
            sb.append((CharSequence)sbInput);
            sb.append("\n");
        }
        if (dc.getServiceNames().size() > 1 || service.getPortNames().size() > 1 || spPresent || endpoint != null || timeout != null) {
            String serviceName = "null";
            if (dc.getServiceNames().size() > 1) {
                serviceName = "\"" + service.getName() + "\"";
            }
            String portName = "null";
            if (service.getPortNames().size() > 1) {
                portName = "\"" + port.getName() + "\"";
            }
            String opName = "\"" + operation.getName() + "\"";
            String urlEndpoint = "null";
            if (endpoint != null) {
                urlEndpoint = "new URL(\"" + endpoint + "\")";
            }
            String timeoutValue = "0";
            if (timeout != null) {
                timeoutValue = timeout;
            }
            String sp = "null";
            if (spPresent) {
                sp = "sp";
            }
            sb.append("\t\t\tWSData output = dc.invoke(" + serviceName + ", " + portName + ", " + opName + ", " + urlEndpoint + ", " + timeoutValue + ", " + sp + ", input);\n");
        } else {
            sb.append("\t\t\tWSData output = dc.invoke(\"" + operation.getName() + "\", input);\n");
        }
        sb.append("\n");
        sb.append("\t\t} catch(Exception e) {\n");
        sb.append("\t\t\te.printStackTrace();\n");
        sb.append("\t\t}\n");
        sb.append("\t}\n");
        sb.append("}\n");
        return sb.toString();
    }

    private static void showCode() throws OntologyException {
        DynamicClientShell.writeLine();
        DynamicClientShell.writeLine(DynamicClientShell.getCode());
    }

    private static void writeCode() throws OntologyException, IOException {
        FileWriter outFile = new FileWriter("Test.java");
        PrintWriter out = new PrintWriter(outFile);
        out.println(DynamicClientShell.getCode());
        out.close();
        DynamicClientShell.writeLine();
        DynamicClientShell.writeLine("<Test.java> successfully written");
    }

    private static String getCode4Schema(TermSchema schema, StringBuilder sbAbs) throws OntologyException {
        if (schema instanceof PrimitiveSchema) {
            String value = null;
            if (schema.getTypeName() == "BO_String") {
                value = "\"aaa\"";
            } else if (schema.getTypeName() == "BO_Integer") {
                value = "999";
            } else if (schema.getTypeName() == "BO_Float") {
                value = "999.9f";
            } else if (schema.getTypeName() == "BO_Boolean") {
                value = "true";
            } else if (schema.getTypeName() == "BO_Date") {
                value = "new Date()";
            } else if (schema.getTypeName() == "BO_Byte-sequence") {
                value = "new byte[] {0,1}";
            }
            return value;
        }
        String varName = DynamicClientShell.generateAbsVariable();
        if (schema instanceof AggregateSchema) {
            StringBuilder sbAgg = new StringBuilder();
            TermSchema elementsSchema = ((AggregateSchema)schema).getElementsSchema();
            String aggElem = DynamicClientShell.getCode4Schema(elementsSchema, sbAgg);
            if (elementsSchema instanceof PrimitiveSchema) {
                aggElem = "AbsPrimitive.wrap(" + aggElem + ")";
            }
            if (sbAgg.length() > 0) {
                sbAbs.append((CharSequence)sbAgg);
            }
            sbAbs.append("\t\t\tAbsAggregate " + varName + " = new AbsAggregate(\"" + schema.getTypeName() + "\");\n");
            sbAbs.append("\t\t\t" + varName + ".add(" + aggElem + ");\n");
            sbAbs.append("\n");
            return varName;
        }
        StringBuilder sbCon = new StringBuilder();
        sbCon.append("\t\t\tAbsConcept " + varName + " = new AbsConcept(\"" + schema.getTypeName() + "\");\n");
        for (String slotName : schema.getNames()) {
            StringBuilder sbSlot = new StringBuilder();
            String slotValue = DynamicClientShell.getCode4Schema((TermSchema)schema.getSchema(slotName), sbSlot);
            String opt = "";
            if (!schema.isMandatory(slotName)) {
                opt = "  // Optional";
            }
            sbCon.append("\t\t\t" + varName + ".set(\"" + slotName + "\", " + slotValue + ");" + opt + "\n");
            if (sbSlot.length() <= 0) continue;
            sbAbs.append((CharSequence)sbSlot);
        }
        sbAbs.append((CharSequence)sbCon);
        sbAbs.append("\n");
        return varName;
    }

    private static String generateAbsVariable() {
        return "abs" + varIndex++;
    }

    private static void exit() {
        DynamicClientShell.writeLine("Goodbye!");
        DynamicClientShell.writeLine();
        System.exit(0);
    }

    private static URI parseArguments(String[] args) throws Exception {
        if (args == null || args.length < 1) {
            DynamicClientShell.printUsage();
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equalsIgnoreCase("-help")) {
                    DynamicClientShell.printUsage();
                    return null;
                }
                if (args[i].equalsIgnoreCase("-wsdl-http-username")) {
                    if (++i < args.length) {
                        wsdlHttpUsername = args[i];
                        dc.setDefaultHttpUsername(wsdlHttpUsername);
                        continue;
                    }
                    throw new IllegalArgumentException("No username specified after \"-wsdl-http-username\" option");
                }
                if (args[i].equalsIgnoreCase("-wsdl-http-password")) {
                    if (++i < args.length) {
                        wsdlHttpPassword = args[i];
                        dc.setDefaultHttpPassword(wsdlHttpPassword);
                        continue;
                    }
                    throw new IllegalArgumentException("No username specified after \"-wsdl-http-password\" option");
                }
                if (args[i].equalsIgnoreCase("-proxy-host")) {
                    if (++i < args.length) {
                        proxyHost = args[i];
                        DynamicClient.setProxyHost(proxyHost);
                        continue;
                    }
                    throw new IllegalArgumentException("No host specified after \"-proxy-host\" option");
                }
                if (args[i].equalsIgnoreCase("-proxy-port")) {
                    if (++i < args.length) {
                        proxyPort = args[i];
                        DynamicClient.setProxyPort(proxyPort);
                        continue;
                    }
                    throw new IllegalArgumentException("No port specified after \"-proxy-port\" option");
                }
                if (args[i].equalsIgnoreCase("-proxy-username")) {
                    if (++i < args.length) {
                        proxyUsername = args[i];
                        if (proxyUsername == null || proxyPassword == null) continue;
                        DynamicClient.setProxyAuthentication(proxyUsername, proxyPassword);
                        continue;
                    }
                    throw new IllegalArgumentException("No username specified after \"-proxy-username\" option");
                }
                if (args[i].equalsIgnoreCase("-proxy-password")) {
                    if (++i < args.length) {
                        proxyPassword = args[i];
                        if (proxyUsername == null || proxyPassword == null) continue;
                        DynamicClient.setProxyAuthentication(proxyUsername, proxyPassword);
                        continue;
                    }
                    throw new IllegalArgumentException("No password specified after \"-proxy-password\" option");
                }
                if (args[i].equalsIgnoreCase("-ssl-trust-store")) {
                    if (++i < args.length) {
                        trustStore = args[i];
                        DynamicClient.setTrustStore(trustStore);
                        continue;
                    }
                    throw new IllegalArgumentException("No trust store specified after \"-ssl-trust-store\" option");
                }
                if (args[i].equalsIgnoreCase("-ssl-trust-store-password")) {
                    if (++i < args.length) {
                        trustStorePassword = args[i];
                        DynamicClient.setTrustStorePassword(trustStorePassword);
                        continue;
                    }
                    throw new IllegalArgumentException("No trust store password specified after \"-ssl-trust-store-password\" option");
                }
                if (args[i].equalsIgnoreCase("-ssl-disable")) {
                    disableCertificateChecking = true;
                    dc.disableCertificateChecking();
                    continue;
                }
                if (args[i].equalsIgnoreCase("-http-username")) {
                    if (++i < args.length) {
                        httpUsername = args[i];
                        continue;
                    }
                    throw new IllegalArgumentException("No username specified after \"-http-username\" option");
                }
                if (args[i].equalsIgnoreCase("-http-password")) {
                    if (++i < args.length) {
                        httpPassword = args[i];
                        continue;
                    }
                    throw new IllegalArgumentException("No password specified after \"-http-password\" option");
                }
                if (args[i].equalsIgnoreCase("-wss-username")) {
                    if (++i < args.length) {
                        wssUsername = args[i];
                        continue;
                    }
                    throw new IllegalArgumentException("No username specified after \"-wss-username\" option");
                }
                if (args[i].equalsIgnoreCase("-wss-password")) {
                    if (++i < args.length) {
                        wssPassword = args[i];
                        continue;
                    }
                    throw new IllegalArgumentException("No password specified after \"-wss-password\" option");
                }
                if (args[i].equalsIgnoreCase("-wss-password-type")) {
                    if (++i < args.length) {
                        wssPasswordType = args[i];
                        continue;
                    }
                    throw new IllegalArgumentException("No password type specified after \"-wss-password-type\" option");
                }
                if (args[i].equalsIgnoreCase("-wss-time-to-live")) {
                    if (++i < args.length) {
                        wssTimeToLive = args[i];
                        continue;
                    }
                    throw new IllegalArgumentException("No time to live specified after \"-wss-time-to-live\" option");
                }
                if (args[i].equalsIgnoreCase("-wss-must-understand")) {
                    if (++i < args.length) {
                        wssMustUnderstand = args[i];
                        continue;
                    }
                    throw new IllegalArgumentException("No must understand flag specified after \"-wss-must-understand\" option");
                }
                if (args[i].equalsIgnoreCase("-endpoint")) {
                    if (++i < args.length) {
                        endpoint = args[i];
                        continue;
                    }
                    throw new IllegalArgumentException("No url of endpoint specified after \"-endpoint\" option");
                }
                if (!args[i].equalsIgnoreCase("-timeout")) continue;
                if (++i < args.length) {
                    timeout = args[i];
                    continue;
                }
                throw new IllegalArgumentException("No timeout value specified after \"-timeout\" option");
            }
            wsdl = new URI(args[i]);
        }
        return wsdl;
    }

    private static void printUsage() {
        System.out.println("Usage: DynamicClientShell wsdl [options]");
        System.out.println();
        System.out.println("Options:");
        System.out.println("    -wsdl-http-username <http basic authentication username to discover wsdl>");
        System.out.println("    -wsdl-http-password <http basic authentication password to discover wsdl>");
        System.out.println("    -http-username <http basic authentication username to invoke service>");
        System.out.println("    -http-password <http basic authentication password to invoke service>");
        System.out.println("    -wss-username <WS-Security username token profile>");
        System.out.println("    -wss-password <WS-Security password token profile>");
        System.out.println("    -wss-password-type <WS-Security password type token profile> (default: PasswordText)");
        System.out.println("    -wss-must-understand <WS-Security must understand flag> (true/false)");
        System.out.println("    -wss-time-to-live <WS-Security-Timestamp, LifeTime in seconds>");
        System.out.println("    -proxy-host <proxy host>");
        System.out.println("    -proxy-port <proxy port>");
        System.out.println("    -proxy-username <proxy username>");
        System.out.println("    -proxy-password <proxy password>");
        System.out.println("    -ssl-trust-store <SSL trust store file>");
        System.out.println("    -ssl-trust-store-password <SSL trust store password>");
        System.out.println("    -ssl-disable");
        System.out.println("    -endpoint <endpoint url>");
        System.out.println("    -timeout <invokation timeout in ms> (0 = no timeout)");
        System.out.println();
    }

    private static String readLine(String text) {
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        try {
            DynamicClientShell.write(text);
            line = input.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        if (line == null || line.equals("")) {
            line = null;
        }
        return line;
    }

    private static int getInt(String text) {
        try {
            return Integer.parseInt(text);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static void writeLine() {
        DynamicClientShell.writeLine("", 0);
    }

    private static void writeLine(String text) {
        DynamicClientShell.writeLine(text, 0);
    }

    private static void writeLine(String text, int indentLevel) {
        if (text != null) {
            DynamicClientShell.write(text, indentLevel);
            System.out.println();
        }
    }

    private static void write(String text) {
        DynamicClientShell.write(text, 0);
    }

    private static void write(String text, int indentLevel) {
        if (text != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append(text);
            System.out.print(sb.toString());
        }
    }

    static {
        disableCertificateChecking = false;
    }
}

